
package org.lsst.ccs.subsystems.fcs.ui.jas;

import java.io.IOException;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.Agent;
import org.lsst.ccs.subsystems.fcs.ui.FcsGUI;


/**
 * A JAS plugin for the GUI to control and monitor the fcs with all the hardware.
 * @author virieux
 */
public class FcsJasPlugin extends Plugin {

    private FcsGUI fcsGUI;
    private FreeHEPLookup lookup;

    @Override
    protected void init() throws IOException {
    }

    @Override
    protected void postInit() {
        super.postInit();
        fcsGUI = new FcsGUI("FcsGUI", "org.lsst.ccs.subsystem.fcs.wholefcs", Agent.getEnvironmentMessagingAccess());
        fcsGUI.initGui();
        this.getApplication().getPageManager().openPage(fcsGUI.getGuiLayout(), "FCS GUI", null);
        Studio studio = (Studio) Studio.getApplication();
        lookup = studio.getLookup();
        lookup.add(this);
    }

}
