
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.StatusMessageListener;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * This panel presents FCS hardware with a split panel.
 * (JSplitPane.VERTICAL_SPLIT) 
 * - On the top panel : the subsystem state. 
 * - On the bottom panel : a HORIZONTAL split panel, 
 *     - with a left component which is a tree.
 *     - with a right component which is a JPanel.
 *
 * @author virieux
 */
public class GeneralPanel extends JPanel implements StatusMessageListener {
    private static final long serialVersionUID = -1056620058636291687L;

    protected GeneralGUI subs; 
    private final SubsystemPanel subsystemPanel;
    private final BottomPanel bottomPanel;
    private final JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);


    public GeneralPanel(GeneralGUI subs, BottomPanel bottomPanel) {
        this.subs = subs;
        this.subsystemPanel = new SubsystemPanel(subs.destination);
        this.subsystemPanel.setSubsystem(subs);
        this.bottomPanel = bottomPanel;
        initComponents();
    }

    public SubsystemPanel getSubsystemPanel() {
        return subsystemPanel;
    }
    
    
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) 
            throws InterruptedException, InvocationTargetException {
        this.subsystemPanel.initializeGui(configInfo);
        this.bottomPanel.initializeGUIWithConfigInfo(configInfo, hardwareList);
    }
    
    public void initializeGUIWithLoaderConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) 
            throws InterruptedException, InvocationTargetException {
        this.bottomPanel.initializeGUIWithLoaderConfigInfo(configInfo, hardwareList);
    }

    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) 
            throws InterruptedException, InvocationTargetException {
        this.bottomPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
    }

    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {

        JScrollPane bottomScrollPane = new JScrollPane(bottomPanel);

        //Add the scroll panes to a split Panel.       
        splitPane.setTopComponent(this.subsystemPanel);
        splitPane.setBottomComponent(bottomScrollPane);

        //Whole Panel
        setLayout(new GridBagLayout());
        setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(splitPane, gbc);
        //end Whole Panel
    }
    
    @Override
    public void onStatusMessage(StatusMessage msg) {
        this.bottomPanel.onStatusMessage(msg);
    }
    
    /**
     * Reset the Panel with initial values and colors.
     */
    void resetPanel() {
        this.bottomPanel.resetPanel();
    }

}
