
package org.lsst.ccs.subsystems.fcs.testbench.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

/**
 *
 * @author virieux
 */
public class TestbenchLPCGUI extends GeneralGUI {
    private static final long serialVersionUID = -8601334693518407294L;
    String stateCorrelId;

    /**
     * 
     * @param name
     * @param role
     * @param aml 
     */
    public TestbenchLPCGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        TestbenchLPCGatherPanel lpcGatherPanel;
        lpcGatherPanel = new TestbenchLPCGatherPanel(this, CHANGER_TCPPROXY_NAME);
        TestbenchLPCBottomPanel lpcBottomPanel = new TestbenchLPCBottomPanel(lpcGatherPanel, "LPC_Testbench");
        this.generalPanel = new GeneralPanel(this, lpcBottomPanel);
        pane = new JScrollPane(generalPanel);
    }
           
    
     /**
      * for the tests
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("TestbenchLPCGUI", AgentInfo.AgentType.CONSOLE);
        TestbenchLPCGUI t = new TestbenchLPCGUI(agent.getName(), "testbenchLPC", 
                agent.getMessagingAccess());
        agent.start();

        JFrame frame = new JFrame("Testbench LPC GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }


    
}
