/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;

/**
 *
 * @author virieux
 */
public class SingleFilterTestGatherPanel extends GatherPanel {
    
    private static final long serialVersionUID = 7457785896732960334L;

    
    
    private static final String CLAMPXMINUS_NAME = "clampXminus";
    private static final String CLAMPXPLUS_NAME = "clampXplus";
    
    //CANopen devices panels
    private CanOpenDevicePanel ai814Panel;
    private CanOpenDevicePanel ao412Panel;
    private CanOpenDevicePanel dio8n1Panel;
    private CanOpenDevicePanel dio8n2Panel;
    private EPOSControllerPanel clampXminusControllerPanel;
    private EPOSControllerPanel clampXplusControllerPanel;
    
    //SFT Main Panel
    SingleFilterTestExchangePanel sftExchangePanel;




    /**
     * Initialization of the GUI for data stored in tcpConfiguration. *
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        /**
         * Create a new GuiInitialization from a ConfigurationInfo.
         * @param configInfo 
         */
        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo =configInfo;
        }

        @Override
        public void run() {
            /**
             * ClampXminus Controller Panel *
             */
            clampXminusControllerPanel.initializeGui(configInfo);
            
            /**
             * ClampXplus Controller Panel *
             */
            clampXplusControllerPanel.initializeGui(configInfo);
           
            /**
             * ai814 Panel *
             */
            ai814Panel.initializeGui(configInfo);
            
            /**
             * ao412*
             */
            ao412Panel.initializeGui(configInfo);
            
            /**
             * CANOpen DIO Panels*
             */
            dio8n1Panel.initializeGui(configInfo);
            dio8n2Panel.initializeGui(configInfo);
            
            
        }
    }
    
    

    public SingleFilterTestGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        setName("SingleFilterTestGatherPanel");
        initPanels();
    }
    
    public SingleFilterTestGatherPanel(SingleFilterTestGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        setName("SingleFilterTestGatherPanel");
        initPanels();


    }


    public CanOpenDevicePanel getAi814Panel() {
        return ai814Panel;
    }

    public CanOpenDevicePanel getAo412Panel() {
        return ao412Panel;
    }

    public CanOpenDevicePanel getDio8n1Panel() {
        return dio8n1Panel;
    }

    public CanOpenDevicePanel getDio8n2Panel() {
        return dio8n2Panel;
    }

    public EPOSControllerPanel getClampXminusControllerPanel() {
        return clampXminusControllerPanel;
    }

    public EPOSControllerPanel getClampXplusControllerPanel() {
        return clampXplusControllerPanel;
    }

    public SingleFilterTestExchangePanel getSftExchangePanel() {
        return sftExchangePanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, 
            List<String> hardwareNames)  {
        super.initializeGUIWithConfigInfo(configInfo,hardwareNames);
        sftExchangePanel.initializeGui(configInfo);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    

    public void updateClamp(StatusDataPublishedByCarouselClamp status) {
        sftExchangePanel.updateClamp(status);
    }

    public void updateLatch(StatusDataPublishedByAutochangerLatch status) {
        sftExchangePanel.updateLatch(status);
    }

    public void updateAutoChanger(StatusDataPublishedByBasicAutoChanger status) {
        sftExchangePanel.updateAutoChanger(status);
    }

    public void updateCarousel(StatusDataPublishedByCarousel status) {
        sftExchangePanel.updateCarousel(status);
    }

    public void updateActuator(StatusDataPublishedByClampActuator status) {
        sftExchangePanel.updateActuator(status);
    }

    @Override
    public void updateFromStatusData(KeyValueData data) {
 
            switch (data.getKey()) {
                case "tcpProxy":
                    updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
                    break;
                                
                                
                case CLAMPXMINUS_NAME:
                    FCSLOG.debug(getName() + " read data dataType: " + data.getKey());
                    updateClamp((StatusDataPublishedByCarouselClamp) data.getValue());
                    break;
                    
                case CLAMPXPLUS_NAME:
                    FCSLOG.debug(getName() + " read data dataType: " + data.getKey());
                    updateClamp((StatusDataPublishedByCarouselClamp) data.getValue());
                    break;    

                case "actuator":
                    FCSLOG.debug(getName() + " read data dataType:actuator");
                    updateActuator((StatusDataPublishedByClampActuator) data.getValue());
                    break;

                case "carousel":
                    FCSLOG.debug(getName() + " read data dataType:carousel");
                    updateCarousel((StatusDataPublishedByCarousel) data.getValue());
                    break;

                case "autochangerLatch":
                    FCSLOG.debug(getName() + " read data dataType:autochangerLatch");
                    updateLatch((StatusDataPublishedByAutochangerLatch) data.getValue());
                    break;

                case "autochanger":
                    FCSLOG.debug(getName() + " read data dataType:autochanger");
                    updateAutoChanger((StatusDataPublishedByBasicAutoChanger) data.getValue());
                    break;

                default:
                    FCSLOG.warning(getName() + " An unexpected dataType was read on the status bus:" + data.getKey());
                    break;

            }
    }
    
    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        sftExchangePanel.initializeGui(configInfo);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    
    private void initPanels() {
        //CANOpen CAN-CBX-AI420
        ai814Panel = new CanOpenDevicePanel("ai814");
        ao412Panel = new CanOpenDevicePanel("ao412");
        
        /** CANOpen DIO for the latches*/
        dio8n1Panel = new CanOpenDevicePanel("dio8n1");
        dio8n2Panel = new CanOpenDevicePanel("dio8n2");
        
        //controllers Panels
        clampXminusControllerPanel = new EPOSControllerPanel("clampXminusController");
        clampXplusControllerPanel = new EPOSControllerPanel("clampXplusController");

        /** Filter Exchange Panel*/
        this.sftExchangePanel = new SingleFilterTestExchangePanel();
    }
    
            

                        

    
}
