/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.ColoredObject;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.ZERO_VALUE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A Panel to represent an analogic sensor like those are used for Carousel clamps.
 * @author virieux
 */
public class AnalogicSensorPanel extends JPanel {
    private static final long serialVersionUID = -1531790094506697510L;
    
    private String clampName = "clampName";
    private String sensorName = "sensorName";
    private final int orientation;
    private JLabel nameLabel;
    private JLabel stateLabel;
    private JProgressBar progressBar;
    private DigitalSwitch sensorSwitch;
    private JPanel paramsPanel;

    private final JLabel valueALabel = new JLabel(ZERO_VALUE);
    private final JLabel valueBLabel = new JLabel(ZERO_VALUE);
    private final JLabel valueCLabel = new JLabel(ZERO_VALUE);

    public AnalogicSensorPanel(String clampName, String sensorName, int orientation) {
        this.clampName = clampName;
        this.sensorName = sensorName;
        this.orientation = orientation;
        initComponents();
    }
    
    /**
     * Initialize the GUI with the configuration data.
     * 
     * @param configInfo
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        Map<String, String> config = configInfo.getCurrentValuesFor(clampName);
        String[] words = sensorName.split("X");
        valueALabel.setText(config.get(words[0] + "ValueA"));
        valueBLabel.setText(config.get(words[0] + "ValueB"));
        valueCLabel.setText(config.get(words[0] + "ValueC"));
    }
    
    /**
     * Update this panel from a value and a sensorStatus.
     * @param value
     * @param sensorStatus 
     */
    protected void update(int value, ColoredObject sensorStatus) {
        progressBar.setValue(value);
        Color lockSensorColor = sensorStatus.getColor();
        //progressBar.setValueAndColor(value, lockSensorColor);
        sensorSwitch.setColor(lockSensorColor);
        stateLabel.setText(sensorStatus.toString());
        stateLabel.setForeground(lockSensorColor);
    }
    
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        progressBar = new JProgressBar(orientation);
        sensorSwitch = new DigitalSwitch();
        sensorSwitch.setColor(Color.gray);
        stateLabel = new JLabel(FCSCst.UNKNOWN);
        nameLabel = new JLabel(sensorName);
        
        /**
         ******************************************************************************
         ** Lock Sensor Parameters Panels
         * *****************************************************************************
         */
        paramsPanel = new JPanel();
        paramsPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
        paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        
        /*first columm*/
        gbcp.anchor = GridBagConstraints.LINE_START;
        paramsPanel.add(new JLabel("Value A:"),gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("Value B:"),gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("Value C:"),gbcp);
        
        /*second columm*/
        gbcp.gridx++;
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        paramsPanel.add(valueALabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(valueBLabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(valueCLabel, gbcp);
        /**
         ******************************************************************************
         ** end of General Parameters Panels
         * *****************************************************************************
         */
        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.gridx=0;
        gbc.gridy=0;
        add(progressBar,gbc);
        gbc.gridy++;
        add(sensorSwitch,gbc);
        gbc.gridy++;
        add(stateLabel,gbc);
        gbc.gridy++;
        add(nameLabel,gbc);
        gbc.gridy++;
        add(paramsPanel,gbc);
        /**
         ******************************************************************************
         ** end Whole Panel
         * *****************************************************************************
         */
        
    }
    
    /**
     * Reset panel to default values when subsystem is shutdown for example.
     */
    public void resetPanel() {
        progressBar.setValue(0);
        sensorSwitch.setColor(Color.gray);
        stateLabel.setText(UNKNOWN_STATE);
        stateLabel.setForeground(Color.gray);
        valueALabel.setText(ZERO_VALUE);
        valueBLabel.setText(ZERO_VALUE);
        valueCLabel.setText(ZERO_VALUE);
    }
}
