
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerThreeOnlineClampsPanel extends JPanel {
    private static final long serialVersionUID = -7384546448046444702L;

    private InterfaceAutochangerGUI subs;

    private final JLabel clampsState = new JLabel();
    private final JLabel clampsStateLabel = new JLabel("CLAMPS STATE :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private final JLabel yLabel = new JLabel("Y-");
    private final JLabel yLabel2 = new JLabel("Y-");
    private final JPanel clampsPanel = new JPanel();
    private final JPanel clampsStatePanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final AutochangerOnlineClampPanel clampXminusPanel 
            = new AutochangerOnlineClampPanel("onlineClampXminus");
    private final AutochangerOnlineClampPanel clampXplusPanel
            = new AutochangerOnlineClampPanel("onlineClampXplus");
    private final AutochangerOnlineClampPanel clampYminusPanel
            = new AutochangerOnlineClampPanel("onlineClampYminus");

    private final JButton closeAndLockClampsButton = new JButton("Close and Lock Clamps");
    private final JButton unlockAndOpenClampsButton = new JButton("Unlock and Open Clamps");
    private final JButton openClampsButton = new JButton("Open Clamps");
    private final JButton closeClampsButton = new JButton("Close Clamps");
    private final JButton lockClampsButton = new JButton("Lock Clamps");
    private final JButton unlockClampsButton = new JButton("Unlock Clamps");
    private final JButton updateStateWithSensorsButton = new JButton("Read sensors and update state");
    private final JButton abortButton = new JButton("Abort");
    // End of variables declaration 

    /**
     * A Runnable to update this Panel from data published on the DStatus bus.
     */
    private class UpdateClamps implements Runnable {

        private StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            clampsState.setText(s.getLockStatus().getText());
            clampsState.setForeground(s.getLockStatus().getColor());
        }
    }

    /**
     * Creates this panel and initializes components.
     */
    public AutochangerThreeOnlineClampsPanel() {
        initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
        clampXminusPanel.setSubsystem(subs);
        clampXplusPanel.setSubsystem(subs);
        clampYminusPanel.setSubsystem(subs);
    }

    /**
     * Initialize GUI from configuration data of the subsystem.
     * @param configInfo 
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        clampXminusPanel.initializeGui(configInfo);
        clampXplusPanel.initializeGui(configInfo);
        clampYminusPanel.initializeGui(configInfo);
    }

    public void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateClamps(s));
    }

    public void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        clampXminusPanel.updateClamp(s);
    }

    public void updateClampXplus(StatusDataPublishedByAutochangerOnlineClamp s) {
        clampXplusPanel.updateClamp(s);
    }

    public void updateClampYminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        clampYminusPanel.updateClamp(s);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        /**
         ******************************************************************************
         ** Buttons initialization
         * *****************************************************************************
         */
        updateStateWithSensorsButton.addActionListener((ActionEvent evt) -> {
            updateStateWithSensorsButtonActionPerformed(evt);
        });

        closeAndLockClampsButton.addActionListener((ActionEvent evt) -> {
            closeAndLockClampsButtonActionPerformed(evt);
        });

        unlockAndOpenClampsButton.addActionListener((ActionEvent evt) -> {
            unlockAndOpenClampsButtonActionPerformed(evt);
        });
        
        closeClampsButton.addActionListener((ActionEvent evt) -> {
            closeClampsButtonActionPerformed(evt);
        });

        unlockClampsButton.addActionListener((ActionEvent evt) -> {
            unlockClampsButtonActionPerformed(evt);
        }); 
        
        openClampsButton.addActionListener((ActionEvent evt) -> {
            openClampsButtonActionPerformed(evt);
        });

        lockClampsButton.addActionListener((ActionEvent evt) -> {
            lockClampsButtonActionPerformed(evt);
        });        

        abortButton.addActionListener((ActionEvent evt) -> {
            abortButtonActionPerformed(evt);
        });
        /**
         ******************************************************************************
         ** end of Buttons initialization
         * *****************************************************************************
         */

        //X- and X+ and Z label
        Font xFont = new Font("Tahoma", 1, 18);
        xMinusLabel.setFont(xFont); // NOI18N      
        xMinuxLabel2.setFont(xFont); // NOI18N
        xPlusLabel2.setFont(xFont); // NOI18N       
        xPlusLabel.setFont(xFont); // NOI18N
        yLabel.setFont(xFont); // NOI18N 
        yLabel2.setFont(xFont); // NOI18N  


        /**
         ******************************************************************************
         ** Clamps State Panel
         * *****************************************************************************
         */
        clampsState.setFont(BIG_FONT); // NOI18N
        clampsState.setBorder(BorderFactory.createEtchedBorder(new java.awt.Color(255, 255, 255), new java.awt.Color(255, 255, 255)));
        clampsStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        clampsStatePanel.add(clampsStateLabel, gbc2);
        gbc2.gridx++;
        clampsStatePanel.add(clampsState, gbc2);
        /**
         ******************************************************************************
         ** end of Clamps State Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Clamps Panel
         * *****************************************************************************
         */
        clampsPanel.setLayout(new GridBagLayout());
        clampsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW), "ONLINE Clamps"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;

        gbc1.gridx = 0;
        gbc1.gridy = 0;
        clampsPanel.add(clampXminusPanel, gbc1);

        gbc1.gridx++;
        clampsPanel.add(clampXplusPanel, gbc1);

        gbc1.gridx = 0;
        gbc1.gridy++;
        clampsPanel.add(clampYminusPanel, gbc1);
        
        gbc1.gridx++;
        clampsPanel.add(controlPanel, gbc1);

        /**
         ******************************************************************************
         ** End of Clamps Panel
         * *****************************************************************************
         */
        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(closeAndLockClampsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(unlockAndOpenClampsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(closeClampsButton, gbc3);  
        gbc3.gridy++;
        controlPanel.add(lockClampsButton, gbc3);        
        gbc3.gridy++;        
        controlPanel.add(openClampsButton, gbc3);        
        gbc3.gridy++;
        controlPanel.add(unlockClampsButton, gbc3);        
        gbc3.gridy++;        
        controlPanel.add(abortButton, gbc3);
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK), "AUTOCHANGER ONLINE CLAMPS"));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.WEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(xMinusLabel, gbc);
        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx = 3;
        add(xPlusLabel, gbc);

        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        add(clampsStatePanel, gbc);
        gbc.gridy++;
        add(clampsPanel, gbc);

        gbc.gridy++;
        add(yLabel, gbc);
        
        setDefaultValues();
    }
    
    private void setDefaultValues() {
        clampsState.setText(UNKNOWN_STATE);
    }
    
    /**
     * Reset Panel components with default values.
     */
    public void resetPanel() {
        setDefaultValues();
        clampXminusPanel.resetPanel();
        clampXplusPanel.resetPanel();
        clampYminusPanel.resetPanel();
    }

    private void updateStateWithSensorsButtonActionPerformed(ActionEvent evt) {
        subs.updateStateWithSensors();
    }

    private void closeAndLockClampsButtonActionPerformed(ActionEvent evt) {
        subs.closeAndLockOnlineClamps();
    }

    private void unlockAndOpenClampsButtonActionPerformed(ActionEvent evt) {
        subs.unlockAndOpenOnlineClamps();
    }
    
    private void closeClampsButtonActionPerformed(ActionEvent evt) {
        subs.closeOnlineClamps();
    }

    private void lockClampsButtonActionPerformed(ActionEvent evt) {
        subs.lockOnlineClamps();
    }
    
    private void openClampsButtonActionPerformed(ActionEvent evt) {
        subs.openOnlineClamps();
    }

    private void unlockClampsButtonActionPerformed(ActionEvent evt) {
        subs.unlockOnlineClamps();
    }    

    private void abortButtonActionPerformed(ActionEvent evt) {
        subs.abortAction();
    }

    @Override
    public String toString() {
        return "ONLINE Clamps";
    }

    public static void main(String[] argv) {

        AutochangerThreeOnlineClampsPanel d = new AutochangerThreeOnlineClampsPanel();
        JFrame frame = new JFrame("Autochanger Clamps Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
