/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.py4j;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.NetworkUtilities;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.ScriptingStatusBusListener;
import org.lsst.ccs.scripting.ScriptingStatusBusMessage;
import org.lsst.ccs.scripting.ScriptingStatusBusMessageFilter;
import org.lsst.ccs.scripting.ScriptingSubsystemWrapper;
import py4j.GatewayServer;

public class Py4JServer
extends BusMaster {
    private final List<Py4jGatewayServer> gateways = new ArrayList<Py4jGatewayServer>();
    private final String LOCALHOST_NANE = "default-localhost";

    public Py4JServer() {
        super("py4j-server", AgentInfo.AgentType.SERVICE);
    }

    @Override
    public void doStart() {
        try {
            if (this.gateways.isEmpty()) {
                this.startGateway();
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doShutdown() {
        for (Py4jGatewayServer gw : this.gateways) {
            gw.stopServer();
        }
        super.doShutdown();
    }

    @Command
    public void startGateway() throws UnknownHostException {
        this.startGateway("default-localhost", 25333, "default-localhost", 25334);
    }

    @Command(description="starts a gateway")
    public void startGateway(@Argument(description="the name of this gateway") String name, @Argument(description="the listening port") int port, @Argument(description="the python client's callback address") String callbackAddress, @Argument(description="the python client's callback port") int callbackPort) throws UnknownHostException {
        Py4jGatewayServer gateway = new Py4jGatewayServer(name, port, callbackAddress, callbackPort);
        gateway.startServer();
        this.gateways.add(gateway);
    }

    @Command(description="restart a gateway")
    public void restartGateway(@Argument(description="the name of the gateway") String name) {
        for (Py4jGatewayServer server : this.gateways) {
            if (!server.getName().equals(name)) continue;
            server.stopServer();
            server.startServer();
            return;
        }
        throw new IllegalArgumentException("No Gateway is available with name " + name);
    }

    @Command(description="remove a gateway")
    public void removeGateway(@Argument(description="the name of the gateway") String name) {
        Iterator<Py4jGatewayServer> iter = this.gateways.iterator();
        while (iter.hasNext()) {
            Py4jGatewayServer server = iter.next();
            if (!server.getName().equals(name)) continue;
            iter.remove();
            return;
        }
        throw new IllegalArgumentException("No Gateway is available with name " + name);
    }

    @Command
    public String listGateways() {
        StringBuilder sb = new StringBuilder();
        if (this.gateways.isEmpty()) {
            sb.append("No gateways are currently available");
        } else {
            for (Py4jGatewayServer gw : this.gateways) {
                sb.append(gw).append("\n");
            }
        }
        return sb.toString();
    }

    private class Py4jGatewayServer {
        private final String name;
        private final int port;
        private final int callbackPort;
        private final GatewayServer server;
        private final InetAddress address;
        private final InetAddress callbackAddress;

        Py4jGatewayServer() throws UnknownHostException {
            this("default-localhost", 25333, "default-localhost", 25334);
        }

        Py4jGatewayServer(String name, int port, String callbackAddress, int callbackPort) {
            this.name = name;
            this.port = port;
            this.callbackPort = callbackPort;
            this.address = this.getGatewayAddress(name);
            this.callbackAddress = this.getCallbackAddress(callbackAddress);
            this.server = new GatewayServer((Object)this, port, callbackPort, this.address, this.callbackAddress, 0, 0, null);
        }

        private InetAddress getGatewayAddress(String name) {
            try {
                if (name.equals("default-localhost")) {
                    return InetAddress.getLoopbackAddress();
                }
                return NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName()).getInterfaceAddresses().get(0).getAddress();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private InetAddress getCallbackAddress(String name) {
            try {
                if (name.equals("default-localhost")) {
                    return InetAddress.getLoopbackAddress();
                }
                return InetAddress.getByName(name);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public String getName() {
            return this.name;
        }

        public int getPort() {
            return this.port;
        }

        private void startServer() {
            this.server.start();
            System.out.println("Started Gateway Server on " + this.server.getAddress() + ":" + this.server.getPort() + " and callback " + this.server.getCallbackClient().getAddress() + " " + this.server.getCallbackClient().getPort());
        }

        private void stopServer() {
            this.server.shutdown();
        }

        public String toString() {
            return this.getName() + " Java(" + this.server.getAddress() + ":" + this.server.getPort() + ") -> Python(" + this.server.getCallbackClient().getAddress() + " " + this.server.getCallbackClient().getPort() + ")";
        }

        public void initializeScriptingEnvironment() throws UnknownHostException {
            this.server.resetCallbackClient(this.callbackAddress, this.callbackPort);
            CCS.initializeScriptingEnvironment();
        }

        public void shutdownScriptingEnvironment() throws Exception {
            CCS.shutdownScriptingEnvironment();
        }

        public ScriptingSubsystemWrapper attachSubsystem(String target) {
            return CCS.attachSubsystem(target);
        }

        public void setThrowExceptions(boolean throwExceptions) {
            CCS.setThrowExceptions(throwExceptions);
        }

        public boolean getThrowExceptions() {
            return CCS.getThrowExceptions();
        }

        public void addStatusBusListener(ScriptingStatusBusListener listener) {
            CCS.addStatusBusListener(listener);
        }

        public void addStatusBusListener(ScriptingStatusBusListener listener, ScriptingStatusBusMessageFilter filter) {
            CCS.addStatusBusListener(listener, filter);
        }

        public void removeStatusBusListener(ScriptingStatusBusListener listener) {
            CCS.removeStatusBusListener(listener);
        }

        public Future<ScriptingStatusBusMessage> startListeningForStatusBusMessage(ScriptingStatusBusMessageFilter filter, int timeout) {
            return CCS.startListeningForStatusBusMessage(filter, timeout);
        }
    }
}

