/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCanOpenDevice;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderCarrierPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;

public class LoaderGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = 4741041603580940956L;
    private final String carrierControllerName = "carrierController";
    private final String clampControllerName = "hooksController";
    private InterfaceLoaderGUI subs;
    private EPOSControllerPanel hooksControllerPanel;
    private EPOSControllerPanel carrierControllerPanel;
    private PlutoGatewayPanel plutoGatewayPanel;
    private LoaderGeneralViewPanel loaderGeneralViewPanel;
    private LoaderClampPanel loaderClampPanel;
    private LoaderCarrierPanel loaderCarrierPanel;

    public LoaderGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
    }

    public LoaderGatherPanel(InterfaceLoaderGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.subs = subs;
        this.initPanels();
        this.loaderGeneralViewPanel.setSubsystem(subs);
        this.loaderCarrierPanel.setSubsystem(subs);
        this.loaderClampPanel.setSubsystem(subs);
        this.hooksControllerPanel.setSubsystem(subs);
        this.carrierControllerPanel.setSubsystem(subs);
    }

    public EPOSControllerPanel getHooksControllerPanel() {
        return this.hooksControllerPanel;
    }

    public EPOSControllerPanel getCarrierControllerPanel() {
        return this.carrierControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.plutoGatewayPanel;
    }

    public LoaderGeneralViewPanel getLoaderGeneralViewPanel() {
        return this.loaderGeneralViewPanel;
    }

    public LoaderClampPanel getLoaderClampPanel() {
        return this.loaderClampPanel;
    }

    public LoaderCarrierPanel getLoaderCarrierPanel() {
        return this.loaderCarrierPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.updatePanelsFromConfigInfo(configInfo);
    }

    private void updatePanelsFromConfigInfo(ConfigurationInfo configInfo) {
        this.hooksControllerPanel.initializeGui(configInfo);
        this.carrierControllerPanel.initializeGui(configInfo);
        this.plutoGatewayPanel.initializeGui(configInfo);
        this.loaderGeneralViewPanel.initializeGui(configInfo);
        this.loaderClampPanel.initializeGui(configInfo);
        this.loaderCarrierPanel.initializeGui(configInfo);
    }

    private void updateLoaderGeneral(StatusDataPublishedByLoader statusDataPublishedByLoader) {
        this.loaderGeneralViewPanel.updateLoaderGeneral(statusDataPublishedByLoader);
        this.loaderClampPanel.updateClamp(statusDataPublishedByLoader);
    }

    private void updateFakeAutochanger(boolean sensorValue) {
        this.loaderGeneralViewPanel.updateFakeAutochanger(sensorValue);
    }

    private void updateClamp(StatusDataPublishedByLoaderClamp statusDataPublishedByLoaderClamp) {
        this.loaderClampPanel.updateClamp(statusDataPublishedByLoaderClamp);
        this.loaderGeneralViewPanel.updateClamp(statusDataPublishedByLoaderClamp);
    }

    private void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        this.loaderCarrierPanel.updateCarrier(statusDataPublishedByLoaderCarrier);
    }

    private void updateCarrierController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateCarrierController(status));
    }

    private void updateClampController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateClampController(status));
    }

    private void updateController(String controllerName, StatusDataPublishedByEPOSController controllerStatus) {
        if ("carrierController".equals(controllerName)) {
            this.updateCarrierController(controllerStatus);
        } else if ("hooksController".equals(controllerName)) {
            this.updateClampController(controllerStatus);
        }
    }

    @Override
    public void updateCanOpenHardwarePanel(StatusDataPublishedByHardware status) {
        super.updateCanOpenHardwarePanel(status);
        this.hooksControllerPanel.updateDevice(status);
        this.carrierControllerPanel.updateDevice(status);
        this.plutoGatewayPanel.updateDevice(status);
    }

    @Override
    public void updateFromStatusData(KeyValueData data) {
        if ("loaderTcpProxy".equals(data.getKey())) {
            this.updateCanOpenHardwarePanel((Integer)data.getValue());
        } else if ("autochanger".equals(data.getKey())) {
            this.updateFakeAutochanger((Boolean)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoader) {
            this.updateLoaderGeneral((StatusDataPublishedByLoader)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoaderClamp) {
            this.updateClamp((StatusDataPublishedByLoaderClamp)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoaderCarrier) {
            this.updateCarrier((StatusDataPublishedByLoaderCarrier)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByEPOSController) {
            this.updateController(data.getKey(), (StatusDataPublishedByEPOSController)data.getValue());
            this.updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByPlutoGateway) {
            this.updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCanOpenDevice) {
            this.updateCanOpenHardwarePanel((StatusDataPublishedByCanOpenDevice)data.getValue());
        } else {
            FCSLOG.warning((Object)("LoaderGUIModule An unexpected dataType was read on the status bus : " + data.getKey() + " data=" + data));
        }
    }

    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        this.updatePanelsFromConfigInfo(configInfo);
    }

    private void initPanels() {
        this.hooksControllerPanel = new EPOSControllerPanel("hooksController");
        this.carrierControllerPanel = new EPOSControllerPanel("carrierController");
        this.plutoGatewayPanel = new PlutoGatewayPanel("loaderPlutoGateway");
        this.loaderGeneralViewPanel = new LoaderGeneralViewPanel();
        this.loaderClampPanel = new LoaderClampPanel("clamp");
        this.loaderCarrierPanel = new LoaderCarrierPanel("carrier");
    }

    @Override
    public void resetPanel() {
        super.resetPanel();
        this.hooksControllerPanel.resetPanel();
        this.carrierControllerPanel.resetPanel();
        this.loaderGeneralViewPanel.resetPanel();
        this.loaderClampPanel.resetPanel();
        this.loaderCarrierPanel.resetPanel();
    }

    public static void main(String[] argv) {
        LoaderGatherPanel d = new LoaderGatherPanel("loaderTcpProxy");
        JFrame frame = new JFrame("Loader High Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateClampController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateClampController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderGatherPanel.this.hooksControllerPanel.updateController(this.s);
        }
    }

    class UpdateCarrierController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateCarrierController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderGatherPanel.this.carrierControllerPanel.updateController(this.s);
        }
    }
}

