/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerOnlineClampPanel
extends JPanel {
    private static final long serialVersionUID = 7563287373167394297L;
    private final String clampName;
    private InterfaceAutochangerGUI subs;
    private DigitalSwitch closeSensorDS;
    private DigitalSwitch closeSensorCDS;
    private DigitalSwitch openSensorDS;
    private DigitalSwitch openSensorCDS;
    private DigitalSwitch errorDS;
    private JLabel clampNameLabel;
    private JLabel closeLabel;
    private JLabel openLabel;
    private JLabel errorLabel;
    private JLabel lockStatus;
    private JPanel paramPanel;
    private final JLabel initialCurrentToCloseLabel = new JLabel();
    private final JLabel finalCurrentToCloseLabel = new JLabel();
    private final JLabel currentToOpenLabel = new JLabel();
    private final JLabel currentToClampLabel = new JLabel();
    private final JLabel incrementCurrentToOpenLabel = new JLabel();
    private final JLabel incrementCurrentToClampLabel = new JLabel();
    private final JLabel incrementCurrentToCloseLabel = new JLabel();
    private JPanel faultPanel;
    private DigitalSwitch faultSwitch;
    private JPanel controlPanel;
    private JButton openButton = new JButton("Open");
    private JButton closeButton = new JButton("Close");
    private JButton lockButton = new JButton("Lock");
    private JButton unlockButton = new JButton("Unlock");
    private JButton abortButton = new JButton("Abort");
    private JPanel currentPanel;
    private final JLabel scLabel = new JLabel("current sent :");
    private final JLabel sentCurrentLabel = new JLabel();

    public AutochangerOnlineClampPanel(String clampName) {
        this.clampName = clampName;
        this.initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateClamp(StatusDataPublishedByAutochangerOnlineClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    private void initComponents() {
        this.openButton.addActionListener(evt -> this.openButtonActionPerformed(evt));
        this.closeButton.addActionListener(evt -> this.closeButtonActionPerformed(evt));
        this.lockButton.addActionListener(evt -> this.lockButtonActionPerformed(evt));
        this.unlockButton.addActionListener(evt -> this.unlockButtonActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortButtonActionPerformed(evt));
        this.closeSensorDS = new DigitalSwitch();
        this.closeSensorCDS = new DigitalSwitch();
        this.openSensorDS = new DigitalSwitch();
        this.openSensorCDS = new DigitalSwitch();
        this.errorDS = new DigitalSwitch();
        this.clampNameLabel = new JLabel("myClamp");
        this.openLabel = new JLabel("<html><P align=\"center\">OPEN<br>SENSOR</p></html>");
        this.closeLabel = new JLabel("<html><P align=\"center\">CLOSE<br>SENSOR</p></html>");
        this.errorLabel = new JLabel();
        this.lockStatus = new JLabel();
        this.paramPanel = new JPanel();
        this.paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramPanel.add((Component)new JLabel("currentToOpen:"), gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)new JLabel("initialCurrentToClose:"), gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)new JLabel("finalCurrentToClose:"), gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)new JLabel("currentToClamp:"), gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)new JLabel("incrementCurrentToOpen:"), gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)new JLabel("incrementCurrentToClose:"), gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)new JLabel("incrementCurrentToClamp:"), gbcp);
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramPanel.add((Component)this.currentToOpenLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.initialCurrentToCloseLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.finalCurrentToCloseLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.currentToClampLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.incrementCurrentToOpenLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.incrementCurrentToCloseLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.incrementCurrentToClampLabel, gbcp);
        this.faultPanel = new JPanel();
        this.faultSwitch = new DigitalSwitch();
        this.faultSwitch.setSize(50);
        this.faultPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
        this.faultPanel.setLayout(new GridBagLayout());
        this.faultPanel.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = Tools.insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = 10;
        this.faultPanel.add((Component)this.faultSwitch, gbcf);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcc = new GridBagConstraints();
        gbcc.anchor = 23;
        gbcc.fill = 2;
        gbcc.gridx = 0;
        gbcc.gridy = 0;
        this.controlPanel.add((Component)this.closeButton, gbcc);
        ++gbcc.gridy;
        this.controlPanel.add((Component)this.openButton, gbcc);
        ++gbcc.gridy;
        this.controlPanel.add((Component)this.lockButton, gbcc);
        ++gbcc.gridy;
        this.controlPanel.add((Component)this.unlockButton, gbcc);
        ++gbcc.gridy;
        this.controlPanel.add((Component)this.abortButton, gbcc);
        this.currentPanel = new JPanel();
        this.currentPanel.setBorder(BorderFactory.createTitledBorder("current in Controller"));
        this.currentPanel.setLayout(new GridBagLayout());
        gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.currentPanel.add((Component)this.scLabel, gbcp);
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.currentPanel.add((Component)this.sentCurrentLabel, gbcp);
        this.setDefaultValues();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.clampNameLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.lockStatus, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.openSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.openLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.add((Component)this.closeSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.closeLabel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.add((Component)this.errorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.errorLabel, gbc);
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.faultPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        this.add((Component)this.currentPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.add((Component)this.paramPanel, gbc);
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.gridheight = 2;
        this.add((Component)this.controlPanel, gbc);
    }

    private void setDefaultValues() {
        this.closeSensorDS.setColor(Color.gray);
        this.closeSensorCDS.setColor(Color.gray);
        this.openSensorDS.setColor(Color.gray);
        this.openSensorCDS.setColor(Color.gray);
        this.errorDS.setColor(Color.gray);
        this.errorLabel.setText("ERROR");
        this.lockStatus.setText("UNKNOWN STATE");
        this.faultSwitch.setColor(Color.GRAY);
        this.initialCurrentToCloseLabel.setText("0.0");
        this.finalCurrentToCloseLabel.setText("0.0");
        this.currentToOpenLabel.setText("0.0");
        this.currentToClampLabel.setText("0.0");
        this.sentCurrentLabel.setText("0.0");
        this.incrementCurrentToOpenLabel.setText("0.0");
        this.incrementCurrentToCloseLabel.setText("0.0");
        this.incrementCurrentToClampLabel.setText("0.0");
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.subs.openOnlineClamp(this.clampName);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.subs.closeOnlineClamp(this.clampName);
    }

    private void lockButtonActionPerformed(ActionEvent evt) {
        this.subs.lockOnlineClamp(this.clampName);
    }

    private void unlockButtonActionPerformed(ActionEvent evt) {
        this.subs.unlockOnlineClamp(this.clampName);
    }

    private void abortButtonActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    @Override
    public String toString() {
        if (this.clampName == null) {
            return "ONLINE clamp";
        }
        return this.clampName;
    }

    public static void main(String[] argv) {
        AutochangerOnlineClampPanel d = new AutochangerOnlineClampPanel("clampName");
        JFrame frame = new JFrame("Autochanger OnlineClamp Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateClamp
    implements Runnable {
        private StatusDataPublishedByAutochangerOnlineClamp s;

        public UpdateClamp(StatusDataPublishedByAutochangerOnlineClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerOnlineClampPanel.this.clampNameLabel.setText(this.s.getName());
            AutochangerOnlineClampPanel.this.lockStatus.setText(this.s.getLockStatus().getText());
            AutochangerOnlineClampPanel.this.lockStatus.setForeground(this.s.getLockStatus().getColor());
            AutochangerOnlineClampPanel.this.closeSensorDS.updateColor(this.s.isLockSensorInError(), this.s.getLockSensorValue());
            AutochangerOnlineClampPanel.this.openSensorDS.updateColor(this.s.isUnlockSensorInError(), this.s.getUnlockSensorValue());
            boolean inTravel = this.s.getLockStatus().equals(FcsEnumerations.LockStatus.INTRAVEL);
            boolean unknown = this.s.getLockStatus().equals(FcsEnumerations.LockStatus.UNKNOWN);
            if (this.s.isInError() || inTravel || unknown) {
                AutochangerOnlineClampPanel.this.errorDS.setColor(this.s.getLockStatus().getColor());
                AutochangerOnlineClampPanel.this.errorLabel.setText(this.s.getLockStatus().getText());
            } else {
                AutochangerOnlineClampPanel.this.errorDS.setColor(FcsEnumerations.LockStatus.NOERROR.getColor());
                AutochangerOnlineClampPanel.this.errorLabel.setText(FcsEnumerations.LockStatus.NOERROR.getText());
            }
            if (!this.s.isControllerBooted()) {
                AutochangerOnlineClampPanel.this.faultSwitch.setColor(Color.RED);
            } else if (this.s.isControllerInFault()) {
                AutochangerOnlineClampPanel.this.faultSwitch.setColor(Color.ORANGE);
            } else {
                AutochangerOnlineClampPanel.this.faultSwitch.setColor(Tools.greenColor);
            }
            AutochangerOnlineClampPanel.this.sentCurrentLabel.setText(String.valueOf(this.s.getSentCurrent()));
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForName = this.configInfo.getCurrentValuesFor(AutochangerOnlineClampPanel.this.clampName);
            FCSCst.FCSLOG.fine((Object)(AutochangerOnlineClampPanel.this.clampName + " configForName=" + configForName));
            AutochangerOnlineClampPanel.this.currentToOpenLabel.setText((String)configForName.get("currentToOpen"));
            AutochangerOnlineClampPanel.this.initialCurrentToCloseLabel.setText((String)configForName.get("initialCurrentToClose"));
            AutochangerOnlineClampPanel.this.finalCurrentToCloseLabel.setText((String)configForName.get("finalCurrentToClose"));
            AutochangerOnlineClampPanel.this.currentToClampLabel.setText((String)configForName.get("currentToClamp"));
            AutochangerOnlineClampPanel.this.incrementCurrentToOpenLabel.setText((String)configForName.get("incrementCurrentToOpen"));
            AutochangerOnlineClampPanel.this.incrementCurrentToCloseLabel.setText((String)configForName.get("incrementCurrentToClose"));
            AutochangerOnlineClampPanel.this.incrementCurrentToClampLabel.setText((String)configForName.get("incrementCurrentToClamp"));
        }
    }
}

