/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerBottomPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGatherPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

public class AutochangerGUI
extends GeneralGUI
implements InterfaceAutochangerGUI {
    private static final long serialVersionUID = 1528028505886594591L;
    private static final String trucksModuleName = "autochangerTrucks";
    private static final String clampsName = "onlineClamps";
    private static final String latchesName = "latches";
    private final long updateTrucksPositionTimeout;
    private long timeoutForTrucksMotion;
    private final long timeoutForClosingClamps;
    private final long timeoutForOpeningClamps;
    private final long timeoutForClosingLatches;
    private final long timeoutForOpeningLatches;

    public AutochangerGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        AutochangerGatherPanel autochangerGatherPanel = new AutochangerGatherPanel(this, "tcpProxy");
        AutochangerBottomPanel autochangerBottomPanel = new AutochangerBottomPanel(autochangerGatherPanel, "AUTOCHANGER");
        this.generalPanel = new GeneralPanel(this, autochangerBottomPanel);
        this.pane = new JScrollPane(this.generalPanel);
        this.updateTrucksPositionTimeout = 1000L;
        this.timeoutForTrucksMotion = 60000L;
        this.timeoutForClosingClamps = 10000L;
        this.timeoutForOpeningClamps = 10000L;
        this.timeoutForClosingLatches = 10000L;
        this.timeoutForOpeningLatches = 10000L;
    }

    @Override
    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    @Override
    public void updateTrucksPosition() {
        FCSCst.FCSLOG.info((Object)"Autochanger updating Trucks position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.updateTrucksPositionTimeout));
        new GeneralGUI.CommandSwingWorker(this, "updatePosition", this.updateTrucksPositionTimeout, trucksModuleName).execute();
    }

    @Override
    public void goToHandOff() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker(this, "goToHandOff", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void goToStandby() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Standby Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker(this, "goToStandby", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void goToOnline() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Online Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker(this, "goToOnline", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void unlockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningClamps));
        new GeneralGUI.CommandSwingWorker(this, "unlockClamps", this.timeoutForOpeningClamps, clampsName).execute();
    }

    @Override
    public void lockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger locking online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingClamps));
        new GeneralGUI.CommandSwingWorker(this, "lockClamps", this.timeoutForClosingClamps, clampsName).execute();
    }

    @Override
    public void closeOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger closing online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingClamps));
        new GeneralGUI.CommandSwingWorker(this, "closeClamps", this.timeoutForClosingClamps, clampsName).execute();
    }

    @Override
    public void openOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger opening online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningClamps));
        new GeneralGUI.CommandSwingWorker(this, "openClamps", this.timeoutForOpeningClamps, clampsName).execute();
    }

    @Override
    public void unlockAndOpenOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking and opening online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningClamps));
        new GeneralGUI.CommandSwingWorker(this, "unlockAndOpenClamps", this.timeoutForOpeningClamps, clampsName).execute();
    }

    @Override
    public void closeAndLockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger closing and locking online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingClamps));
        new GeneralGUI.CommandSwingWorker(this, "closeAndLockClamps", this.timeoutForClosingClamps, clampsName).execute();
    }

    @Override
    public void openOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger opening clamp: " + clampName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker(this, "open", this.timeoutForOpeningClamps, clampName).execute();
    }

    @Override
    public void closeOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger closing clamp: " + clampName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker(this, "close", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void lockOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger clamping clamp: " + clampName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker(this, "lock", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void unlockOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger unclamping clamp: " + clampName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker(this, "unlock", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void closeLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger locking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker(this, "close", this.timeoutForClosingLatches, latchName).execute();
    }

    @Override
    public void openLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger unlocking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker(this, "open", this.timeoutForOpeningLatches, latchName).execute();
    }

    @Override
    public void closeLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger locking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker(this, "close", this.timeoutForClosingLatches, latchesName).execute();
    }

    @Override
    public void openLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker(this, "open", this.timeoutForOpeningLatches, latchesName).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("AutochangerGUI", AgentInfo.AgentType.CONSOLE);
        AutochangerGUI t = new AutochangerGUI(agent.getName(), "testbenchCPPM", agent.getMessagingAccess());
        agent.start();
        JFrame frame = new JFrame("Autochanger View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

