/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import static org.lsst.ccs.subsystems.fcs.FCSCst.NO_FILTER;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.ZERO_VALUE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * This view represents the carousel in a general design.
 * @author virieux
 */
public class CarouselGeneralViewPanel extends JPanel {
    private static final long serialVersionUID = 3579024322081964467L;
    
    private static final String NONE = "None";
    
    private InterfaceCarouselGUI subs;
    
    /*General Informations Panel (Configuration parameters)*/
    private JPanel generalInfoPanel;
    private final JLabel speedLabel = new JLabel();
    
    /*Actual parameters (dynamic parameters */
    private JPanel actualParametersPanel;
    private final JLabel actualPositionLabel = new JLabel();
    private final JLabel actualSpeedLabel = new JLabel();
    private final JLabel actualCurrentLabel = new JLabel();
    private final JLabel standbyLabel = new JLabel();
    private final DigitalSwitch standbySwitch = new DigitalSwitch();
    private final JLabel socketAtStandbyLabel = new JLabel();
    private final JLabel filterAtStandbyLabel = new JLabel();
    
    /*Carousel Disk*/
    private final CarouselDisk carouselDisk = new CarouselDisk();

    public CarouselGeneralViewPanel() {
        setName("carouselGeneralViewPanel");
        initComponents();
    }

    protected void setSubsystem(InterfaceCarouselGUI subs) {
        this.subs = subs;
    }
    
    private void setDefaultValues() {
        speedLabel.setText(ZERO_VALUE);
        actualPositionLabel.setText(ZERO_VALUE);
        actualSpeedLabel.setText(ZERO_VALUE);
        actualCurrentLabel.setText(ZERO_VALUE);
        standbyLabel.setText(FCSCst.NOT_AT_STANDBY);
        standbySwitch.setColor(Color.gray);
        socketAtStandbyLabel.setText(NONE);
        filterAtStandbyLabel.setText(NO_FILTER);
    }

    protected void initializeGui(ConfigurationInfo configInfo) {
        //here initialize this Panel from configInfo
    }
    
    protected void update(StatusDataPublishedByCarousel s) {
        FCSLOG.debug(getName() + " updating from carousel data:" + s.toString());
        SwingUtilities.invokeLater(new Update(s));
    }
    
    /**
     * A Runnable class to update this panel from an object StatusDataPublishedByCarousel.
     */
    public class Update implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public Update(StatusDataPublishedByCarousel s) {
            this.s = s;
        }
        
        @Override
        public void run() {
            /*Update of actual parameters Panel*/
            actualPositionLabel.setText(Double.toString(s.getRotationInDegrees()));
            actualSpeedLabel.setText(Double.toString(s.getSpeed()));
            actualCurrentLabel.setText(Double.toString(s.getCurrent()));
            if (s.isAtStandby()) {
                standbyLabel.setText(FCSCst.AT_STANDBY);
                standbySwitch.setColor(greenColor);
                socketAtStandbyLabel.setText(s.getSocketAtStandbyName());
                socketAtStandbyLabel.setFont(BIG_FONT);
                filterAtStandbyLabel.setText(s.getFilterAtStandbyName());
                filterAtStandbyLabel.setFont(BIG_FONT);
                
            } else {
                standbyLabel.setText(FCSCst.NOT_AT_STANDBY);
                standbySwitch.setColor(Color.RED);
                socketAtStandbyLabel.setText(NONE);
                filterAtStandbyLabel.setText(NONE);
            }
            
            carouselDisk.update(s);
        }
        
    }
    
    
    
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        setDefaultValues();
        /**
         ******************************************************************************
         ** General Informations Panel
         * *****************************************************************************
         */
        generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = insets_std;
        //first colomn
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_START;

        generalInfoPanel.add(new JLabel("Maximum speed:"), gbc3);
        gbc3.gridy++;

        //second colomn
        gbc3.gridx++;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_END;
        generalInfoPanel.add(speedLabel, gbc3);
       
        /**
         ******************************************************************************
         ** end of General Informations Panel
         * *****************************************************************************
         */
        
        /**
         ******************************************************************************
         ** Actual Position Panel
         * *****************************************************************************
         */
        actualParametersPanel = new JPanel();
        actualParametersPanel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        actualParametersPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc3.insets = insets_std;
        //first colomn
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = GridBagConstraints.LINE_START;
        actualParametersPanel.add(new JLabel("Position: "),gbc1);
        gbc1.gridy++;
        actualParametersPanel.add(new JLabel("Speed: "),gbc1);
        gbc1.gridy++;
        actualParametersPanel.add(new JLabel("Current: "),gbc1);
        gbc1.gridy++;
        actualParametersPanel.add(standbyLabel,gbc1);
        gbc1.gridy++;
        actualParametersPanel.add(new JLabel("Socket at STANDBY: "),gbc1);
        gbc1.gridy++;
        actualParametersPanel.add(new JLabel("Filter at STANDBY: "),gbc1);
        //second colomn
        gbc1.gridx++;
        gbc1.gridy = 0;
        gbc1.anchor = GridBagConstraints.LINE_END;
        actualParametersPanel.add(actualPositionLabel, gbc1);
        gbc1.gridy++;
        actualParametersPanel.add(actualSpeedLabel, gbc1);
        gbc1.gridy++;
        actualParametersPanel.add(actualCurrentLabel, gbc1);
        gbc1.gridy++;
        standbySwitch.setColor(Color.gray);
        actualParametersPanel.add(standbySwitch,gbc1);
        gbc1.gridy++;
        actualParametersPanel.add(socketAtStandbyLabel,gbc1);
        gbc1.gridy++;
        actualParametersPanel.add(filterAtStandbyLabel,gbc1);

        /**
         ******************************************************************************
         ** end of Actual Position Panel
         * *****************************************************************************
         */
        
        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        /*General Information Panel*/
        setBorder(BorderFactory.createTitledBorder("CAROUSEL GENERAL VIEW"));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.NORTHWEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(generalInfoPanel, gbc); 
        
        gbc.gridx++;
        add(actualParametersPanel);
        
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 2;
        add(carouselDisk, gbc);
        /**
         ******************************************************************************
         ** end of Whole Panel
         * *****************************************************************************
         */
    }
    
    /**
     * Reset Panel to default values when subsystem is shutdown.
     */
    public void resetPanel() {
        setDefaultValues();
        carouselDisk.resetPanel();
    }
    
    @Override
    public String toString() {
        return "Carousel General View";
    }
    
    /**
     * Just to test the Panel.
     * @param argv 
     */
    public static void main(String[] argv) {

        CarouselGeneralViewPanel d = new CarouselGeneralViewPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
