/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;

public class Alarm
implements HasLifecycle {
    public static final int EVENT_TRIP = 0;
    public static final int EVENT_LIMBO = 1;
    public static final int EVENT_RESET = 2;
    static final int STATE_GOOD = 0;
    static final int STATE_WARNING = 1;
    static final int STATE_DEADBAND = 1;
    static final int STATE_ERROR = 2;
    protected String description = " ";
    protected String lineName;
    protected int eventParm;
    private Line line;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Monitor mon;
    private int state = 0;
    private int newState;
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;

    void configure() {
        try {
            if (this.lineName != null) {
                this.line = this.mon.getLine(this.lineName);
                if (this.line == null) {
                    MonitorLogUtils.reportError(this.s.getLogger(), this.name, "line", this.lineName);
                } else {
                    this.line.set(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearState() {
        this.newState = 0;
    }

    void updateState(int value) {
        if (value > this.newState) {
            this.newState = value;
        }
    }

    void setState() {
        if (this.newState != this.state && (this.newState != 1 || this.state != 0)) {
            Boolean set = null;
            Integer event = null;
            if (this.newState == 2) {
                set = true;
                event = 0;
            } else if (this.state == 2) {
                set = false;
                event = this.newState == 0 ? 2 : 1;
            } else if (this.newState == 0) {
                event = 2;
            }
            if (this.line != null && set != null) {
                this.line.set(set);
            }
            if (this.eventParm >= 0 && event != null) {
                this.mon.getAlarmHandler().processAlarm(event, this.eventParm);
            }
            this.state = this.newState;
        }
        this.newState = 0;
    }

    String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }
}

