/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.AlarmNotClearedException;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.RaisedAlertBookkeeper;
import org.lsst.ccs.SignalsStillRunning;
import org.lsst.ccs.SubsystemConfigurationEnvironment;
import org.lsst.ccs.SubsystemPersistencyService;
import org.lsst.ccs.SystemStateException;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ClusterAlert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurationHandlerSetBuilder;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AlertHandler;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.ClusterDeserializationErrorHandler;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.logging.TextFormatter;

public class Subsystem
extends Agent {
    private final RaisedAlertBookkeeper raisedAlertBookkeeper = new RaisedAlertBookkeeper();
    private final List<ClearAlertHandler> clearAlertHandlers = new ArrayList<ClearAlertHandler>();
    private final Object alertLock = new Object();
    private final int alertAccumulationPeriod = 2000;
    private final Map<String, AlertRunnable> alertRunnables = new HashMap<String, AlertRunnable>();
    private final Map<String, ScheduledFuture> alertTasks = new HashMap<String, ScheduledFuture>();
    private SubsystemConfigurationEnvironment subsystemConfigurationEnvironment;
    private SubsystemPersistencyService subsystemPersistencyService;
    private String startupConfig;
    private String descriptionName = "";
    private final Map<String, ComponentConfigurationEnvironment> keyEnvironmentMap = new HashMap<String, ComponentConfigurationEnvironment>();
    private Monitor monitor;

    Subsystem(String name) {
        this(name, AgentInfo.AgentType.WORKER, null);
    }

    public Subsystem(String name, AgentInfo.AgentType type) {
        this(name, type, null);
    }

    public Subsystem(String name, AgentInfo.AgentType type, ComponentLookup lookup) {
        super(name, type, lookup);
    }

    @Override
    protected final void addInternalNodes() {
        super.addInternalNodes();
        ComponentNode topNode = this.getComponentLookup().getTopComponentNode();
        ArrayList devices = new ArrayList();
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, Device.class, dev -> devices.add(dev), null);
        if (devices.size() > 0) {
            this.monitor = new Monitor(this);
            this.getComponentLookup().addComponentNodeToLookup(topNode.getKey(), new ComponentNode(topNode, "monitor", (Object)this.monitor));
        }
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    void setConfigurationInformation(String descriptionName, String startupConfig) {
        this.startupConfig = startupConfig;
        this.descriptionName = descriptionName;
    }

    @Override
    void afterConnection() {
        if (this.subsystemConfigurationEnvironment != null) {
            this.updateInternalState(new AgentState[]{ConfigurationState.INITIAL_SAFE});
            ConfigurationInfo configInfo = this.subsystemConfigurationEnvironment.configurationHandler.getConfigurationInfo();
            this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(configInfo, this.getState()));
            if (this.startupConfig != null) {
                this.subsystemConfigurationEnvironment.loadConfiguration(this.startupConfig.isEmpty() ? null : this.startupConfig.split(","));
            }
        }
    }

    @Override
    public void startAgent() {
        this.start();
    }

    @Override
    @Deprecated
    public void start() {
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, AlertHandler.class, ah -> {
            if (ah instanceof ClearAlertHandler) {
                this.addClearAlertHandler((ClearAlertHandler)ah);
            }
        }, null);
        this.subsystemPersistencyService = SubsystemPersistencyService.create(this.descriptionName, this.getComponentLookup());
        if (this.subsystemPersistencyService != null) {
            this.subsystemPersistencyService.load();
            this.addCommandsFromObject(this.subsystemPersistencyService, "");
        }
        ConfigurationHandlerSetBuilder chsb = new ConfigurationHandlerSetBuilder();
        TreeWalkerUtils.proceduralNodeWalk(this.getComponentLookup(), null, n -> {
            String nodeName = n.getKey();
            Object component = n.getComponent();
            chsb.addConfigurationHandlerForObject(nodeName, component);
        }, null);
        this.subsystemConfigurationEnvironment = SubsystemConfigurationEnvironment.create(this, chsb, this.topComponentTags);
        if (this.subsystemConfigurationEnvironment != null) {
            this.addCommandsFromObject(this.subsystemConfigurationEnvironment, "");
            for (String s : this.subsystemConfigurationEnvironment.getComponents()) {
                ComponentConfigurationEnvironment cce = new ComponentConfigurationEnvironment(s, this.subsystemConfigurationEnvironment);
                this.keyEnvironmentMap.put(s, cce);
                this.addCommandsFromObject(cce, this.getComponentLookup().getFullPathFor(s));
            }
        }
        super.start();
    }

    @Override
    protected final boolean internalStart() {
        this.doStart();
        AlertState alertState = this.getAgentInfo().getType().equals((Object)AgentInfo.AgentType.CONSOLE) ? AlertState.WARNING : AlertState.NOMINAL;
        this.getMessagingAccess().setClusterDeserializationErrorHandler(s -> this.raiseAlert((Alert)new ClusterAlert(this.getName(), s), alertState, this.getName() + "and " + s + " are running incompatible core versions"));
        boolean allOk = true;
        try {
            this.checkHardware();
            this.completeInitialization(true);
        }
        catch (HardwareException e) {
            this.getLogger().error((Object)"check hardware problem ", (Throwable)((Object)e));
            allOk = false;
        }
        if (!allOk) {
            this.updateInternalState(new AgentState[]{OperationalState.ENGINEERING_FAULT});
        }
        return allOk;
    }

    @Override
    protected final void internalShutdown() throws Exception {
        try {
            this.checkAllHardwareStopped();
        }
        catch (HardwareException exc) {
            this.raiseAlert(new Alert("Problems stopping hardware", exc.getMessage()), AlertState.ALARM, "Internl Shutdown exception: " + exc.getMessage());
            this.getLogger().error((Object)"Problems stopping hardware", (Throwable)((Object)exc));
            throw exc;
        }
        this.getLogger().fine((Object)"Hardware is stopped");
        this.getLogger().fine((Object)("Subsystem " + this.getName() + " shutdown starting"));
        Iterator iter = OBJECT_SUBSYSTEM_MAP.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != this) continue;
            iter.remove();
        }
        this.doShutdown();
        if (this.subsystemPersistencyService != null) {
            // empty if block
        }
        this.getMessagingAccess().setClusterDeserializationErrorHandler(ClusterDeserializationErrorHandler.DEFAULT);
        this.clearAlertHandlers.clear();
    }

    public void completeInitialization(boolean checkHardwareOK) throws HardwareException {
        if (!checkHardwareOK) {
            this.checkAllHardwareStarted();
            this.postStart();
        }
        this.updateInternalState(new AgentState[]{PhaseState.OPERATIONAL, OperationalState.ENGINEERING_OK});
    }

    @Deprecated
    public final ComponentLookup getLookup() {
        return this.getComponentLookup();
    }

    public void checkHardware() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        TreeWalkerUtils.treeWalk(this.getComponentLookup(), null, HardwareController.class, hc -> {
            try {
                return hc.checkHardware();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)((Object)e), exc[0]);
                if (e.isFatal()) {
                    return TreeWalkerDiag.STOP;
                }
                return TreeWalkerDiag.GO;
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void checkAllHardwareStarted() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HardwareController.class, hc -> {
            try {
                hc.checkStarted();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)((Object)e), exc[0]);
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void checkAllHardwareStopped() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HardwareController.class, hc -> {
            try {
                hc.checkStopped();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)((Object)e), exc[0]);
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void doStart() {
    }

    protected void doShutdown() {
    }

    @Command(description="completes initialization after hardware problems corrections", type=Command.CommandType.ACTION)
    public void completeInitialization() throws SystemStateException, HardwareException {
        if (!this.isInState((Enum)PhaseState.INITIALIZING)) {
            throw new SystemStateException("initialization already completed");
        }
        this.completeInitialization(false);
    }

    @Command(description="forces blocked shutdown (not implemented yet!)", type=Command.CommandType.SIGNAL)
    public void forceShutdown() {
    }

    @Command(description="abort subsystem", type=Command.CommandType.SIGNAL)
    public void abort() {
        this.getLogger().fine((Object)("Subsystem " + this.getName() + " abort requested"));
        this.sendSignal(new Signal(SignalLevel.HALT));
    }

    @Command(description="stops hardware with expected max delay", type=Command.CommandType.ACTION)
    public void stop(@Argument(name="timeHint", defaultValue="-1") long timeHint) throws HardwareException {
        this.getLogger().fine((Object)("Subsystem " + this.getName() + " stop requested with " + timeHint));
        this.sendSignal(new Signal(SignalLevel.STOP, timeHint));
    }

    @Command(description="waits until all the hardware devices are actually stopped", type=Command.CommandType.ACTION)
    public void stopAndWait(long timeHint) throws HardwareException, InterruptedException {
        this.stop(timeHint);
        int step = 10;
        long fracDelay = timeHint / (long)step;
        HardwareException lastExc = null;
        for (int i = 0; i < step; ++i) {
            try {
                Thread.sleep(fracDelay);
                this.checkAllHardwareStopped();
                return;
            }
            catch (HardwareException e) {
                lastExc = e;
                continue;
            }
        }
        throw lastExc;
    }

    private void sendSignal(Signal signal) {
        TreeWalkerUtils.treeWalk(this.getComponentLookup(), null, SignalHandler.class, sh -> sh.signal(signal), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="switch to ENGINEERING mode", type=Command.CommandType.ACTION)
    public boolean switchToEngineeringMode() {
        Object object = this.innerStateLock;
        synchronized (object) {
            if (this.isInState((Enum)OperationalState.NORMAL)) {
                this.updateInternalState(new AgentState[]{OperationalState.ENGINEERING_OK});
                return true;
            }
        }
        return false;
    }

    @Command(description="Tries to get back to NORMAL mode", type=Command.CommandType.ACTION)
    public final void switchToNormalMode() throws SystemStateException {
        if (this.getState(AlertState.class).compareTo(AlertState.WARNING) > 0) {
            throw new AlarmNotClearedException();
        }
        if (this.getCommandCount(Command.CommandType.SIGNAL) != 0) {
            throw new SignalsStillRunning();
        }
        try {
            this.updateInternalState(new AgentState[]{CommandState.READY, OperationalState.NORMAL});
        }
        catch (IllegalArgumentException x) {
            throw new SystemStateException(x);
        }
    }

    @Deprecated
    public final void addClearAlertHandler(ClearAlertHandler handler) {
        if (this.clearAlertHandlers.contains(handler)) {
            System.out.println("WARNING: The clear alert handler has already been added. Please remove any calls to \"addClearAlertHandler\" as the framework is picking them up from the lookup tree.");
        }
        this.clearAlertHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void raiseAlert(Alert alert, AlertState severity, String cause) {
        long ts = System.currentTimeMillis();
        Object object = this.alertLock;
        synchronized (object) {
            String alertId = alert.getAlertId();
            ScheduledFuture task = this.alertTasks.get(alertId);
            if (task == null || task.isDone()) {
                this.raiseAlertAndAccumulate(alert, severity, ts, cause);
            } else if (this.alertRunnables.get(alertId).severity != severity) {
                if (task.cancel(false)) {
                    this.alertRunnables.get(alertId).updateBookkeeperAndSendStatusAlert();
                }
                this.raiseAlertAndAccumulate(alert, severity, ts, cause);
            } else {
                this.alertRunnables.get(alertId).accumulate(cause);
            }
        }
    }

    private void raiseAlertAndAccumulate(Alert alert, AlertState severity, long ts, String cause) {
        new AlertRunnable(alert, severity, ts, cause).updateBookkeeperAndSendStatusAlert();
        AlertRunnable r = new AlertRunnable(alert, severity, ts, cause);
        ScheduledFuture task = this.getScheduler().schedule((Runnable)r, 2000L, TimeUnit.MILLISECONDS);
        this.alertRunnables.put(alert.getAlertId(), r);
        this.alertTasks.put(alert.getAlertId(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Clear alerts", type=Command.CommandType.ACTION)
    public final String[] clearAlerts(String ... alertId) {
        Object object = this.alertLock;
        synchronized (object) {
            String summary;
            ArrayList<String> clearedAlerts = new ArrayList<String>();
            for (String id : alertId) {
                ScheduledFuture alertTask = this.alertTasks.get(id);
                if (alertTask != null) {
                    alertTask.cancel(true);
                    this.alertTasks.remove(id);
                }
                boolean clearAlert = true;
                RaisedAlertHistory raisedAlert = this.raisedAlertBookkeeper.getRaisedAlert(id);
                if (raisedAlert != null) {
                    for (ClearAlertHandler handler : this.clearAlertHandlers) {
                        ClearAlertHandler.ClearAlertCode code = handler.canClearAlert(raisedAlert.getLatestAlert());
                        if (code == ClearAlertHandler.ClearAlertCode.CLEAR_ALERT) {
                            clearAlert = true;
                            continue;
                        }
                        if (code != ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT) continue;
                        clearAlert = false;
                        break;
                    }
                }
                if (!clearAlert) continue;
                this.raisedAlertBookkeeper.clearAlert(id);
                clearedAlerts.add(id);
            }
            String[] clearedIds = new String[clearedAlerts.size()];
            if (!clearedAlerts.isEmpty()) {
                clearedIds = clearedAlerts.toArray(clearedIds);
                AlertState globalSeverity = this.raisedAlertBookkeeper.getAlertState();
                if (globalSeverity == AlertState.WARNING && this.isInState((Enum)AlertState.ALARM)) {
                    this.updateInternalState(new AgentState[]{AlertState.WARNING, OperationalState.ENGINEERING_OK});
                } else if (globalSeverity == AlertState.NOMINAL && !this.isInState((Enum)AlertState.NOMINAL)) {
                    this.updateInternalState(new AgentState[]{AlertState.NOMINAL, OperationalState.ENGINEERING_OK});
                }
                StatusClearedAlert clearedStatus = new StatusClearedAlert(clearedIds, this.getState(), this.getRaisedAlertSummary());
                this.getMessagingAccess().sendStatusMessage((StatusMessage)clearedStatus);
            }
            if (clearedIds.length > 0) {
                summary = "Cleared Alert Id" + (clearedIds.length > 1 ? "s" : "") + " (";
                for (int i = 0; i < clearedIds.length; ++i) {
                    summary = summary + clearedIds[i];
                    if (i >= clearedIds.length - 1) continue;
                    summary = summary + ", ";
                }
                summary = summary + ")";
            } else {
                summary = "Attempt to clear alerts, but no Alerts were cleared";
            }
            this.getLogger().info((Object)(summary + " the resulting Alert State is " + this.raisedAlertBookkeeper.getAlertState().name()));
            return clearedIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Clear all alerts", type=Command.CommandType.ACTION)
    public final String[] clearAllAlerts() {
        Object object = this.alertLock;
        synchronized (object) {
            Set alerts = this.raisedAlertBookkeeper.getAllRaisedAlertHistories();
            String[] alertId = new String[alerts.size()];
            int count = 0;
            for (RaisedAlertHistory alert : alerts) {
                alertId[count++] = alert.getLatestAlert().getAlertId();
            }
            return this.clearAlerts(alertId);
        }
    }

    private Level getLogLevelForAlertState(AlertState state) {
        if (state == AlertState.ALARM) {
            return Level.SEVERE;
        }
        if (state == AlertState.WARNING) {
            return Level.WARNING;
        }
        return Level.INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Get the Raised Alert Summary", type=Command.CommandType.QUERY)
    public final RaisedAlertSummary getRaisedAlertSummary() {
        Object object = this.alertLock;
        synchronized (object) {
            return this.raisedAlertBookkeeper;
        }
    }

    @Command(description="set the level of a Logger", type=Command.CommandType.QUERY)
    public void setLogLevel(String keyLogger, String levelName) {
        Logger logger = Logger.getLogger(keyLogger);
        Level level = Level.parse(levelName);
        logger.setLevel(level);
    }

    @Command(description="sets the the depth of stacktraces in Logger messages", type=Command.CommandType.QUERY)
    public void setStackTraceDepth(int depth) {
        StackTraceFormats.setDepth((int)depth);
    }

    @Command(description="sets the format used by TextFormatter for LogEvent messages ", type=Command.CommandType.QUERY)
    public void setLogFormat(String format) {
        Formatter formatter = this.logBusHandler.getFormatter();
        if (!(formatter instanceof TextFormatter)) {
            throw new IllegalArgumentException(" formatter to LogBusHandler not a TextFormatter");
        }
        TextFormatter textFormatter = (TextFormatter)formatter;
        textFormatter.setFormat(format);
    }

    @Command(description="sets the handler (ConsoleHandler, FileHandler, LogBusHandler) log level", type=Command.CommandType.QUERY)
    public void setLogHandlerLevel(String handlerName, String level) {
        Level newLevel = Level.parse(level);
        Handler h = this.getLogHandler(handlerName);
        if (h == null) {
            throw new RuntimeException("Could not get LogHandler for name " + handlerName);
        }
        h.setLevel(newLevel);
    }

    public Handler getLogHandler(String handlerName) {
        Handler[] handlers;
        String lowerHandlerName = handlerName.toLowerCase();
        if (!lowerHandlerName.endsWith("handler")) {
            lowerHandlerName = lowerHandlerName + "handler";
        }
        if (lowerHandlerName.equals("logbushandler")) {
            return this.logBusHandler;
        }
        Logger rootLogger = Logger.getLogger("");
        for (Handler h : handlers = rootLogger.getHandlers()) {
            if (!h.getClass().getSimpleName().toLowerCase().equals(lowerHandlerName)) continue;
            return h;
        }
        return null;
    }

    @Command(description="gets the number of commands which are currently running (except the current one!)", type=Command.CommandType.QUERY)
    public int getNumberCommandThreads() {
        return this.getCommandCount(new Command.CommandType[0]);
    }

    @Command(description="gets the name of commands which are currently running", type=Command.CommandType.QUERY)
    public String printRunningCommands() {
        Agent.RunningCommand action;
        StringBuilder sb = new StringBuilder();
        HashSet commands = new HashSet(this.currentQueries);
        if (commands.size() > 1) {
            sb.append("Queries:\n");
            commands.forEach(task -> {
                if (!task.request.getBasicCommand().getCommand().equals("printRunningCommands")) {
                    sb.append(task).append("\n");
                }
            });
        }
        if ((action = this.currentAction) != null) {
            sb.append("Actions:\n").append(action).append("\n");
        }
        if (!(commands = new HashSet(this.currentQueries)).isEmpty()) {
            sb.append("Signals:\n");
            commands.forEach(task -> sb.append(task).append("\n"));
        }
        return sb.toString();
    }

    @Command(description="broadcast on the status bus a message of presence", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void ping() {
        this.broadcastStatus();
    }

    public final void persistNow() {
        if (this.subsystemPersistencyService != null) {
            try {
                this.subsystemPersistencyService.persistNow();
            }
            catch (IOException ex) {
                this.getLogger().error((Object)"could not write persist data", (Throwable)ex);
            }
        }
    }

    public final SubsystemConfigurationEnvironment getSubsystemConfigurationEnvironment() {
        return this.subsystemConfigurationEnvironment;
    }

    @Deprecated
    public final void saveAllChanges() throws ConfigurationServiceException {
        this.subsystemConfigurationEnvironment.saveAllChanges();
    }

    @Deprecated
    public final void saveChangesForCategories(String ... categories) {
        this.subsystemConfigurationEnvironment.saveChangesForCategories(categories);
    }

    @Deprecated
    public final void saveChangesForCategoriesAs(String ... taggedCategories) {
        this.subsystemConfigurationEnvironment.saveChangesForCategoriesAs(taggedCategories);
    }

    @Deprecated
    public void dropAllChanges() {
        this.subsystemConfigurationEnvironment.dropAllChanges();
    }

    @Deprecated
    public void dropChangesForCategories(String ... categories) {
        this.subsystemConfigurationEnvironment.dropChangesForCategories(categories);
    }

    @Deprecated
    public void loadConfiguration(String ... taggedCategories) {
        this.subsystemConfigurationEnvironment.loadConfiguration(taggedCategories);
    }

    @Deprecated
    public void loadCategories(String ... taggedCategories) {
        if (taggedCategories.length == 0) {
            return;
        }
        this.subsystemConfigurationEnvironment.loadCategories(taggedCategories);
    }

    @Deprecated
    public void change(String componentName, String parameterName, Object value) {
        this.subsystemConfigurationEnvironment.change(componentName, parameterName, value);
    }

    @Deprecated
    public void submitChange(String componentName, String parameterName, Object value) {
        this.subsystemConfigurationEnvironment.submitChange(componentName, parameterName, value);
    }

    @Deprecated
    public void commitBulkChange() {
        this.subsystemConfigurationEnvironment.commitBulkChange();
    }

    @Deprecated
    public void dropAllSubmittedChanges() {
        this.subsystemConfigurationEnvironment.dropAllSubmittedChanges();
    }

    @Deprecated
    public void dropSubmittedChangesForComponent(@Argument(description="the component name") String name) {
        this.subsystemConfigurationEnvironment.dropSubmittedChangesForComponent(name);
    }

    @Deprecated
    public Map<String, String> getSubmittedChangesForComponent(@Argument(description="the component name") String name) {
        return this.subsystemConfigurationEnvironment.getSubmittedChangesForComponent(name);
    }

    @Deprecated
    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        return this.subsystemConfigurationEnvironment.getAllSubmittedChanges();
    }

    @Deprecated
    public Set<String> getCategories() {
        return this.subsystemConfigurationEnvironment.getCategories();
    }

    @Deprecated
    public Set<String> findAvailableConfigurationsForCategory(String category) {
        return this.subsystemConfigurationEnvironment.findAvailableConfigurationsForCategory(category);
    }

    @Deprecated
    public Map<String, String> getCurrentValuesForComponent(String componentName, Set<String> categorySet) {
        return this.subsystemConfigurationEnvironment.getCurrentValuesForComponent(componentName, categorySet);
    }

    @Deprecated
    public boolean isParameterConfigurable(String componentName, String parameterName) {
        return this.subsystemConfigurationEnvironment.isParameterConfigurable(componentName, parameterName);
    }

    @Deprecated
    public ConfigurationInfo getConfigurationInfo() {
        return this.subsystemConfigurationEnvironment.getConfigurationInfo();
    }

    @Deprecated
    public String getTag() {
        return this.getDescription();
    }

    public String getDescription() {
        return this.descriptionName;
    }

    public static final Subsystem getSubsystemForObject(Object obj) {
        return (Subsystem)OBJECT_SUBSYSTEM_MAP.get(obj);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironment(Object obj) {
        String name = this.getComponentLookup().getNameOfComponent(obj);
        return this.getComponentConfigurationEnvironmentByName(name);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironmentByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Provided name cannot be null.");
        }
        ComponentConfigurationEnvironment environment = this.keyEnvironmentMap.get(name);
        if (environment == null) {
            throw new IllegalArgumentException("No Component with name \"" + name + "\" containing configuration parameters.");
        }
        return environment;
    }

    private final class AlertRunnable
    implements Runnable {
        private final Alert alert;
        private final AlertState severity;
        private String cause;
        private long ts;
        private int count = 0;

        private AlertRunnable(AlertRunnable other) {
            this(other.alert, other.severity, other.ts, other.cause);
        }

        private AlertRunnable(Alert alert, AlertState severity, long timestamp, String cause) {
            this.alert = alert;
            this.severity = severity;
            this.ts = timestamp;
            this.accumulate(cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void accumulate(String cause) {
            Object object = Subsystem.this.alertLock;
            synchronized (object) {
                this.cause = cause;
                ++this.count;
            }
        }

        @Override
        public void run() {
            this.updateBookkeeperAndSendStatusAlert();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateBookkeeperAndSendStatusAlert() {
            Object object = Subsystem.this.alertLock;
            synchronized (object) {
                if (this.count <= 0) {
                    return;
                }
                RaisedAlertHistory raisedAlert = Subsystem.this.raisedAlertBookkeeper.raiseAlert(this.alert, this.severity, this.ts, this.cause, this.count);
                AlertState globalSeverity = Subsystem.this.raisedAlertBookkeeper.getAlertState();
                if (globalSeverity == AlertState.ALARM && !Subsystem.this.isInState((Enum)AlertState.ALARM)) {
                    Subsystem.this.updateInternalState(new AgentState[]{AlertState.ALARM, OperationalState.ENGINEERING_FAULT});
                } else if (globalSeverity == AlertState.WARNING && Subsystem.this.getState(AlertState.class).compareTo(AlertState.WARNING) < 0) {
                    Subsystem.this.updateInternalState(new AgentState[]{AlertState.WARNING});
                }
                Subsystem.this.getLogger().log(Subsystem.this.getLogLevelForAlertState(this.severity), "Raised Alert " + this.alert.getAlertId() + "(" + this.alert.getDescription() + ") " + this.count + " times. Last cause : \"" + this.cause + "\". Overall AlertState=" + globalSeverity.name(), (Object)"");
                StatusRaisedAlert statusAlert = new StatusRaisedAlert(this.alert, raisedAlert.getLatestAlertCause(), Subsystem.this.getState(), new RaisedAlertSummary(Subsystem.this.getRaisedAlertSummary()));
                Subsystem.this.getMessagingAccess().sendStatusMessage((StatusMessage)statusAlert);
            }
        }
    }
}

