/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystems.fcs.ui.commons.BottomPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class GeneralPanel
extends JPanel
implements StatusMessageListener {
    private static final long serialVersionUID = -1056620058636291687L;
    protected GeneralGUI subs;
    private final SubsystemPanel subsystemPanel;
    private final BottomPanel bottomPanel;
    private final JSplitPane splitPane = new JSplitPane(0);

    public GeneralPanel() {
        this.subsystemPanel = new SubsystemPanel("Subsystem State");
        this.bottomPanel = new BottomPanel("Bottom_Panel_Title");
        this.initComponents();
    }

    public GeneralPanel(GeneralGUI subs, BottomPanel bottomPanel) {
        this.subs = subs;
        this.subsystemPanel = new SubsystemPanel(subs.destination);
        this.subsystemPanel.setSubsystem(subs);
        this.bottomPanel = bottomPanel;
        this.initComponents();
    }

    public SubsystemPanel getSubsystemPanel() {
        return this.subsystemPanel;
    }

    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) throws InterruptedException, InvocationTargetException {
        this.subsystemPanel.initializeGui(configInfo);
        this.bottomPanel.initializeGUIWithConfigInfo(configInfo, hardwareList);
    }

    public void initializeGUIWithLoaderConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) throws InterruptedException, InvocationTargetException {
        this.bottomPanel.initializeGUIWithLoaderConfigInfo(configInfo, hardwareList);
    }

    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) throws InterruptedException, InvocationTargetException {
        this.bottomPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
    }

    private void initComponents() {
        JScrollPane bottomScrollPane = new JScrollPane(this.bottomPanel);
        this.splitPane.setTopComponent(this.subsystemPanel);
        this.splitPane.setBottomComponent(bottomScrollPane);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.splitPane, gbc);
    }

    public void onStatusMessage(StatusMessage msg) {
        this.bottomPanel.onStatusMessage(msg);
    }

    void resetPanel() {
        this.bottomPanel.resetPanel();
    }

    public static void main(String[] argv) {
        GeneralPanel d = new GeneralPanel();
        JFrame frame = new JFrame("Panel with Tree");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

