
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.Color;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import static org.lsst.ccs.subsystems.fcs.FcsEnumerations.greenColor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.SwingConstants;
import static org.lsst.ccs.subsystems.fcs.FCSCst.NO_FILTER;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.VERY_BIG_FONT;

/**
 *
 * @author virieux
 */
public class SingleFilterTestExchangePanel extends JPanel {
    private static final long serialVersionUID = -7001734238755354500L;
    
    // Variables declaration
    private static final String CLAMPXMINUS_NAME = "clampXminus";
    private static final String CLAMPXPLUS_NAME = "clampXplus";
    private static final String CLAMPXMINUS_CTL_NAME= "clampXminusController";
    private static final String CLAMPXPLUS_CTL_NAME= "clampXplusController";
    private static final String LATCHXMINUS_CTL_NAME = "latchActuatorXminus";
    private static final String LATCHXPLUS_CTL_NAME = "latchActuatorXplus";
    private AnalogMeter clampActuatorCurrentMeterXminus;
    private AnalogMeter clampActuatorCurrentMeterXplus;
    private org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel filterInAutochangerPanel;
    private org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel filterInCarouselPanel;
    private JLabel filterPositionInClampXMinusLabel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.VerticalProgressBar filterPositionInClampXMinusProgress;
    private DigitalSwitch filterPositionInClampXMinusSwitch;
    private JLabel filterPositionInClampXPlusLabel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.VerticalProgressBar filterPositionInClampXPlusProgress;
    private DigitalSwitch filterPositionInClampXPlusSwitch;
    private DigitalSwitch filterPresenceSensorLatchXminus;
    private DigitalSwitch filterPresenceSensorLatchXplus;
    private JLabel xMinusLabel;
    private JLabel xPlusLabel2;
    private JLabel xPlusLabel;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel3;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel40;
    private JLabel jLabel42;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel xMinusLabel2;
    private AnalogMeter latchActuatorCurrentMeterXminus;
    private AnalogMeter latchActuatorCurrentMeterXplus;
    private DigitalSwitch lockSensorPositionLatchXminus;
    private DigitalSwitch lockSensorPositionLatchXplus;
    private JLabel lockSensorStateClampXMinusLabel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.HorizontalProgressBar lockSensorStateClampXMinusProgress;
    private DigitalSwitch lockSensorStateClampXMinusSwitch;
    private JLabel lockSensorStateClampXPlusLabel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.HorizontalProgressBar lockSensorStateClampXPlusProgress;
    private DigitalSwitch lockSensorStateClampXPlusSwitch;
    private JLabel lockSensorXMinusState;
    private JLabel lockSensorXPlusState;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.MovementPanel movementPanel;
    private JLabel positionSensorXMinusState;
    private JLabel positionSensorXPlusState;
    private DigitalSwitch railSensorHandOffPositionXminus;
    private DigitalSwitch railSensorHandOffPositionXplus;
    private DigitalSwitch railSensorStandByPositionXminus;
    private DigitalSwitch railSensorStandByPositionXplus;
    private DigitalSwitch unlockSensorPositionLatchXminus;
    private DigitalSwitch unlockSensorPositionLatchXplus;
    // End of variables declaration   
    
    /**
     * A Runnable to initialize this Panel from configuration data.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {

            jLabel3.setText(configInfo.getDescriptionName());
            //Retrieve the configuration data for clampXminus.
            Map<String, String> xMinusClampConfig = configInfo.getCurrentValuesFor(CLAMPXMINUS_NAME);
            Map<String, String> xPlusClampConfig = configInfo.getCurrentValuesFor(CLAMPXPLUS_NAME);
            configureClampFilterPositionProgressBar(filterPositionInClampXMinusProgress, xMinusClampConfig);
            configureClampFilterPositionProgressBar(filterPositionInClampXPlusProgress, xPlusClampConfig);
            configureClampLockSensorProgressBar(lockSensorStateClampXMinusProgress, xMinusClampConfig);
            configureClampLockSensorProgressBar(lockSensorStateClampXPlusProgress, xPlusClampConfig);

            Map<String, String> clampXminusControllerConfig = configInfo.getCurrentValuesFor(CLAMPXMINUS_CTL_NAME);
            clampActuatorCurrentMeterXminus.setLimits(0, 
                    Tools.toInt(clampXminusControllerConfig,"sentCurrentMaxValue"));
            
            Map<String, String> clampXplusControllerConfig = configInfo.getCurrentValuesFor(CLAMPXPLUS_CTL_NAME);
            clampActuatorCurrentMeterXplus.setLimits(0, 
                    Tools.toInt(clampXplusControllerConfig,"sentCurrentMaxValue"));

            Map<String, String> latchXminusActuatorConfig = configInfo.getCurrentValuesFor(LATCHXMINUS_CTL_NAME);
            latchActuatorCurrentMeterXminus.setLimits(Tools.toInt(latchXminusActuatorConfig,"speedVoltageMinValue"), 
                    Tools.toInt(latchXminusActuatorConfig,"speedVoltageMaxValue"));
            
            Map<String, String> latchXplusActuatorConfig = configInfo.getCurrentValuesFor(LATCHXPLUS_CTL_NAME);
            latchActuatorCurrentMeterXplus.setLimits(Tools.toInt(latchXplusActuatorConfig,"speedVoltageMinValue"), 
                    Tools.toInt(latchXplusActuatorConfig,"speedVoltageMaxValue"));

        }
    }
    
        /**
     * A Runnable to update the Panel from data published by a Carousel clamp controller.
     */
    private class UpdateActuator implements Runnable {

        private StatusDataPublishedByClampActuator s;

        UpdateActuator(StatusDataPublishedByClampActuator s) {
            this.s = s;
        }

        @Override
        public void run() {
            String actuatorName = s.getName();
            AnalogMeter meter = null;

            switch (actuatorName) {
                case "clampXplusController":
                    meter = clampActuatorCurrentMeterXplus;
                    break;
                case "clampXminusController":
                    meter = clampActuatorCurrentMeterXminus;
                    break;
                case "latchActuatorXplus":
                    meter = latchActuatorCurrentMeterXminus;
                    break;
                case "latchActuatorXminus":
                    meter = latchActuatorCurrentMeterXplus;
                    break;
                default:
                    FCSLOG.error("Unexpected actuator name: " + actuatorName);
            }
            if (meter != null) {
                meter.setValue(s.getSentValue());
            }


        }
    }

    /**
     * A Runnable to update the Panel from data published by Carousel.
     */
    private class UpdateAutoChanger implements Runnable {

        private StatusDataPublishedByBasicAutoChanger s;

        UpdateAutoChanger(StatusDataPublishedByBasicAutoChanger s) {
            this.s = s;
        }

        @Override
        public void run() {

            filterInAutochangerPanel.setIsFilterInHouse(!s.isTrucksEmpty(), "dummyFilter");
            railSensorHandOffPositionXminus.setColor(s.getRailSensorStandbackXminusValue() ? greenColor : Color.gray);
            railSensorHandOffPositionXplus.setColor(s.getRailSensorStandbackXplusValue() ? greenColor : Color.gray);
            railSensorStandByPositionXminus.setColor(s.getRailSensorStandbyXminusValue() ? greenColor : Color.gray);
            railSensorStandByPositionXplus.setColor(s.getRailSensorStandbyXplusValue()  ? greenColor : Color.gray);

            movementPanel.setStatus(s.isMovingToStandback(), s.isMovingToStandby());

        }
    }

    /**
     * A Runnable to update the Panel from data published by Carousel.
     */
    private class UpdateCarousel implements Runnable {

        private final StatusDataPublishedByCarousel s;

        UpdateCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            filterInCarouselPanel.setIsFilterInHouse(!(s.getFilterAtStandbyName().equals(NO_FILTER)),
                    s.getFilterAtStandbyName());
        }
    }

    /**
     * A Runnable to update the Panel from data published by a latch.
     */
    private class UpdateLatch implements Runnable {

        private final StatusDataPublishedByAutochangerLatch s;

        UpdateLatch(StatusDataPublishedByAutochangerLatch s) {
            this.s = s;
        }

        @Override
        public void run() {

            String latchName = s.getName();

            DigitalSwitch lockSensorSwitch = latchName.toLowerCase().contains("xminus") ? lockSensorPositionLatchXminus : lockSensorPositionLatchXplus;
            DigitalSwitch unlockSensorSwitch = latchName.toLowerCase().contains("xminus") ? unlockSensorPositionLatchXminus : unlockSensorPositionLatchXplus;
            DigitalSwitch filterPositionSensorSwitch = latchName.toLowerCase().contains("xminus") ? filterPresenceSensorLatchXminus : filterPresenceSensorLatchXplus;

            filterPositionSensorSwitch.setColor(s.getFilterPresenceSensorValue() ? greenColor : Color.gray);
            
            lockSensorSwitch.updateColor(s.isInError(), s.getLockSensorValue());
            unlockSensorSwitch.updateColor(s.isInError(), s.getUnlockSensorValue());
        }
    }

    /**
     * A Runnable to update the Panel from data published by a clamp.
     */
    private class UpdateClamp implements Runnable {

        private final StatusDataPublishedByCarouselClamp s;

        UpdateClamp(StatusDataPublishedByCarouselClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            String clampName = s.getName();
            int filterPositionValue = s.getFilterPositionSensorValue();
            int lockSensorValue = s.getLockSensorValue();

            HorizontalProgressBar lockSensorProgressBar = clampName.toLowerCase().contains("xminus") ? lockSensorStateClampXMinusProgress : lockSensorStateClampXPlusProgress;
            VerticalProgressBar filterPositionProgressBar = clampName.toLowerCase().contains("xminus") ? filterPositionInClampXMinusProgress : filterPositionInClampXPlusProgress;

            DigitalSwitch lockSensorSwitch = clampName.toLowerCase().contains("xminus") ? lockSensorStateClampXMinusSwitch : lockSensorStateClampXPlusSwitch;
            DigitalSwitch filterPositionSwitch = clampName.toLowerCase().contains("xminus") ? filterPositionInClampXMinusSwitch : filterPositionInClampXPlusSwitch;

            JLabel lockSensorLabel = clampName.toLowerCase().contains("xminus") ? lockSensorXMinusState : lockSensorXPlusState;
            JLabel filterPositionSensorLabel = clampName.toLowerCase().contains("xminus") ? positionSensorXMinusState : positionSensorXPlusState;

            //Color lockSensorColor = getLockSensorColor(lockSensorStatus);
            Color lockSensorColor = s.getLockStatus().getColor();
            lockSensorProgressBar.setValueAndColor(lockSensorValue, lockSensorColor);
            lockSensorSwitch.setColor(lockSensorColor);

            //Color filterPositionColor = getFilterPresenceColor(filterPositionState);
            Color filterPositionColor = s.getFilterPresenceStatus().getColor();
            filterPositionProgressBar.setValueAndColor(filterPositionValue, filterPositionColor);
            filterPositionSwitch.setColor(filterPositionColor);

            lockSensorLabel.setText(s.getLockStatus().toString());
            lockSensorLabel.setForeground(lockSensorColor);
            filterPositionSensorLabel.setText(s.getFilterPresenceStatus().toString());
            filterPositionSensorLabel.setForeground(filterPositionColor);
        }

    }

    public SingleFilterTestExchangePanel() {
        initComponents();
    }
    
    
    
    protected void initializeGui(ConfigurationInfo configInfo)  {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    
    public void updateClamp(StatusDataPublishedByCarouselClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateLatch(StatusDataPublishedByAutochangerLatch status) {
        SwingUtilities.invokeLater(new UpdateLatch(status));
    }

    public void updateAutoChanger(StatusDataPublishedByBasicAutoChanger status) {
        SwingUtilities.invokeLater(new UpdateAutoChanger(status));
    }

    public void updateCarousel(StatusDataPublishedByCarousel status) {
        SwingUtilities.invokeLater(new UpdateCarousel(status));
    }

    public void updateActuator(StatusDataPublishedByClampActuator status) {
        SwingUtilities.invokeLater(new UpdateActuator(status));
    }
    
    private static Color getLockSensorColor(String lockSensorStatus) {
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.ERROR.toString())) {
            return Color.red;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.LOCKED.toString())) {
            return greenColor;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNKNOWN.toString())) {
            return Color.orange;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNLOCKED.toString())) {
            return Color.blue;
        } else {
            throw new IllegalArgumentException("Unknown Lock Sensor Status " + lockSensorStatus);
        }
    }

    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        } else if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.LOCKABLE.toString())) {
            return greenColor;
        } else if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE.toString())) {
            return Color.orange;
        } else if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        } else {
            throw new IllegalArgumentException("Unknown Filter Presence Status " + filterPresenceStatus);
        }
    }

    private static void configureClampFilterPositionProgressBar(VerticalProgressBar progressBar, 
            Map<String,String> config) {
        progressBar.setValues(FCSCst.SENSOR14BITS_MIN, FCSCst.SENSOR14BITS_MAX,
                Tools.toInt(config,"filterPositionValueA"),
                Tools.toInt(config,"filterPositionValueB"),
                Tools.toInt(config,"filterPositionValueC"));
    }

    private static void configureClampLockSensorProgressBar(HorizontalProgressBar progressBar, 
            Map<String,String> config) {
        progressBar.setValues(FCSCst.SENSOR14BITS_MIN, FCSCst.SENSOR14BITS_MAX,
                Tools.toInt(config,"lockSensorValueA"),
                Tools.toInt(config,"lockSensorValueB"),
                Tools.toInt(config,"lockSensorValueC"));
    }
    
    private void initComponents() {

        
        xMinusLabel = new JLabel("X-");
        xMinusLabel.setFont(VERY_BIG_FONT); // NOI18N
        xPlusLabel = new JLabel("X+");        
        xPlusLabel.setFont(VERY_BIG_FONT); // NOI18N
        xMinusLabel2 = new JLabel("X-");
        xMinusLabel2.setFont(VERY_BIG_FONT); // NOI18N
        xPlusLabel2 = new JLabel("X+");
        xPlusLabel2.setFont(VERY_BIG_FONT); // NOI18N

        
        GridBagConstraints gridBagConstraints;
        jLabel22 = new JLabel();
        jLabel23 = new JLabel();
        jLabel21 = new JLabel();
        jLabel25 = new JLabel();

        jLabel20 = new JLabel();
        railSensorStandByPositionXminus = new DigitalSwitch();
        railSensorHandOffPositionXminus = new DigitalSwitch();
        railSensorHandOffPositionXplus = new DigitalSwitch();
        railSensorStandByPositionXplus = new DigitalSwitch();
        jLabel32 = new JLabel();
        jLabel34 = new JLabel();
        jLabel35 = new JLabel();
        lockSensorPositionLatchXminus = new DigitalSwitch();
        unlockSensorPositionLatchXminus = new DigitalSwitch();
        filterPresenceSensorLatchXminus = new DigitalSwitch();
        filterPresenceSensorLatchXplus = new DigitalSwitch();
        unlockSensorPositionLatchXplus = new DigitalSwitch();
        lockSensorPositionLatchXplus = new DigitalSwitch();
        jLabel36 = new JLabel();
        jLabel37 = new JLabel();
        jLabel40 = new JLabel();
        lockSensorStateClampXPlusLabel = new JLabel();
        
        filterInAutochangerPanel = new FilterPanel();
        filterInCarouselPanel = new FilterPanel();
        movementPanel = new MovementPanel();
        jLabel45 = new JLabel();
        jLabel46 = new JLabel();
        jLabel47 = new JLabel();
        jLabel33 = new JLabel();
        jLabel48 = new JLabel();
        jLabel24 = new JLabel();
        lockSensorStateClampXMinusSwitch = new DigitalSwitch();
        filterPositionInClampXMinusSwitch = new DigitalSwitch();
        filterPositionInClampXPlusSwitch = new DigitalSwitch();
        lockSensorStateClampXPlusSwitch = new DigitalSwitch();
        jLabel42 = new JLabel();
        filterPositionInClampXPlusLabel = new JLabel();
        lockSensorStateClampXMinusLabel = new JLabel();
        filterPositionInClampXMinusLabel = new JLabel();
        latchActuatorCurrentMeterXminus = new AnalogMeter();
        latchActuatorCurrentMeterXplus = new AnalogMeter();
        clampActuatorCurrentMeterXminus = new AnalogMeter();
        clampActuatorCurrentMeterXplus = new AnalogMeter();
        jLabel38 = new JLabel();
        jLabel39 = new JLabel();
        filterPositionInClampXMinusProgress = new VerticalProgressBar();
        filterPositionInClampXMinusProgress.setPosition("left");
        filterPositionInClampXPlusProgress = new VerticalProgressBar();
        filterPositionInClampXMinusProgress.setPosition("right");
        lockSensorStateClampXMinusProgress = new HorizontalProgressBar();
        lockSensorStateClampXMinusProgress.setPosition("left");
        lockSensorStateClampXPlusProgress = new HorizontalProgressBar();
        lockSensorStateClampXMinusProgress.setPosition("right");
        positionSensorXPlusState = new JLabel();
        lockSensorXMinusState = new JLabel();
        lockSensorXPlusState = new JLabel();
        positionSensorXMinusState = new JLabel();
        jLabel3 = new JLabel();

        setBorder(BorderFactory.createEtchedBorder());
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());


        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridwidth = 3;
        add(xMinusLabel, gridBagConstraints);
        
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 0;
        add(xPlusLabel, gridBagConstraints);

        jLabel22.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel22.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabel22.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        add(jLabel22, gridBagConstraints);

        jLabel23.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel23.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabel23.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 21;
        gridBagConstraints.fill = GridBagConstraints.VERTICAL;
        add(jLabel23, gridBagConstraints);

        jLabel21.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel21.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabel21.setMaximumSize(new java.awt.Dimension(100, 2));
        jLabel21.setPreferredSize(null);
        jLabel21.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        add(jLabel21, gridBagConstraints);

        jLabel25.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel25.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabel25.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 21;
        gridBagConstraints.fill = GridBagConstraints.VERTICAL;
        add(jLabel25, gridBagConstraints);


        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 23;
        add(xPlusLabel2, gridBagConstraints);

        jLabel20.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel20.setText("<html>Rail Sensor<br>Stand-back Position</html>");
        jLabel20.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 60, 0, 0);
        add(jLabel20, gridBagConstraints);

        GroupLayout railSensorStandByPositionXminusLayout = new GroupLayout(railSensorStandByPositionXminus);
        railSensorStandByPositionXminus.setLayout(railSensorStandByPositionXminusLayout);
        railSensorStandByPositionXminusLayout.setHorizontalGroup(
            railSensorStandByPositionXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        railSensorStandByPositionXminusLayout.setVerticalGroup(
            railSensorStandByPositionXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 13;
        add(railSensorStandByPositionXminus, gridBagConstraints);

        GroupLayout railSensorHandOffPositionXminusLayout = new GroupLayout(railSensorHandOffPositionXminus);
        railSensorHandOffPositionXminus.setLayout(railSensorHandOffPositionXminusLayout);
        railSensorHandOffPositionXminusLayout.setHorizontalGroup(
            railSensorHandOffPositionXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        railSensorHandOffPositionXminusLayout.setVerticalGroup(
            railSensorHandOffPositionXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.1;
        add(railSensorHandOffPositionXminus, gridBagConstraints);

        GroupLayout railSensorHandOffPositionXplusLayout = new GroupLayout(railSensorHandOffPositionXplus);
        railSensorHandOffPositionXplus.setLayout(railSensorHandOffPositionXplusLayout);
        railSensorHandOffPositionXplusLayout.setHorizontalGroup(
            railSensorHandOffPositionXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        railSensorHandOffPositionXplusLayout.setVerticalGroup(
            railSensorHandOffPositionXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 3;
        add(railSensorHandOffPositionXplus, gridBagConstraints);

        GroupLayout railSensorStandByPositionXplusLayout = new GroupLayout(railSensorStandByPositionXplus);
        railSensorStandByPositionXplus.setLayout(railSensorStandByPositionXplusLayout);
        railSensorStandByPositionXplusLayout.setHorizontalGroup(
            railSensorStandByPositionXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        railSensorStandByPositionXplusLayout.setVerticalGroup(
            railSensorStandByPositionXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 13;
        add(railSensorStandByPositionXplus, gridBagConstraints);

        jLabel32.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel32.setText("<html><P align=\"center\">Latch control<br>value</p></html>");
        jLabel32.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        add(jLabel32, gridBagConstraints);

        jLabel34.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel34.setText("<html><P align=\"center\">Lock<br>Position</p></html>");
        jLabel34.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 3);
        add(jLabel34, gridBagConstraints);

        jLabel35.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel35.setText("<html><P align=\"center\">Unlock<br>Position</p></html>");
        jLabel35.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        add(jLabel35, gridBagConstraints);

        GroupLayout lockSensorPositionLatchXminusLayout = new GroupLayout(lockSensorPositionLatchXminus);
        lockSensorPositionLatchXminus.setLayout(lockSensorPositionLatchXminusLayout);
        lockSensorPositionLatchXminusLayout.setHorizontalGroup(
            lockSensorPositionLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        lockSensorPositionLatchXminusLayout.setVerticalGroup(
            lockSensorPositionLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(lockSensorPositionLatchXminus, gridBagConstraints);

        GroupLayout unlockSensorPositionLatchXminusLayout = new GroupLayout(unlockSensorPositionLatchXminus);
        unlockSensorPositionLatchXminus.setLayout(unlockSensorPositionLatchXminusLayout);
        unlockSensorPositionLatchXminusLayout.setHorizontalGroup(
            unlockSensorPositionLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        unlockSensorPositionLatchXminusLayout.setVerticalGroup(
            unlockSensorPositionLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.1;
        add(unlockSensorPositionLatchXminus, gridBagConstraints);

        GroupLayout filterPresenceSensorLatchXminusLayout = new GroupLayout(filterPresenceSensorLatchXminus);
        filterPresenceSensorLatchXminus.setLayout(filterPresenceSensorLatchXminusLayout);
        filterPresenceSensorLatchXminusLayout.setHorizontalGroup(
            filterPresenceSensorLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        filterPresenceSensorLatchXminusLayout.setVerticalGroup(
            filterPresenceSensorLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(filterPresenceSensorLatchXminus, gridBagConstraints);

        GroupLayout filterPresenceSensorLatchXplusLayout = new GroupLayout(filterPresenceSensorLatchXplus);
        filterPresenceSensorLatchXplus.setLayout(filterPresenceSensorLatchXplusLayout);
        filterPresenceSensorLatchXplusLayout.setHorizontalGroup(
            filterPresenceSensorLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        filterPresenceSensorLatchXplusLayout.setVerticalGroup(
            filterPresenceSensorLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(filterPresenceSensorLatchXplus, gridBagConstraints);

        GroupLayout unlockSensorPositionLatchXplusLayout = new GroupLayout(unlockSensorPositionLatchXplus);
        unlockSensorPositionLatchXplus.setLayout(unlockSensorPositionLatchXplusLayout);
        unlockSensorPositionLatchXplusLayout.setHorizontalGroup(
            unlockSensorPositionLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        unlockSensorPositionLatchXplusLayout.setVerticalGroup(
            unlockSensorPositionLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(unlockSensorPositionLatchXplus, gridBagConstraints);

        GroupLayout lockSensorPositionLatchXplusLayout = new GroupLayout(lockSensorPositionLatchXplus);
        lockSensorPositionLatchXplus.setLayout(lockSensorPositionLatchXplusLayout);
        lockSensorPositionLatchXplusLayout.setHorizontalGroup(
            lockSensorPositionLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        lockSensorPositionLatchXplusLayout.setVerticalGroup(
            lockSensorPositionLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        add(lockSensorPositionLatchXplus, gridBagConstraints);

        jLabel36.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel36.setText("<html><P align=\"center\">Lock<br>Position</p></html>");
        jLabel36.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 6);
        add(jLabel36, gridBagConstraints);

        jLabel37.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel37.setText("<html><P align=\"center\">Unlock<br>Position</p></html>");
        jLabel37.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        add(jLabel37, gridBagConstraints);

        jLabel40.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel40.setText("<html><P align=\"center\">Filter<br>Engaged</p></html>");
        jLabel40.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 3);
        add(jLabel40, gridBagConstraints);

        lockSensorStateClampXPlusLabel.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        lockSensorStateClampXPlusLabel.setText("<html><P align=\"center\">Lock</p></html>");
        lockSensorStateClampXPlusLabel.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 19;
        add(lockSensorStateClampXPlusLabel, gridBagConstraints);


        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        add(xMinusLabel2, gridBagConstraints);

        GroupLayout filterInAutochangerPanelLayout = new GroupLayout(filterInAutochangerPanel);
        filterInAutochangerPanel.setLayout(filterInAutochangerPanelLayout);
        filterInAutochangerPanelLayout.setHorizontalGroup(
            filterInAutochangerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );
        filterInAutochangerPanelLayout.setVerticalGroup(
            filterInAutochangerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 9;
        add(filterInAutochangerPanel, gridBagConstraints);

        GroupLayout filterInCarouselPanelLayout = new GroupLayout(filterInCarouselPanel);
        filterInCarouselPanel.setLayout(filterInCarouselPanelLayout);
        filterInCarouselPanelLayout.setHorizontalGroup(
            filterInCarouselPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );
        filterInCarouselPanelLayout.setVerticalGroup(
            filterInCarouselPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridheight = 4;
        add(filterInCarouselPanel, gridBagConstraints);

        GroupLayout movementPanelLayout = new GroupLayout(movementPanel);
        movementPanel.setLayout(movementPanelLayout);
        movementPanelLayout.setHorizontalGroup(
            movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 120, Short.MAX_VALUE)
        );
        movementPanelLayout.setVerticalGroup(
            movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 90, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 12;
        add(movementPanel, gridBagConstraints);

        jLabel45.setFont(VERY_BIG_FONT); // NOI18N
        jLabel45.setText("CAROUSEL");
        jLabel45.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 17;
        add(jLabel45, gridBagConstraints);

        jLabel46.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel46.setText("<html><P align=\"right\">Rail Sensor<br>Stand-back Position</p></html>");
        jLabel46.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 60);
        add(jLabel46, gridBagConstraints);

        jLabel47.setFont(VERY_BIG_FONT); // NOI18N
        jLabel47.setText("CHANGER");
        jLabel47.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 11;
        add(jLabel47, gridBagConstraints);

        jLabel33.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel33.setText("<html><P align=\"center\">Unclamping<br>Current</p></html>");
        jLabel33.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        add(jLabel33, gridBagConstraints);

        jLabel48.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel48.setText("<html><P align=\"right\">Rail Sensor<br>Stand-by Position</p></html>");
        jLabel48.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 60);
        add(jLabel48, gridBagConstraints);

        jLabel24.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel24.setText("<html>Rail Sensor<br>Stand-by Position</html>");
        jLabel24.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 60, 0, 0);
        add(jLabel24, gridBagConstraints);

        GroupLayout lockSensorStateClampXMinusSwitchLayout = new GroupLayout(lockSensorStateClampXMinusSwitch);
        lockSensorStateClampXMinusSwitch.setLayout(lockSensorStateClampXMinusSwitchLayout);
        lockSensorStateClampXMinusSwitchLayout.setHorizontalGroup(
            lockSensorStateClampXMinusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        lockSensorStateClampXMinusSwitchLayout.setVerticalGroup(
            lockSensorStateClampXMinusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 17;
        add(lockSensorStateClampXMinusSwitch, gridBagConstraints);

        GroupLayout filterPositionInClampXMinusSwitchLayout = new GroupLayout(filterPositionInClampXMinusSwitch);
        filterPositionInClampXMinusSwitch.setLayout(filterPositionInClampXMinusSwitchLayout);
        filterPositionInClampXMinusSwitchLayout.setHorizontalGroup(
            filterPositionInClampXMinusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        filterPositionInClampXMinusSwitchLayout.setVerticalGroup(
            filterPositionInClampXMinusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 17;
        add(filterPositionInClampXMinusSwitch, gridBagConstraints);

        GroupLayout filterPositionInClampXPlusSwitchLayout = new GroupLayout(filterPositionInClampXPlusSwitch);
        filterPositionInClampXPlusSwitch.setLayout(filterPositionInClampXPlusSwitchLayout);
        filterPositionInClampXPlusSwitchLayout.setHorizontalGroup(
            filterPositionInClampXPlusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        filterPositionInClampXPlusSwitchLayout.setVerticalGroup(
            filterPositionInClampXPlusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 17;
        add(filterPositionInClampXPlusSwitch, gridBagConstraints);

        GroupLayout lockSensorStateClampXPlusSwitchLayout = new GroupLayout(lockSensorStateClampXPlusSwitch);
        lockSensorStateClampXPlusSwitch.setLayout(lockSensorStateClampXPlusSwitchLayout);
        lockSensorStateClampXPlusSwitchLayout.setHorizontalGroup(
            lockSensorStateClampXPlusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        lockSensorStateClampXPlusSwitchLayout.setVerticalGroup(
            lockSensorStateClampXPlusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 17;
        add(lockSensorStateClampXPlusSwitch, gridBagConstraints);

        jLabel42.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel42.setText("<html><P align=\"center\">Filter<br>Engaged</p></html>");
        jLabel42.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 6);
        add(jLabel42, gridBagConstraints);

        filterPositionInClampXPlusLabel.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        filterPositionInClampXPlusLabel.setText("<html><P align=\"center\">Filter</p></html>");
        filterPositionInClampXPlusLabel.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 19;
        add(filterPositionInClampXPlusLabel, gridBagConstraints);

        lockSensorStateClampXMinusLabel.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        lockSensorStateClampXMinusLabel.setText("<html><P align=\"center\">Lock</p></html>");
        lockSensorStateClampXMinusLabel.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 19;
        add(lockSensorStateClampXMinusLabel, gridBagConstraints);

        filterPositionInClampXMinusLabel.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        filterPositionInClampXMinusLabel.setText("<html><P align=\"center\">Filter</p></html>");
        filterPositionInClampXMinusLabel.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 19;
        add(filterPositionInClampXMinusLabel, gridBagConstraints);

        GroupLayout latchActuatorCurrentMeterXminusLayout = new GroupLayout(latchActuatorCurrentMeterXminus);
        latchActuatorCurrentMeterXminus.setLayout(latchActuatorCurrentMeterXminusLayout);
        latchActuatorCurrentMeterXminusLayout.setHorizontalGroup(
            latchActuatorCurrentMeterXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 160, Short.MAX_VALUE)
        );
        latchActuatorCurrentMeterXminusLayout.setVerticalGroup(
            latchActuatorCurrentMeterXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 95, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        add(latchActuatorCurrentMeterXminus, gridBagConstraints);

        GroupLayout latchActuatorCurrentMeterXplusLayout = new GroupLayout(latchActuatorCurrentMeterXplus);
        latchActuatorCurrentMeterXplus.setLayout(latchActuatorCurrentMeterXplusLayout);
        latchActuatorCurrentMeterXplusLayout.setHorizontalGroup(
            latchActuatorCurrentMeterXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 160, Short.MAX_VALUE)
        );
        latchActuatorCurrentMeterXplusLayout.setVerticalGroup(
            latchActuatorCurrentMeterXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 95, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        add(latchActuatorCurrentMeterXplus, gridBagConstraints);

        GroupLayout clampActuatorCurrentMeterXminusLayout = new GroupLayout(clampActuatorCurrentMeterXminus);
        clampActuatorCurrentMeterXminus.setLayout(clampActuatorCurrentMeterXminusLayout);
        clampActuatorCurrentMeterXminusLayout.setHorizontalGroup(
            clampActuatorCurrentMeterXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 160, Short.MAX_VALUE)
        );
        clampActuatorCurrentMeterXminusLayout.setVerticalGroup(
            clampActuatorCurrentMeterXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 95, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        add(clampActuatorCurrentMeterXminus, gridBagConstraints);

        GroupLayout clampActuatorCurrentMeterXplusLayout = new GroupLayout(clampActuatorCurrentMeterXplus);
        clampActuatorCurrentMeterXplus.setLayout(clampActuatorCurrentMeterXplusLayout);
        clampActuatorCurrentMeterXplusLayout.setHorizontalGroup(
            clampActuatorCurrentMeterXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 160, Short.MAX_VALUE)
        );
        clampActuatorCurrentMeterXplusLayout.setVerticalGroup(
            clampActuatorCurrentMeterXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 95, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        add(clampActuatorCurrentMeterXplus, gridBagConstraints);

        jLabel38.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel38.setText("<html><P align=\"center\">Latch control<br>value</p></html>");
        jLabel38.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        add(jLabel38, gridBagConstraints);

        jLabel39.setFont(new Font("Tahoma", 0, 14)); // NOI18N
        jLabel39.setText("<html><P align=\"center\">Unclamping<br>Current</p></html>");
        jLabel39.setHorizontalTextPosition(SwingConstants.RIGHT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        add(jLabel39, gridBagConstraints);

        GroupLayout filterPositionInClampXMinusProgressLayout = new GroupLayout(filterPositionInClampXMinusProgress);
        filterPositionInClampXMinusProgress.setLayout(filterPositionInClampXMinusProgressLayout);
        filterPositionInClampXMinusProgressLayout.setHorizontalGroup(
            filterPositionInClampXMinusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 40, Short.MAX_VALUE)
        );
        filterPositionInClampXMinusProgressLayout.setVerticalGroup(
            filterPositionInClampXMinusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = GridBagConstraints.SOUTH;
        add(filterPositionInClampXMinusProgress, gridBagConstraints);

        GroupLayout filterPositionInClampXPlusProgressLayout = new GroupLayout(filterPositionInClampXPlusProgress);
        filterPositionInClampXPlusProgress.setLayout(filterPositionInClampXPlusProgressLayout);
        filterPositionInClampXPlusProgressLayout.setHorizontalGroup(
            filterPositionInClampXPlusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 40, Short.MAX_VALUE)
        );
        filterPositionInClampXPlusProgressLayout.setVerticalGroup(
            filterPositionInClampXPlusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = GridBagConstraints.SOUTH;
        add(filterPositionInClampXPlusProgress, gridBagConstraints);

        GroupLayout lockSensorStateClampXMinusProgressLayout = new GroupLayout(lockSensorStateClampXMinusProgress);
        lockSensorStateClampXMinusProgress.setLayout(lockSensorStateClampXMinusProgressLayout);
        lockSensorStateClampXMinusProgressLayout.setHorizontalGroup(
            lockSensorStateClampXMinusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        lockSensorStateClampXMinusProgressLayout.setVerticalGroup(
            lockSensorStateClampXMinusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 50, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = GridBagConstraints.SOUTH;
        add(lockSensorStateClampXMinusProgress, gridBagConstraints);

        GroupLayout lockSensorStateClampXPlusProgressLayout = new GroupLayout(lockSensorStateClampXPlusProgress);
        lockSensorStateClampXPlusProgress.setLayout(lockSensorStateClampXPlusProgressLayout);
        lockSensorStateClampXPlusProgressLayout.setHorizontalGroup(
            lockSensorStateClampXPlusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        lockSensorStateClampXPlusProgressLayout.setVerticalGroup(
            lockSensorStateClampXPlusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGap(0, 50, Short.MAX_VALUE)
        );

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = GridBagConstraints.SOUTH;
        add(lockSensorStateClampXPlusProgress, gridBagConstraints);

        positionSensorXPlusState.setText("No Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 18;
        add(positionSensorXPlusState, gridBagConstraints);

        lockSensorXMinusState.setText("Locked");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = GridBagConstraints.SOUTH;
        add(lockSensorXMinusState, gridBagConstraints);

        lockSensorXPlusState.setText("Unlocked");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = GridBagConstraints.SOUTH;
        add(lockSensorXPlusState, gridBagConstraints);

        positionSensorXMinusState.setText("Unknown");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 18;
        add(positionSensorXMinusState, gridBagConstraints);

        jLabel3.setText("hardwareType");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 0;
        add(jLabel3, gridBagConstraints);
        
        railSensorStandByPositionXminus.setColor(Color.gray);
        railSensorHandOffPositionXminus.setColor(Color.gray);
        railSensorHandOffPositionXplus.setColor(Color.gray);
        railSensorStandByPositionXplus.setColor(Color.gray);
        lockSensorPositionLatchXminus.setColor(Color.gray);
        unlockSensorPositionLatchXminus.setColor(Color.gray);
        filterPresenceSensorLatchXminus.setColor(Color.gray);
        filterPresenceSensorLatchXplus.setColor(Color.gray);
        unlockSensorPositionLatchXplus.setColor(Color.gray);
        lockSensorPositionLatchXplus.setColor(Color.gray);

        filterPositionInClampXMinusProgress.setValueAndColor(0, Color.gray);
        filterPositionInClampXPlusProgress.setValueAndColor(0, Color.gray);
        lockSensorStateClampXMinusProgress.setValueAndColor(0, Color.gray);
        lockSensorStateClampXPlusProgress.setValueAndColor(0, Color.gray);

        filterPositionInClampXPlusSwitch.setColor(Color.gray);
        filterPositionInClampXMinusSwitch.setColor(Color.gray);
        lockSensorStateClampXPlusSwitch.setColor(Color.gray);
        lockSensorStateClampXMinusSwitch.setColor(Color.gray);

        movementPanel.setStatus(false, false);

        Color backgroundColor = getBackground();
        latchActuatorCurrentMeterXplus.setBackground(backgroundColor);
        latchActuatorCurrentMeterXminus.setBackground(backgroundColor);
        clampActuatorCurrentMeterXplus.setBackground(backgroundColor);
        clampActuatorCurrentMeterXminus.setBackground(backgroundColor);
    }// </editor-fold>
    
    @Override
    public String toString() {
        return "Filter Exchange Panel";
    }
}
