
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.ZERO_VALUE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerOnlineClampPanel extends JPanel {

    private static final long serialVersionUID = 7563287373167394297L;
    private final String clampName;

    // Variables declaration  
    private DigitalSwitch closeSensorDS;
    private DigitalSwitch closeSensorCDS;
    private DigitalSwitch openSensorDS;
    private DigitalSwitch openSensorCDS;
    private DigitalSwitch errorDS;

    private JLabel clampNameLabel;
    private JLabel closeLabel;
    private JLabel openLabel;
    private JLabel errorLabel;

    private JLabel lockStatus;

    //Config Parameters Panel
    private JPanel paramPanel;
    private final JLabel ctlLabel = new JLabel("current to close:");
    private final JLabel ctuLabel = new JLabel("current to open:");
    private final JLabel ctcLabel = new JLabel("current to clamp:");
    private final JLabel currentToCloseLabel = new JLabel();
    private final JLabel currentToOpenLabel = new JLabel();
    private final JLabel currentToClampLabel = new JLabel();

    //Controller Fault Panel
    private JPanel faultPanel;
    private DigitalSwitch faultSwitch;
    // End of variables declaration
    
    /* sent current panel*/
    private JPanel currentPanel;
    private final JLabel scLabel = new JLabel("current sent :");
    private final JLabel sentCurrentLabel = new JLabel();



    /**
     * 
     * A Runnable to initialize this Panel from configuration data.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            //Retrieve the configuration data for my name.
            Map<String, String> configForName = configInfo.getCurrentValuesFor(clampName);
            FCSLOG.fine(clampName + " configForName="+configForName);
            
            //Config Panel
            currentToCloseLabel.setText(configForName.get("currentToClose"));
            currentToOpenLabel.setText(configForName.get("currentToOpen"));
            currentToClampLabel.setText(configForName.get("currentToClamp"));
        }
    }


    /**
     * 
     * A Runnable to Update this Panel from status data published on STATUS bus.
     */
    class UpdateClamp implements Runnable {

        private StatusDataPublishedByAutochangerOnlineClamp s;

        public UpdateClamp(StatusDataPublishedByAutochangerOnlineClamp status) {
            this.s = status;
        }

        @Override
        public void run() {

            clampNameLabel.setText(s.getName());
            lockStatus.setText(s.getLockStatus().getText());
            lockStatus.setForeground(s.getLockStatus().getColor());
            closeSensorDS.updateColor(s.isLockSensorInError(), s.getLockSensorValue());
            openSensorDS.updateColor(s.isUnlockSensorInError(), s.getUnlockSensorValue());
            boolean inTravel = s.getLockStatus().equals(LockStatus.INTRAVEL);
            boolean unknown = s.getLockStatus().equals(LockStatus.UNKNOWN);
            if (s.isInError() || inTravel || unknown) {
                errorDS.setColor(s.getLockStatus().getColor());
                errorLabel.setText(s.getLockStatus().getText());
            } else {
                errorDS.setColor(LockStatus.NOERROR.getColor());
                errorLabel.setText(LockStatus.NOERROR.getText());
            }

            //controller
            if (!s.isControllerBooted()) {
                faultSwitch.setColor(Color.RED);
            } else if (s.isControllerInFault()) {
                faultSwitch.setColor(Color.ORANGE);
            } else {
                faultSwitch.setColor(greenColor);
            }
            
            //current panel
            sentCurrentLabel.setText(String.valueOf(s.getSentCurrent()));
        }
    }
    
    /**
     * Create a new Panel with a clamp name.
     * @param clampName 
     */
    public AutochangerOnlineClampPanel(String clampName) {
        this.clampName = clampName;
        initComponents();
    }


    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    
    
    public void updateClamp(StatusDataPublishedByAutochangerOnlineClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description"> 
    private void initComponents() {

        closeSensorDS = new DigitalSwitch();
        closeSensorCDS = new DigitalSwitch();
        openSensorDS = new DigitalSwitch();
        openSensorCDS = new DigitalSwitch();
        errorDS = new DigitalSwitch();

        clampNameLabel = new JLabel("myClamp");
        openLabel = new JLabel("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        closeLabel = new JLabel("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        errorLabel = new JLabel();
        lockStatus = new JLabel();

        /**
         * *****************************************************************************
         ** Config Parameters Panel
         * *****************************************************************************
         */
        paramPanel = new JPanel();
        paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = insets_std;
        //1st column
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = GridBagConstraints.LINE_START;
        paramPanel.add(ctlLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(ctuLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(ctcLabel, gbcp);

        //2nd column
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        paramPanel.add(currentToCloseLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(currentToOpenLabel, gbcp);
        gbcp.gridy++;
        paramPanel.add(currentToClampLabel, gbcp);


        /**
         * *****************************************************************************
         ** end of Config Parameters Panel
         * *****************************************************************************
         */
        
        /**
         * *****************************************************************************
         ** Controller Fault Panel
         * *****************************************************************************
         */
        faultPanel = new JPanel();
        faultSwitch = new DigitalSwitch();
        faultSwitch.setSize(50);
        faultPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
        faultPanel.setLayout(new GridBagLayout());
        faultPanel.setPreferredSize(new Dimension(100, 100));

        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = GridBagConstraints.CENTER;
        faultPanel.add(faultSwitch, gbcf);

        /**
         * *****************************************************************************
         ** end of Controller Fault Panel
         * *****************************************************************************
         */
        
        /**
         * *****************************************************************************
         ** Current Panel
         * *****************************************************************************
         */
        currentPanel = new JPanel();
        currentPanel.setBorder(BorderFactory.createTitledBorder("current in Controller"));
        currentPanel.setLayout(new GridBagLayout());
        gbcp = new GridBagConstraints();
        gbcp.insets = insets_std;
        //1st column
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = GridBagConstraints.LINE_START;
        currentPanel.add(scLabel, gbcp);
        
        //2nd column
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        currentPanel.add(sentCurrentLabel, gbcp);

         /**
         * *****************************************************************************
         ** end of Current Panel
         * *****************************************************************************
         */       
        /**
         * *****************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setDefaultValues();
        
        setBorder(BorderFactory.createEtchedBorder());
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_big;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(clampNameLabel, gbc);
        gbc.gridy++;
        add(lockStatus, gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        add(openSensorDS, gbc);
        gbc.gridy++;
        add(openLabel, gbc);

        gbc.gridx = 2;
        gbc.gridy = 0;
        add(closeSensorDS, gbc);
        gbc.gridy++;
        add(closeLabel, gbc);

        gbc.gridx = 3;
        gbc.gridy = 0;
        add(errorDS, gbc);
        gbc.gridy++;
        add(errorLabel, gbc);

        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        add(faultPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 5;
        add(paramPanel, gbc);
        
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.gridheight = 2;
        add(currentPanel, gbc);
    }
    
    private void setDefaultValues() {
        closeSensorDS.setColor(Color.gray);
        closeSensorCDS.setColor(Color.gray);
        openSensorDS.setColor(Color.gray);
        openSensorCDS.setColor(Color.gray);
        errorDS.setColor(Color.gray);
        errorLabel.setText("ERROR");
        lockStatus.setText(UNKNOWN_STATE);
        faultSwitch.setColor(Color.GRAY);
        currentToCloseLabel.setText(ZERO_VALUE);
        currentToOpenLabel.setText(ZERO_VALUE);
        currentToClampLabel.setText(ZERO_VALUE);
        sentCurrentLabel.setText(ZERO_VALUE);
    }
    
    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        if (clampName == null) {
            return "ONLINE clamp";
        } else {
            return clampName;
        }
    }

    public static void main(String[] argv) {

        AutochangerOnlineClampPanel d = new AutochangerOnlineClampPanel("clampName");
        JFrame frame = new JFrame("Autochanger OnlineClamp Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
