/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;

class ParameterPath
implements Serializable {
    private static final long serialVersionUID = -8374146985540286600L;
    final String componentName;
    final String codeName;
    final String parameterName;

    ParameterPath(String componentName, String codeName, String parameterName) {
        if (componentName == null || parameterName == null) {
            throw new IllegalArgumentException("null argument in ParameterPath");
        }
        if (codeName == null) {
            codeName = "";
        }
        this.componentName = componentName;
        this.codeName = codeName;
        this.parameterName = parameterName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterPath that = (ParameterPath)o;
        if (this.codeName != null ? !this.codeName.equals(that.codeName) : that.codeName != null) {
            return false;
        }
        if (!this.componentName.equals(that.componentName)) {
            return false;
        }
        return this.parameterName.equals(that.parameterName);
    }

    public int hashCode() {
        int result = this.componentName.hashCode();
        result = 31 * result + (this.codeName != null ? this.codeName.hashCode() : 0);
        result = 31 * result + this.parameterName.hashCode();
        return result;
    }

    public String toString() {
        return this.componentName + '/' + this.codeName + '/' + this.parameterName;
    }

    public static ParameterPath valueOf(String pathString) {
        String[] elements = pathString.split("/");
        if (elements.length != 3) {
            throw new IllegalArgumentException("PathString should be componentName/codeName/parameterName");
        }
        ParameterPath path = new ParameterPath(elements[0], elements[1], elements[2]);
        return path;
    }
}

