/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselBottomPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGatherPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

public class CarouselGUI
extends GeneralGUI
implements InterfaceCarouselGUI {
    private static final long serialVersionUID = 3716082311687590505L;
    private final long timeoutForOpeningClamps;
    private final long timeoutForRotation;
    private final long timeoutForCheckingFilterLocation = 2000L;

    public CarouselGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        CarouselGatherPanel carouselGatherPanel = new CarouselGatherPanel(this, "tcpProxy");
        CarouselBottomPanel carouselBottomPanel = new CarouselBottomPanel(carouselGatherPanel, "CAROUSEL");
        this.generalPanel = new GeneralPanel(this, carouselBottomPanel);
        this.pane = new JScrollPane(this.generalPanel);
        this.timeoutForOpeningClamps = 10000L;
        this.timeoutForRotation = 10000L;
    }

    @Override
    public String getName() {
        return "CarouselGUIModule";
    }

    @Override
    public void checkFiltersLocation() {
        new GeneralGUI.CommandSwingWorker("checkFiltersLocation", this.timeoutForCheckingFilterLocation).execute();
    }

    @Override
    public void rotate() {
        FCSCst.FCSLOG.info((Object)"Carousel rotating");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForRotation));
        new GeneralGUI.CommandSwingWorker("rotate", this.timeoutForRotation).execute();
    }

    @Override
    public void unlockClamps() {
        FCSCst.FCSLOG.info((Object)"Carousel unlocking clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningClamps));
        new GeneralGUI.CommandSwingWorker("unlockClamps", this.timeoutForOpeningClamps).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("CarouselGUI", AgentInfo.AgentType.CONSOLE);
        CarouselGUI t = new CarouselGUI(agent.getName(), "carousel", agent.getMessagingAccess());
        agent.start();
        JFrame frame = new JFrame("Carousel View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

