/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.subsystem.monitor.ui.tree.MonitorDisplay;

@ConsoleLookup(id="org.lsst.ccs.gconsole.plugins.monitor.MonitorView", name="Tree View", path="Built-In/Tree", description="Monitoring data view that displays its data in a tree of tables.")
public class TreeView
extends AbstractMonitorView {
    private final Tree jTree;
    private final JScrollPane scrollPane;
    private List<MonitorField> columns = Arrays.asList(MonitorField.NAME, MonitorField.VALUE, MonitorField.UNITS, MonitorField.LOW, MonitorField.ALERT_LOW, MonitorField.HIGH, MonitorField.ALERT_HIGH, MonitorField.DESCR);
    private List<MonitorField> compactColumns = Arrays.asList(MonitorField.NAME, MonitorField.VALUE);
    private final DataNode dataRoot = new DataNode("root");
    private final LinkedHashMap<String, DataNodeLeaf> path2data = new LinkedHashMap();

    public TreeView() {
        this.jTree = new Tree();
        this.scrollPane = new JScrollPane(this.jTree);
    }

    @Override
    public JComponent getPanel() {
        return this.scrollPane;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        super.setFilter(filter);
        List<String> fields = filter.getFields(true);
        if (fields != null) {
            this.compactColumns = new ArrayList<MonitorField>(fields.size());
            for (String field : fields) {
                this.compactColumns.add(MonitorField.getInstance(field));
            }
        }
        if ((fields = filter.getFields(false)) != null) {
            this.columns = new ArrayList<MonitorField>(fields.size());
            for (String field : fields) {
                this.columns.add(MonitorField.getInstance(field));
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.path2data.isEmpty();
    }

    @Override
    protected void addChannels(AgentInfo agent, Map<String, AgentChannel> channels) {
        boolean modified = false;
        for (Map.Entry<String, AgentChannel> e : channels.entrySet()) {
            int i;
            DataNodeLeaf leaf;
            String path = e.getKey();
            modified = this.path2data.put(path, leaf = new DataNodeLeaf(path.substring((i = path.lastIndexOf("/")) + 1), e.getValue())) == null || modified;
        }
        if (modified) {
            this.setChannels();
        }
    }

    @Override
    protected void removeChannels(AgentInfo agent, List<String> paths) {
        boolean modified = false;
        for (String path : paths) {
            modified = this.path2data.remove(path) != null || modified;
        }
        if (modified) {
            this.setChannels();
        }
    }

    @Override
    protected void updateChannels(AgentInfo agent, Map<String, Map.Entry<AgentChannel, List<String>>> channels) {
        channels.forEach((path, e) -> {
            DataNodeLeaf leaf = this.path2data.get(path);
            if (leaf != null) {
                if (!Objects.equals(leaf.channel, e.getKey())) {
                    leaf.channel = (AgentChannel)e.getKey();
                    leaf.update(null);
                } else {
                    leaf.update((List)e.getValue());
                }
            }
        });
    }

    private void setChannels() {
        String treeStateString = this.saveTreeState();
        this.buildDataTree();
        Map<String, String> treeStateMap = this.restoreDataTreeState(treeStateString);
        DefaultMutableTreeNode root = this.buildJTreeModel(this.dataRoot, true);
        this.jTree.setModel(new DefaultTreeModel(root));
        this.restoreJTreeState(treeStateMap, this.dataRoot, "");
    }

    private void buildDataTree() {
        ArrayList<Map.Entry<String, DataNodeLeaf>> channels = new ArrayList<Map.Entry<String, DataNodeLeaf>>(this.path2data.entrySet());
        this.sortChannels(channels);
        this.dataRoot.removeAllChildren();
        for (Map.Entry<String, DataNodeLeaf> e : channels) {
            String[] path = e.getKey().split("/+");
            DataNode parent = this.dataRoot;
            for (int level = 0; level < path.length - 1; ++level) {
                parent = parent.addChild(path[level]);
            }
            parent.addLeaf(e.getValue());
        }
        for (DataNodeLeaf leaf : this.path2data.values()) {
            int depth = 0;
            DataNode node = leaf.parent;
            while (node != null) {
                if (node.depth < ++depth) {
                    node.depth = depth;
                }
                node = node.parent;
            }
        }
    }

    private void sortChannels(ArrayList<Map.Entry<String, DataNodeLeaf>> channels) {
    }

    private DefaultMutableTreeNode buildJTreeModel(DataNode dataNode, boolean start) {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode parent = null;
        if (start) {
            node = dataNode.jNode;
            if (node == null) {
                dataNode.jNode = node = new DefaultMutableTreeNode(dataNode);
            } else {
                parent = (DefaultMutableTreeNode)node.getParent();
                node.removeAllChildren();
            }
        } else {
            dataNode.jNode = node = new DefaultMutableTreeNode(dataNode);
        }
        if (dataNode.leaves != null) {
            node.add(this.createLeavesNode(dataNode));
        }
        if (dataNode.children != null) {
            if (dataNode.flatten) {
                node.add(this.createDeepNode(dataNode));
            } else {
                for (DataNode child : dataNode.children) {
                    node.add(this.buildJTreeModel(child, false));
                }
            }
        }
        if (parent != null) {
            this.getJTreeModel().nodeStructureChanged(parent);
        }
        return node;
    }

    private DefaultMutableTreeNode createLeavesNode(DataNode node) {
        TableLeaves model = new TableLeaves(node);
        DefaultMutableTreeNode jNode = new DefaultMutableTreeNode(new TableHolder(model));
        int i = 0;
        while (i < node.leaves.size()) {
            DataNodeLeaf leaf = node.leaves.get(i);
            leaf.id = i++;
            leaf.jNode = jNode;
        }
        return jNode;
    }

    private DefaultMutableTreeNode createDeepNode(DataNode node) {
        TableModelDeep model = new TableModelDeep(node);
        DefaultMutableTreeNode jNode = new DefaultMutableTreeNode(new TableHolder(model));
        node.appendLeaves(new ArrayList<DataNodeLeaf>()).forEach(leaf -> {
            leaf.jNode = jNode;
        });
        return jNode;
    }

    private DefaultTreeModel getJTreeModel() {
        return (DefaultTreeModel)this.jTree.getModel();
    }

    private static String getPath(DataNode node, DataNodeLeaf leaf) {
        StringBuilder sb = new StringBuilder(leaf.name);
        DataNode parent = leaf.parent;
        while (parent != null) {
            if (parent == node) {
                return sb.toString();
            }
            sb.insert(0, "/").insert(0, parent.name);
            parent = parent.parent;
        }
        return null;
    }

    private String saveTreeState() {
        StringBuilder sb = new StringBuilder();
        this.saveTreeState(sb, this.dataRoot);
        return sb.length() == 0 ? "" : sb.substring(1);
    }

    private Map<String, String> restoreDataTreeState(String state) {
        String[] nodes;
        if (state.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        for (String node : nodes = state.split("\\+")) {
            String[] ss = node.split("=");
            data.put(ss[0], ss[1]);
        }
        this.restoreDataTreeState(data, this.dataRoot, "");
        return data;
    }

    private void restoreJTreeState(Map<String, String> data, DataNode node, String path) {
        int state;
        String stringState = data.get(path = path.isEmpty() ? node.name : path + "/" + node.name);
        if (stringState != null && ((state = Integer.parseInt(stringState)) & 8) > 0) {
            TreePath tp = new TreePath(node.jNode.getPath());
            this.jTree.expandPath(tp);
            if (node.children != null) {
                for (DataNode child : node.children) {
                    this.restoreJTreeState(data, child, path);
                }
            }
        }
    }

    private void saveTreeState(StringBuilder sb, DataNode node) {
        int state = 0;
        if (node.compact) {
            state |= 1;
        }
        if (node.flatten) {
            state |= 2;
        }
        if (node.flip) {
            state |= 4;
        }
        if (node.jNode != null && this.jTree.isExpanded(new TreePath(node.jNode.getPath()))) {
            state |= 8;
        }
        if (state != 0) {
            StringBuilder s = new StringBuilder(node.name);
            DataNode parent = node.parent;
            while (parent != null) {
                s.insert(0, "/").insert(0, parent.name);
                parent = parent.parent;
            }
            s.append("=").append(state);
            sb.append("+").append((CharSequence)s);
        }
        if (node.children != null) {
            for (DataNode child : node.children) {
                this.saveTreeState(sb, child);
            }
        }
    }

    private void restoreDataTreeState(Map<String, String> data, DataNode node, String path) {
        String stringState = data.get(path = path.isEmpty() ? node.name : path + "/" + node.name);
        if (stringState != null) {
            int state = Integer.parseInt(stringState);
            if ((state & 1) > 0) {
                node.compact = true;
            }
            if ((state & 2) > 0) {
                node.flatten = true;
            }
            if ((state & 4) > 0) {
                node.flip = true;
            }
        }
        if (node.children != null) {
            for (DataNode child : node.children) {
                this.restoreDataTreeState(data, child, path);
            }
        }
    }

    class TableModelDeep
    extends MonitorTable {
        private DataNode node;
        private final HashMap<String, int[]> path2cell;
        private final int nValueCols;
        private final List<MonitorField> extraColumns;

        TableModelDeep(DataNode node) {
            this.node = node;
            ArrayList<DataNodeLeaf> leaves = new ArrayList<DataNodeLeaf>();
            ArrayList<DataNodeLeaf> leaves3 = new ArrayList<DataNodeLeaf>();
            for (DataNodeLeaf leaf : node.appendLeaves(new ArrayList<DataNodeLeaf>())) {
                String[] path = TreeView.getPath(node, leaf).split("/+");
                if (path.length == 2) {
                    leaves.add(leaf);
                    continue;
                }
                if (path.length != 3) continue;
                leaves3.add(leaf);
            }
            leaves.addAll(leaves3);
            if (node.compact) {
                this.extraColumns = Collections.emptyList();
            } else {
                int n = TreeView.this.columns.size();
                HashSet<Object> presentFields = new HashSet<Object>();
                for (DataNodeLeaf leaf : leaves) {
                    AgentChannel channel = leaf.getChannel();
                    if (channel != null) {
                        for (Object f : TreeView.this.columns) {
                            if (channel.get(((MonitorField)f).name()) == null) continue;
                            presentFields.add(f);
                        }
                    }
                    if (presentFields.size() != n) continue;
                    break;
                }
                presentFields.remove(MonitorField.VALUE);
                presentFields.remove(MonitorField.NAME);
                this.extraColumns = new ArrayList<MonitorField>(presentFields.size());
                for (MonitorField f : TreeView.this.columns) {
                    if (!presentFields.contains(f)) continue;
                    this.extraColumns.add(f);
                }
            }
            ArrayList<String> rowNames = new ArrayList<String>();
            ArrayList<String> columnNames = new ArrayList<String>();
            this.path2cell = new LinkedHashMap<String, int[]>();
            ArrayList rows = new ArrayList();
            rows.add(null);
            String currentSection = "";
            int currentRow = 1;
            int currentColumn = 1;
            for (DataNodeLeaf leaf : leaves) {
                int iColumn;
                int iRow;
                String column;
                String row;
                String section;
                String path = TreeView.getPath(node, leaf);
                String[] sPath = path.split("/");
                if (sPath.length == 2) {
                    section = "";
                    row = node.flip ? sPath[1] : sPath[0];
                    column = node.flip ? sPath[0] : sPath[1];
                } else {
                    section = sPath[0];
                    row = node.flip ? sPath[2] : sPath[1];
                    row = row + "/" + section;
                    String string = column = node.flip ? sPath[1] : sPath[2];
                }
                if (!section.equals(currentSection)) {
                    rowNames.add(section);
                    rows.add(null);
                    ++currentRow;
                    currentSection = section;
                }
                if ((iRow = rowNames.indexOf(row) + 1) == 0) {
                    iRow = currentRow++;
                    rowNames.add(row);
                    rows.add(new ArrayList());
                }
                if ((iColumn = columnNames.indexOf(column) + 1) == 0) {
                    iColumn = currentColumn++;
                    columnNames.add(column);
                }
                this.path2cell.put(path, new int[]{iRow, iColumn});
                ((ArrayList)rows.get(iRow)).add(leaf);
            }
            this.nValueCols = columnNames.size();
            this.nRows = rows.size();
            this.nColumns = this.nValueCols + 1 + this.extraColumns.size();
            this.cells = new MonitorTable.Cell[this.nRows][];
            for (int ir = 0; ir < this.nRows; ++ir) {
                this.cells[ir] = new MonitorTable.Cell[this.nColumns];
                if (ir == 0) {
                    int ic;
                    this.cells[0][0] = new MonitorTable.Cell();
                    for (ic = 0; ic < this.nValueCols; ++ic) {
                        MonitorTable.Cell cell = new MonitorTable.Cell();
                        cell.setData(new MonitorTable.Data((String)columnNames.get(ic), 0));
                        this.cells[0][ic + 1] = cell;
                    }
                    for (ic = 0; ic < this.extraColumns.size(); ++ic) {
                        MonitorTable.Cell cell = new MonitorTable.Cell();
                        cell.setData(new MonitorTable.Data(this.extraColumns.get(ic).getTitle(), 0));
                        this.cells[0][ic + this.nValueCols + 1] = cell;
                    }
                    continue;
                }
                if (rows.get(ir) == null) {
                    MonitorTable.Cell cell = new MonitorTable.Cell();
                    cell.setData(new MonitorTable.Data("<html><b> " + (String)rowNames.get(ir - 1) + "</b>", 2));
                    this.cells[ir][0] = cell;
                    continue;
                }
                MonitorTable.Cell cell = new MonitorTable.Cell();
                cell.setData(new MonitorTable.Data(((String)rowNames.get(ir - 1)).split("/")[0], 2));
                this.cells[ir][0] = cell;
                for (int column = 0; column < this.extraColumns.size(); ++column) {
                    this.cells[ir][column + this.nValueCols + 1] = new MonitorTable.Cell((List)rows.get(ir), this.extraColumns.get(column));
                }
            }
            for (DataNodeLeaf leaf : leaves) {
                int[] cell = this.path2cell.get(TreeView.getPath(node, leaf));
                this.cells[cell[0]][cell[1]] = new MonitorTable.Cell(leaf, MonitorField.VALUE);
            }
            for (MonitorTable.Cell[] cc : this.cells) {
                for (int i = 0; i < cc.length; ++i) {
                    MonitorTable.Cell c = cc[i];
                    if (c == null) {
                        cc[i] = MonitorTable.Cell.EMPTY;
                        continue;
                    }
                    if (c.getData() != null) continue;
                    this.format(c);
                }
            }
        }

        @Override
        public List<int[]> getCells(MonitorTable.Item item, MonitorField field) {
            DataNodeLeaf leaf = (DataNodeLeaf)item;
            int[] cell = this.path2cell.get(TreeView.getPath(this.node, leaf));
            if (cell == null) {
                return Collections.emptyList();
            }
            if (this.extraColumns.isEmpty()) {
                return field == null || MonitorField.VALUE.equals(field) ? Collections.singletonList(cell) : Collections.emptyList();
            }
            if (MonitorField.VALUE.equals(field)) {
                return Collections.singletonList(cell);
            }
            if (field == null) {
                ArrayList<int[]> out = new ArrayList<int[]>(this.extraColumns.size() + 1);
                out.add(cell);
                for (int i = 0; i < this.extraColumns.size(); ++i) {
                    out.add(new int[]{cell[0], i + this.nValueCols + 1});
                }
                return out;
            }
            int col = this.extraColumns.indexOf(field);
            if (col == -1) {
                return Collections.emptyList();
            }
            cell[1] = col + this.nValueCols + 1;
            return Collections.singletonList(cell);
        }
    }

    class TableLeaves
    extends MonitorTable {
        private DataNode node;
        private List<MonitorField> cols;

        TableLeaves(DataNode node) {
            this.node = node;
            this.nRows = node.leaves.size();
            this.cols = node.compact ? TreeView.this.compactColumns : TreeView.this.columns;
            this.nColumns = this.cols.size();
            HashSet<MonitorField> presentFields = new HashSet<MonitorField>();
            presentFields.add(MonitorField.NAME);
            for (DataNodeLeaf leaf : node.leaves) {
                AgentChannel channel = leaf.getChannel();
                if (channel != null) {
                    for (MonitorField f : this.cols) {
                        if (channel.get(f.name()) == null) continue;
                        presentFields.add(f);
                    }
                }
                if (presentFields.size() != this.nColumns) continue;
                break;
            }
            if (presentFields.size() != this.nColumns) {
                this.cols = new ArrayList<MonitorField>(this.cols);
                this.cols.retainAll(presentFields);
                ((ArrayList)this.cols).trimToSize();
                this.nColumns = this.cols.size();
            }
            this.cells = new MonitorTable.Cell[this.nRows][this.nColumns];
            for (int row = 0; row < this.nRows; ++row) {
                DataNodeLeaf leaf;
                leaf = node.leaves.get(row);
                for (int col = 0; col < this.nColumns; ++col) {
                    MonitorField field = this.cols.get(col);
                    MonitorTable.Cell cell = new MonitorTable.Cell(leaf, field);
                    this.format(cell);
                    this.cells[row][col] = cell;
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.cols.get(column).getTitle();
        }

        @Override
        public List<int[]> getCells(MonitorTable.Item item, MonitorField field) {
            int column = this.cols.indexOf(field);
            if (column == -1) {
                return Collections.emptyList();
            }
            int row = this.node.leaves.indexOf(item);
            if (row == -1) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new int[]{row, column});
        }
    }

    class TableHolder {
        private final MonitorTable model;
        private final JPanel renderPanel;
        private final JPanel editPanel;

        TableHolder(MonitorTable model) {
            this.model = model;
            JTable table = model.makeTable();
            this.renderPanel = new JPanel(new BorderLayout());
            this.renderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(Color.BLACK)));
            if (model instanceof TableLeaves) {
                this.renderPanel.add((Component)table.getTableHeader(), "North");
            }
            this.renderPanel.add((Component)table, "Center");
            table = model.makeTable();
            this.editPanel = new JPanel(new BorderLayout());
            this.editPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(Color.BLACK)));
            if (model instanceof TableLeaves) {
                this.editPanel.add((Component)table.getTableHeader(), "North");
            }
            this.editPanel.add((Component)table, "Center");
        }

        JPanel getComponent(boolean editable) {
            return editable ? this.editPanel : this.renderPanel;
        }

        MonitorTable getTable() {
            return this.model;
        }
    }

    final class NodePanel
    extends Box {
        private final JLabel label;
        private JCheckBox compact;
        private JCheckBox flatten;
        private JCheckBox flip;
        private DataNode node;

        NodePanel() {
            super(0);
            this.label = new JLabel();
            this.add(this.label);
            this.compact = new JCheckBox();
            this.compact.setToolTipText("Compact");
            this.compact.setOpaque(false);
            this.compact.addActionListener(e -> {
                if (this.node != null) {
                    this.node.setCompact(this.compact.isSelected());
                }
            });
            this.add(this.compact);
            this.flatten = new JCheckBox();
            this.flatten.setToolTipText("Flatten");
            this.flatten.setOpaque(false);
            this.flatten.addActionListener(e -> {
                if (this.node != null) {
                    boolean selected = this.flatten.isSelected();
                    this.flip.setEnabled(selected);
                    this.node.setFlatten(selected);
                }
            });
            this.add(this.flatten);
            this.flip = new JCheckBox();
            this.flip.setToolTipText("Flip");
            this.flip.setOpaque(false);
            this.flip.addActionListener(e -> {
                if (this.node != null) {
                    this.node.setFlipped(this.flip.isSelected());
                }
            });
            this.add(this.flip);
            this.add(Box.createRigidArea(new Dimension(500, 0)));
            this.add(Box.createHorizontalGlue());
        }

        void setNode(DataNode node) {
            this.node = null;
            if (node != null) {
                this.label.setText(" " + node.name + " ");
                this.compact.setSelected(node.compact);
                boolean hasLeaves = false;
                for (int i = 0; i < node.jNode.getChildCount(); ++i) {
                    if (!node.jNode.getChildAt(i).isLeaf()) continue;
                    hasLeaves = true;
                    break;
                }
                this.compact.setEnabled(hasLeaves);
                this.flatten.setSelected(node.flatten);
                this.flip.setSelected(node.flip);
                this.flatten.setEnabled(node.depth == 2 || node.depth == 3);
                this.flip.setEnabled(node.flatten);
                this.node = node;
            }
        }
    }

    class TreeEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final TreeRenderer renderer;
        private Object editorValue;
        private Component component;

        public TreeEditor() {
            this.renderer = new TreeRenderer(true);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.editorValue = value;
            return this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            this.editorValue = null;
            if (anEvent instanceof MouseEvent) {
                this.redirect((MouseEvent)anEvent);
            }
            return false;
        }

        private void redirect(MouseEvent anEvent) {
            SwingUtilities.invokeLater(() -> {
                try {
                    MouseEvent ev = SwingUtilities.convertMouseEvent(anEvent.getComponent(), anEvent, this.component);
                    this.component.dispatchEvent(ev);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        private final NodePanel nodePanel;
        private final boolean editable;

        TreeRenderer(boolean editable) {
            this.nodePanel = new NodePanel();
            this.editable = editable;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object payload = treeNode.getUserObject();
            if (payload instanceof JComponent) {
                return (JComponent)payload;
            }
            if (payload instanceof TableHolder) {
                return ((TableHolder)payload).getComponent(this.editable);
            }
            if (payload instanceof DataNode) {
                this.nodePanel.setNode((DataNode)payload);
                return this.nodePanel;
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }

    class Tree
    extends JTree
    implements MonitorDisplay {
        private String expansionState;

        Tree() {
            super(new DefaultMutableTreeNode(""));
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setRowHeight(0);
            this.setCellRenderer(new TreeRenderer(false));
            this.setCellEditor(new TreeEditor());
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (TreeView.this.jTree.getRowForLocation(e.getX(), e.getY()) != -1) {
                        TreeView.this.jTree.startEditingAtPath(TreeView.this.jTree.getPathForLocation(e.getX(), e.getY()));
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.setEditable(true);
        }

        @Override
        public void saveData(OutputStream out, String mimeType) {
            List<AgentChannel> channels = TreeView.this.path2data.values().stream().map(leaf -> leaf.getChannel()).filter(channel -> channel != null).collect(Collectors.toList());
            LsstMonitorPlugin.saveData(out, mimeType, channels, TreeView.this.columns);
        }

        private boolean isDescendant(TreePath path1, TreePath path2) {
            int count2;
            int count1 = path1.getPathCount();
            if (count1 <= (count2 = path2.getPathCount())) {
                return false;
            }
            while (count1 != count2) {
                path1 = path1.getParentPath();
                --count1;
            }
            return path1.equals(path2);
        }

        void saveExpansionState(int row) {
            TreePath rowPath = this.getPathForRow(row);
            StringBuilder sb = new StringBuilder();
            int rowCount = this.getRowCount();
            for (int i = row; i < rowCount; ++i) {
                TreePath path = this.getPathForRow(i);
                if (i != row && !this.isDescendant(path, rowPath)) break;
                if (!this.isExpanded(path)) continue;
                sb.append(",").append(i - row);
            }
            this.expansionState = sb.toString();
        }

        void restoreExpanstionState(int row) {
            StringTokenizer stok = new StringTokenizer(this.expansionState, ",");
            while (stok.hasMoreTokens()) {
                int token = row + Integer.parseInt(stok.nextToken());
                TreeView.this.jTree.expandRow(token);
            }
        }
    }

    class DataNodeLeaf
    implements MonitorTable.Item {
        final String name;
        AgentChannel channel;
        DataNode parent;
        int id;
        DefaultMutableTreeNode jNode;

        DataNodeLeaf(String name, AgentChannel channel) {
            this.name = name;
            this.channel = channel;
        }

        @Override
        public AgentChannel getChannel() {
            return this.channel;
        }

        @Override
        public String getName() {
            return this.name;
        }

        void update(List<String> attributes) {
            ((TableHolder)this.jNode.getUserObject()).getTable().update(this, attributes);
            TreeView.this.getJTreeModel().nodeChanged(this.jNode);
        }
    }

    class DataNode {
        final String name;
        DataNode parent;
        boolean compact;
        boolean flatten;
        boolean flip;
        int depth;
        ArrayList<DataNodeLeaf> leaves;
        ArrayList<DataNode> children;
        DefaultMutableTreeNode jNode;

        DataNode(String name) {
            this.name = name;
        }

        void setCompact(boolean compact) {
            if (compact == this.compact) {
                return;
            }
            this.compact = compact;
            TreeView.this.buildJTreeModel(this, true);
            TreeView.this.jTree.expandPath(new TreePath(this.jNode.getPath()));
        }

        void setFlatten(boolean flatten) {
            if (flatten == this.flatten) {
                return;
            }
            this.flatten = flatten;
            TreeView.this.buildJTreeModel(this, true);
            TreeView.this.jTree.expandPath(new TreePath(this.jNode.getPath()));
        }

        void setFlipped(boolean flip) {
            if (flip == this.flip) {
                return;
            }
            this.flip = flip;
            TreeView.this.jTree.saveExpansionState(0);
            TreeView.this.buildJTreeModel(this, true);
            TreeView.this.jTree.restoreExpanstionState(0);
        }

        DataNode addChild(String name) {
            if (this.children == null) {
                this.children = new ArrayList(1);
            }
            for (DataNode child : this.children) {
                if (!child.name.equals(name)) continue;
                return child;
            }
            DataNode newChild = new DataNode(name);
            newChild.parent = this;
            this.children.add(newChild);
            return newChild;
        }

        void addLeaf(DataNodeLeaf leaf) {
            if (this.leaves == null) {
                this.leaves = new ArrayList(1);
            }
            this.leaves.add(leaf);
            leaf.parent = this;
        }

        void removeAllChildren() {
            this.leaves = null;
            this.children = null;
        }

        List<DataNodeLeaf> appendLeaves(List<DataNodeLeaf> out) {
            if (out == null) {
                out = new ArrayList<DataNodeLeaf>();
            }
            if (this.leaves != null) {
                out.addAll(this.leaves);
            }
            if (this.children != null) {
                for (DataNode child : this.children) {
                    child.appendLeaves(out);
                }
            }
            return out;
        }

        public String toString() {
            return this.name;
        }

        void showTable() {
            for (int i = 0; i < this.jNode.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.jNode.getChildAt(i);
                if (!child.isLeaf()) continue;
                TreePath path = new TreePath(child.getPath());
                TreeView.this.jTree.expandPath(path);
                return;
            }
        }
    }
}

