/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelState;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;

public abstract class MonitorTable
extends AbstractTableModel {
    public static final Color COLOR_FG = Color.BLACK;
    public static final Color COLOR_BG = Color.WHITE;
    private static final Color COLOR_GOOD = new Color(160, 255, 160);
    private static final Color COLOR_WARN = new Color(255, 255, 100);
    private static final Color COLOR_ERR = new Color(255, 160, 160);
    private static final Color COLOR_OFF = new Color(160, 200, 255);
    private static final Color COLOR_POPUP = new Color(255, 255, 160);
    private static final Color COLOR_MULTI = Color.LIGHT_GRAY;
    private static final Color COLOR_NA = Color.GRAY;
    protected int nRows;
    protected int nColumns;
    protected Cell[][] cells;
    private static final List<MonitorField> AFFECTED_BY_STATE = Arrays.asList(MonitorField.VALUE, MonitorField.HIGH, MonitorField.LOW);

    MonitorTable() {
    }

    MonitorTable(Cell[][] cells) {
        this.cells = cells;
        this.nRows = cells.length;
        this.nColumns = cells[0].length;
    }

    @Override
    public int getRowCount() {
        return this.nRows;
    }

    @Override
    public int getColumnCount() {
        return this.nColumns;
    }

    @Override
    public Data getValueAt(int row, int column) {
        return this.cells[row][column].getData();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Cell cell = this.cells[row][column];
        if (cell.getItems().size() != 1) {
            return false;
        }
        MonitorField field = cell.getField();
        return field != null & field.isEditable();
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Cell cell = this.cells[row][column];
        MonitorField field = cell.getField();
        boolean isHigh = MonitorField.HIGH.equals(field);
        if ((isHigh || MonitorField.LOW.equals(field)) && cell.getItems().size() == 1) {
            try {
                double newValue = Double.parseDouble(aValue.toString());
                AgentChannel channel = cell.getItems().get(0).getChannel();
                if (channel != null) {
                    String target = isHigh ? "limitHi" : "limitLo";
                    Console.getConsole().sendCommand(channel.getAgentName() + "/change", channel.getLocalPath(), target, newValue);
                }
            }
            catch (NumberFormatException x) {
                return;
            }
            super.setValueAt(this.getValueAt(row, column), row, column);
        } else {
            super.setValueAt(aValue, row, column);
        }
    }

    protected void update(Item item, List<String> attributes) {
        HashSet fields = new HashSet();
        if (attributes == null) {
            fields.add(null);
        } else {
            attributes.forEach(att -> {
                List<MonitorField> f = this.getField((String)att);
                fields.addAll(f);
            });
        }
        fields.forEach(field -> {
            List<int[]> affectedCells = this.getCells(item, (MonitorField)field);
            for (int[] index : affectedCells) {
                Data data;
                Cell cell = this.cells[index[0]][index[1]];
                field = cell.getField();
                List<Item> items = cell.getItems();
                int nItems = items.size();
                if (cell.getData() == Data.MULTI) {
                    data = this.format(items.get(0), (MonitorField)field);
                    for (int i = 1; i < nItems; ++i) {
                        Data other = this.format(items.get(i), (MonitorField)field);
                        if (data.equals(other)) continue;
                        data = null;
                        break;
                    }
                    if (data == null) continue;
                    cell.setData(data);
                    this.fireTableCellUpdated(index[0], index[1]);
                    continue;
                }
                data = this.format(item, (MonitorField)field);
                if (data.equals(cell.getData())) continue;
                cell.setData(data);
                this.fireTableCellUpdated(index[0], index[1]);
            }
        });
    }

    protected List<int[]> getCells(Item item, MonitorField field) {
        ArrayList<int[]> out = new ArrayList<int[]>();
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nColumns; ++col) {
                Cell cell = this.cells[row][col];
                if (!cell.getItems().contains(item) || field != null && !field.equals(cell.getField())) continue;
                out.add(new int[]{row, col});
            }
        }
        return out;
    }

    protected List<MonitorField> getField(String attribute) {
        if ("MONITOR_STATE".equals(attribute)) {
            return AFFECTED_BY_STATE;
        }
        return Collections.singletonList(MonitorField.valueOf(attribute));
    }

    protected Data format(Item item, MonitorField field) {
        if (MonitorField.NAME.equals(field)) {
            return new Data(item.getName(), null, null, 2);
        }
        AgentChannel channel = item.getChannel();
        if (channel == null) {
            return Data.NA;
        }
        Object value = channel.get(field.name());
        if (value == null) {
            return Data.NA;
        }
        String text = null;
        Color fgColor = null;
        Color bgColor = null;
        Integer horizontalAlignment = null;
        if (MonitorField.VALUE.equals(field)) {
            if (value instanceof Double) {
                if (((Double)value).isNaN()) {
                    text = "NaN";
                } else {
                    double d = (Double)value;
                    String f = (String)channel.get("MONITOR_FORMAT");
                    text = String.format(f == null ? "%f " : f, d);
                }
            } else {
                text = value.toString();
            }
            Object o = channel.get("MONITOR_STATE");
            if (o instanceof AgentChannelState) {
                AgentChannelState state = (AgentChannelState)o;
                bgColor = state.isOnline() ? (state.isGood() ? COLOR_GOOD : COLOR_ERR) : COLOR_OFF;
            }
            horizontalAlignment = 4;
        } else if (MonitorField.HIGH.equals(field) || MonitorField.LOW.equals(field)) {
            Object o;
            double d = Double.NaN;
            if (value instanceof Double) {
                d = (Double)value;
            } else if (value instanceof Float) {
                d = ((Float)value).doubleValue();
            } else if (value instanceof String) {
                try {
                    d = Double.parseDouble((String)value);
                }
                catch (NumberFormatException x) {
                    text = (String)value;
                }
            }
            if (Double.isNaN(d)) {
                if (text == null) {
                    text = "NaN";
                }
            } else {
                String f = (String)channel.get("MONITOR_FORMAT");
                text = String.format(f == null ? "%f " : f, d);
            }
            if ((o = channel.get("MONITOR_STATE")) instanceof AgentChannelState) {
                AgentChannelState state = (AgentChannelState)o;
                if (MonitorField.HIGH.equals(field) ? state.isHighLimitChange() : state.isLowLimitChange()) {
                    fgColor = Color.BLUE;
                }
            }
        } else if (MonitorField.LOW_WARN.equals(field) || MonitorField.HIGH_WARN.equals(field)) {
            if (value instanceof Double) {
                if (((Double)value).isNaN()) {
                    text = "NaN";
                } else {
                    double d = (Double)value;
                    String f = (String)channel.get("MONITOR_FORMAT");
                    text = f == null ? String.valueOf(d) : String.format(f, d);
                }
            } else {
                text = value.toString();
            }
        } else {
            text = MonitorField.ALERT_HIGH.equals(field) || MonitorField.ALERT_LOW.equals(field) ? "  \u2713" : value.toString();
        }
        return new Data(text, fgColor, bgColor, horizontalAlignment);
    }

    protected boolean format(Cell cell) {
        Data newData;
        MonitorField field = cell.getField();
        List<Item> items = cell.getItems();
        block0 : switch (items.size()) {
            case 0: {
                newData = new Data(field.getTitle(), 0);
                break;
            }
            case 1: {
                newData = this.format(items.get(0), field);
                break;
            }
            default: {
                newData = this.format(items.get(0), field);
                for (int i = 1; i < items.size(); ++i) {
                    newData = this.format(items.get(i), field);
                    if (newData.equals(this.format(items.get(i), field))) continue;
                    newData = Data.MULTI;
                    break block0;
                }
            }
        }
        if (newData.equals(cell.getData())) {
            return false;
        }
        cell.setData(newData);
        return true;
    }

    public JTable makeTable() {
        JTable table = new JTable(this);
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        TableCellRenderer headerRenderer = header.getDefaultRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setHorizontalAlignment(0);
        }
        Renderer renderer = new Renderer();
        table.setDefaultRenderer(Object.class, renderer);
        table.setAutoResizeMode(3);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setRowHeight(table.getRowHeight() + 2);
        table.setShowGrid(true);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MonitorTable.this.tableMouseClicked(evt);
            }
        });
        for (int col = 0; col < this.nColumns; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int maxWidth = comp.getPreferredSize().width;
            for (int row = 0; row < this.nRows; ++row) {
                comp = renderer.getTableCellRendererComponent(table, this.getValueAt(row, col), false, false, row, col);
                maxWidth = Math.max(maxWidth, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(maxWidth);
        }
        return table;
    }

    private void tableMouseClicked(MouseEvent evt) {
        List<Item> items;
        Cell cc;
        int nClick = evt.getClickCount();
        JTable table = (JTable)evt.getSource();
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int column = table.columnAtPoint(point);
        if (nClick != 1 && nClick == 2 && (cc = this.cells[row][column]).getField().equals(MonitorField.VALUE) && (items = cc.getItems()).size() == 1) {
            Item item = items.get(0);
            String[] path = new String[]{item.getChannel().getAgentName(), item.getChannel().getLocalPath()};
            TrendingService trending = (TrendingService)Console.getConsole().getConsoleLookup().lookup(TrendingService.class);
            if (trending == null) {
                return;
            }
            trending.show(path);
        }
    }

    static /* synthetic */ Color access$000() {
        return COLOR_MULTI;
    }

    static /* synthetic */ Color access$100() {
        return COLOR_NA;
    }

    static class Renderer
    extends DefaultTableCellRenderer {
        Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Data cc = (Data)value;
            super.getTableCellRendererComponent(table, cc.text, false, false, row, column);
            this.setBackground(cc.bgColor);
            this.setForeground(cc.fgColor);
            this.setHorizontalAlignment(cc.horizontalAlignment);
            return this;
        }
    }

    public static interface Item {
        public AgentChannel getChannel();

        public String getName();
    }

    protected static class Data {
        static final Data MULTI = new Data("-", COLOR_FG, MonitorTable.access$000(), 0);
        static final Data NA = new Data("", COLOR_FG, MonitorTable.access$100(), 0);
        static final Data EMPTY = new Data("", COLOR_FG, COLOR_BG, 0);
        final String text;
        final Color fgColor;
        final Color bgColor;
        final int horizontalAlignment;

        Data(String text, Color fgColor, Color bgColor, Integer horizontalAlignment) {
            this.text = text == null ? "" : text;
            this.fgColor = fgColor == null ? COLOR_FG : fgColor;
            this.bgColor = bgColor == null ? COLOR_BG : bgColor;
            this.horizontalAlignment = horizontalAlignment == null ? 0 : horizontalAlignment;
        }

        Data() {
            this(null, null, null, null);
        }

        Data(String text, int horizontalAlignment) {
            this(text, null, null, horizontalAlignment);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Data)) {
                return false;
            }
            Data other = (Data)obj;
            return Objects.equals(this.text, other.text) && Objects.equals(this.fgColor, other.fgColor) && Objects.equals(this.bgColor, other.bgColor) && Objects.equals(this.horizontalAlignment, other.horizontalAlignment);
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = result * 31 + (this.text == null ? 0 : this.text.hashCode());
            result = result * 31 + (this.fgColor == null ? 0 : this.fgColor.hashCode());
            result = result * 31 + (this.bgColor == null ? 0 : this.bgColor.hashCode());
            result = result * 31 + this.horizontalAlignment;
            return result;
        }

        public String toString() {
            return this.text;
        }
    }

    protected static class Cell {
        protected static Cell EMPTY = new Cell(Collections.emptyList(), MonitorField.NULL, Data.EMPTY);
        private final List<Item> items;
        private final MonitorField field;
        private Data data;

        Cell() {
            this(Collections.emptyList(), MonitorField.NULL);
        }

        Cell(Item item, MonitorField field) {
            this(Collections.singletonList(item), field);
        }

        Cell(List<? extends Item> items, MonitorField field) {
            this(items, field, null);
        }

        Cell(List<? extends Item> items, MonitorField field, Data data) {
            this.items = items;
            this.field = field;
            this.data = data;
        }

        public List<Item> getItems() {
            return this.items;
        }

        public MonitorField getField() {
            return this.field;
        }

        public void setData(Data data) {
            this.data = data;
        }

        public Data getData() {
            return this.data;
        }
    }
}

