/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPageDialog;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.subsystem.monitor.ui.tree.Channel;
import org.lsst.ccs.subsystem.monitor.ui.tree.Field;
import org.lsst.ccs.subsystem.monitor.ui.tree.MonitorDisplay;
import org.lsst.ccs.subsystem.monitor.ui.tree.MonitorExport;

@Plugin(name="LSST Monitoring Plugin", id="monitor", description="LSST CCS monitoring data display service.")
public class LsstMonitorPlugin
extends ConsolePlugin {
    public static final String DISPLAY_AS_TREE = "displayAsTree";
    public static final String DISPLAY_DOT_SEPARATOR = "displayDotSeparator";
    private final Studio app = (Studio)Application.getApplication();
    private final Action newView;
    private final ArrayList<MonitorView> currentViews = new ArrayList(0);
    private final ArrayDeque<MonitorPageDialog.Descriptor> recentViews = new ArrayDeque(0);

    public LsstMonitorPlugin() {
        this.newView = new AbstractAction("Configure..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstMonitorPlugin.this.openNewView(null);
            }
        };
    }

    @Override
    public void initialize() {
        this.getServices().addProperty(DISPLAY_AS_TREE, false);
        this.getServices().addPreference(new String[]{"LSST", "Monitor"}, "Data Display", "${displayAsTree}Display tables as trees.");
        SwingUtilities.invokeLater(this::resetMenu);
        PageManager pm = this.app.getPageManager();
        pm.addPageListener((PageListener)new Saver());
    }

    @Override
    public void shutdown() {
    }

    public void openPage(MonitorView view) {
        PanelManager pm = this.getConsole().getPanelManager();
        JComponent panel = view.getPanel();
        pm.open((Component)panel, view.getName());
        pm.addListener(e -> {
            if (e.hasKey(Panel.OPEN) && !((Boolean)e.getNewValue()).booleanValue()) {
                view.uninstall(this.getConsole().getStatusAggregator());
            }
        }, panel);
        view.install(this.getConsole().getStatusAggregator());
    }

    public void closePage(MonitorView view) {
        PanelManager pm = this.getConsole().getPanelManager();
        JComponent panel = view.getPanel();
        if (panel != null) {
            pm.close(panel);
        }
        view.uninstall(this.getConsole().getStatusAggregator());
    }

    public void addView(MonitorView view) {
        view.install(this.getConsole().getStatusAggregator());
    }

    public void removeView(MonitorView view) {
        view.uninstall(this.getConsole().getStatusAggregator());
    }

    private void openNewView(MonitorPageDialog.Descriptor desc) {
        JComponent panel;
        MonitorView view;
        if (desc == null) {
            MonitorPageDialog d = MonitorPageDialog.show(this.getConsole().getWindow());
            view = d.getView();
            desc = d.getDescriptor();
        } else {
            view = MonitorPageDialog.getView(desc);
        }
        if (view != null && (panel = view.getPanel()) != null) {
            panel.putClientProperty(MonitorPageDialog.Descriptor.class.getName(), desc);
            TreeMap<Panel, Object> par = new TreeMap<Panel, Object>();
            par.put(Panel.TITLE, view.getName());
            Consumer<JComponent> onClose = c -> this.onClose((Component)c);
            par.put(Panel.ON_CLOSE, onClose);
            Console.getConsole().getPanelManager().open((Component)panel, par);
            view.install(this.getConsole().getStatusAggregator());
            this.currentViews.add(view);
        }
    }

    private void onClose(Component component) {
        if (!(component instanceof JComponent)) {
            return;
        }
        JComponent panel = (JComponent)component;
        MonitorView view = null;
        Iterator<MonitorView> it = this.currentViews.iterator();
        while (it.hasNext()) {
            MonitorView v = it.next();
            if (panel != v.getPanel()) continue;
            view = v;
            it.remove();
            break;
        }
        if (view == null) {
            return;
        }
        view.uninstall(this.getConsole().getStatusAggregator());
        Object o = panel.getClientProperty(MonitorPageDialog.Descriptor.class.getName());
        if (o instanceof MonitorPageDialog.Descriptor) {
            MonitorPageDialog.Descriptor desc = (MonitorPageDialog.Descriptor)o;
            Iterator<MonitorPageDialog.Descriptor> itt = this.recentViews.iterator();
            while (itt.hasNext()) {
                if (!itt.next().getName().equals(desc.getName())) continue;
                itt.remove();
                break;
            }
            if (this.recentViews.size() > 9) {
                this.recentViews.pollLast();
            }
            this.recentViews.addFirst(desc);
            this.resetMenu();
        }
    }

    private void resetMenu() {
        Console console = this.getConsole();
        console.removeMenu(" CCS Tools ", "Monitoring...");
        this.getServices().addMenu(this.newView, "400: CCS Tools :-1:15", "Monitoring...:1");
        int i = 0;
        for (final MonitorPageDialog.Descriptor desc : this.recentViews) {
            AbstractAction act = new AbstractAction(desc.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LsstMonitorPlugin.this.openNewView(desc);
                }
            };
            this.getServices().addMenu(act, "400: CCS Tools :-1:15", "Monitoring...:1:" + i++);
        }
    }

    @Override
    public ComponentDescriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        ArrayList<MonitorPageDialog.Descriptor> current = new ArrayList<MonitorPageDialog.Descriptor>(this.currentViews.size());
        for (MonitorView view : this.currentViews) {
            Object o;
            JComponent panel = view.getPanel();
            if (panel == null || !((o = panel.getClientProperty(MonitorPageDialog.Descriptor.class.getName())) instanceof MonitorPageDialog.Descriptor)) continue;
            current.add((MonitorPageDialog.Descriptor)o);
        }
        if (!current.isEmpty()) {
            desc.setCurrentViews(current.toArray(new MonitorPageDialog.Descriptor[current.size()]));
        }
        if (!this.recentViews.isEmpty()) {
            desc.setRecentViews(this.recentViews.toArray(new MonitorPageDialog.Descriptor[this.recentViews.size()]));
        }
        return desc;
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        for (MonitorView view : new ArrayList<MonitorView>(this.currentViews)) {
            this.closePage(view);
        }
        this.currentViews.clear();
        this.recentViews.clear();
        if (storageBean instanceof Descriptor) {
            Descriptor desc = (Descriptor)storageBean;
            if (desc.getCurrentViews() != null) {
                for (MonitorPageDialog.Descriptor d : desc.getCurrentViews()) {
                    this.openNewView(d);
                }
            }
            if (desc.getRecentViews() != null) {
                this.recentViews.addAll(Arrays.asList(desc.getRecentViews()));
            }
        }
        this.resetMenu();
        return true;
    }

    public static void saveData(OutputStream out, String mimeType, List<AgentChannel> channels, List<MonitorField> fields) {
        PrintStream ps = new PrintStream(out);
        int n = Field.values().length;
        StringBuilder sb = new StringBuilder();
        for (MonitorField field : fields) {
            sb.append(field.getTitle()).append(",");
        }
        ps.println(sb.substring(0, sb.length() - 1));
        for (AgentChannel channel : channels) {
            sb = new StringBuilder();
            for (MonitorField field : fields) {
                sb.append(channel.get(field.name())).append(",");
            }
            ps.println(sb.substring(0, sb.length() - 1));
        }
    }

    public static void saveData(OutputStream out, String mimeType, List<Channel> channels) {
        PrintStream ps = new PrintStream(out);
        int n = Field.values().length;
        StringBuilder sb = new StringBuilder();
        for (Field field : Field.values()) {
            sb.append((Object)field).append(",");
        }
        ps.println(sb.substring(0, sb.length() - 1));
        for (Channel channel : channels) {
            sb = new StringBuilder();
            for (Field field : Field.values()) {
                sb.append(channel.get(field)).append(",");
            }
            ps.println(sb.substring(0, sb.length() - 1));
        }
    }

    private class Saver
    extends CommandProcessor
    implements PageListener {
        private boolean on;

        private Saver() {
        }

        public void pageChanged(PageEvent pe) {
            PageContext context = pe.getPageContext();
            if (context == null) {
                return;
            }
            JComponent panel = (JComponent)context.getPage();
            if (panel == null) {
                return;
            }
            switch (pe.getID()) {
                case 3999: {
                    MonitorDisplay md = this.findMonitorDisplay(panel, false);
                    if (md == null) {
                        if (!this.on) break;
                        LsstMonitorPlugin.this.app.getCommandTargetManager().remove((CommandGroup)this);
                        this.on = false;
                        break;
                    }
                    if (this.on) break;
                    LsstMonitorPlugin.this.app.getCommandTargetManager().add((CommandGroup)this);
                    this.on = true;
                    break;
                }
            }
        }

        private MonitorDisplay findMonitorDisplay(JComponent component, boolean visibleOnly) {
            Component[] cc;
            if (visibleOnly && !component.isShowing()) {
                return null;
            }
            if (component instanceof MonitorDisplay) {
                return (MonitorDisplay)((Object)component);
            }
            for (Component c : cc = component.getComponents()) {
                MonitorDisplay md;
                if (!(c instanceof JComponent) || (md = this.findMonitorDisplay((JComponent)c, visibleOnly)) == null) continue;
                return md;
            }
            return null;
        }

        public void onSaveAs() {
            try {
                PageManager pm = LsstMonitorPlugin.this.app.getPageManager();
                PageContext context = pm.getSelectedPage();
                JComponent component = (JComponent)context.getPage();
                MonitorDisplay md = this.findMonitorDisplay(component, true);
                Properties user = LsstMonitorPlugin.this.app.getUserProperties();
                String creator = "creator";
                ExportDialog dlg = new ExportDialog(creator, false);
                dlg.addExportFileType((ExportFileType)new MonitorExport());
                dlg.addExportFileType((ExportFileType)new MonitorExport());
                dlg.setUserProperties(user);
                dlg.showExportDialog((Component)LsstMonitorPlugin.this.app, "Save As...", (Component)((Object)md), "monitor");
            }
            catch (ClassCastException | NullPointerException x) {
                LsstMonitorPlugin.this.app.error("No selected monitoring table", (Throwable)x);
            }
        }
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private MonitorPageDialog.Descriptor[] currentViews;
        private MonitorPageDialog.Descriptor[] recentViews;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public MonitorPageDialog.Descriptor[] getCurrentViews() {
            return this.currentViews;
        }

        public void setCurrentViews(MonitorPageDialog.Descriptor[] currentViews) {
            this.currentViews = currentViews;
        }

        public MonitorPageDialog.Descriptor getCurrentViews(int index) {
            return this.currentViews[index];
        }

        public void setCurrentViews(int index, MonitorPageDialog.Descriptor currentViews) {
            this.currentViews[index] = currentViews;
        }

        public MonitorPageDialog.Descriptor[] getRecentViews() {
            return this.recentViews;
        }

        public void setRecentViews(MonitorPageDialog.Descriptor[] recentViews) {
            this.recentViews = recentViews;
        }

        public MonitorPageDialog.Descriptor getRecentViews(int index) {
            return this.recentViews[index];
        }

        public void setRecentViews(int index, MonitorPageDialog.Descriptor recentViews) {
            this.recentViews[index] = recentViews;
        }
    }
}

