/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSParametersPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class EPOSControllerPanel
extends JPanel {
    private static final long serialVersionUID = 2482213337630248322L;
    private InterfaceGeneralGUI subs;
    private final String controllerName;
    private final CanOpenDevicePanel generalInfoPanel;
    private JPanel faultPanel;
    private final DigitalSwitch faultSwitch = new DigitalSwitch();
    private final JLabel errorRegisterLabel = new JLabel("99=XXXXXXXX error");
    private final JLabel errorHistoryNameLabel = new JLabel("Error History:");
    private final JLabel errorHistoryLabel = new JLabel();
    private JPanel modePanel;
    private final JLabel modeLabel = new JLabel("UNKNOWN");
    private JPanel controlPanel;
    private final JButton checkFaultButton = new JButton("CheckFault");
    private final JButton faultResetButton = new JButton("FaultReset");
    private final JButton refreshButton = new JButton("Refresh");
    private final EPOSParametersPanel currentParamsPanel = new EPOSParametersPanel();
    private final EPOSParametersPanel profile_positionParamsPanel = new EPOSParametersPanel();
    private final EPOSParametersPanel homingParamsPanel = new EPOSParametersPanel();

    public EPOSControllerPanel(String controllerName) {
        this.controllerName = controllerName;
        this.generalInfoPanel = new CanOpenDevicePanel(controllerName);
        this.initComponents();
    }

    public void setSubsystem(InterfaceGeneralGUI newSubs) {
        this.subs = newSubs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateController(status));
    }

    public void updateDevice(StatusDataPublishedByHardware s) {
        SwingUtilities.invokeLater(new UpdateDevice(s));
    }

    private void initComponents() {
        this.checkFaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EPOSControllerPanel.this.checkFaultActionPerformed(evt);
            }
        });
        this.faultResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EPOSControllerPanel.this.faultResetActionPerformed(evt);
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EPOSControllerPanel.this.refreshActionPerformed(evt);
            }
        });
        this.modePanel = new JPanel();
        this.modePanel.setBorder(BorderFactory.createTitledBorder("EPOS mode"));
        this.modePanel.setPreferredSize(new Dimension(160, 50));
        this.modePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        this.modeLabel.setFont(Tools.BIG_FONT);
        this.modePanel.add((Component)this.modeLabel, gbc2);
        this.faultPanel = new JPanel();
        this.faultPanel.setBorder(BorderFactory.createTitledBorder("Error"));
        this.faultPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 10;
        this.faultPanel.add((Component)this.faultSwitch, gbc1);
        ++gbc1.gridy;
        this.errorRegisterLabel.setFont(Tools.BIG_FONT);
        this.faultPanel.add((Component)this.errorRegisterLabel, gbc1);
        ++gbc1.gridy;
        this.faultPanel.add((Component)this.errorHistoryNameLabel, gbc1);
        ++gbc1.gridy;
        this.faultPanel.add((Component)this.errorHistoryLabel, gbc1);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        this.controlPanel.add((Component)this.refreshButton, gbc4);
        ++gbc4.gridy;
        this.controlPanel.add((Component)this.checkFaultButton, gbc4);
        ++gbc4.gridx;
        this.controlPanel.add((Component)this.faultResetButton, gbc4);
        this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.faultPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.modePanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        this.add((Component)this.currentParamsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.profile_positionParamsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.homingParamsPanel, gbc);
    }

    public void resetPanel() {
        this.faultSwitch.setColor(Color.GRAY);
        this.errorRegisterLabel.setText("Unknown ERROR");
        this.errorHistoryLabel.setText("Unknown ERROR");
        this.currentParamsPanel.resetPanel();
        this.homingParamsPanel.resetPanel();
        this.profile_positionParamsPanel.resetPanel();
    }

    private void checkFaultActionPerformed(ActionEvent evt) {
        this.subs.sendCommandSwingWorker("checkFault", 1000L, this.controllerName);
    }

    private void faultResetActionPerformed(ActionEvent evt) {
        this.subs.sendCommandSwingWorker("faultReset", 1000L, this.controllerName);
    }

    private void refreshActionPerformed(ActionEvent evt) {
        this.subs.sendCommandSwingWorker("publishData", 1000L, this.controllerName);
    }

    @Override
    public String toString() {
        if (this.controllerName == null) {
            return "Unamed Controller Panel";
        }
        return this.controllerName;
    }

    public static void main(String[] argv) {
        EPOSControllerPanel p = new EPOSControllerPanel("myController");
        JFrame frame = new JFrame("EPOS Controller");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateDevice
    implements Runnable {
        private final StatusDataPublishedByHardware status;

        public UpdateDevice(StatusDataPublishedByHardware s) {
            this.status = s;
        }

        @Override
        public void run() {
            if (this.status.getName().equals(EPOSControllerPanel.this.controllerName)) {
                EPOSControllerPanel.this.generalInfoPanel.updateCanOpenDevice(this.status);
            }
        }
    }

    private class UpdateController
    implements Runnable {
        private StatusDataPublishedByEPOSController s;

        public UpdateController(StatusDataPublishedByEPOSController status) {
            this.s = status;
        }

        @Override
        public void run() {
            FCSCst.FCSLOG.debug((Object)("UpdateController:" + this.s.getName()));
            EPOSControllerPanel.this.generalInfoPanel.updateCanOpenDevice((StatusDataPublishedByHardware)this.s);
            EPOSControllerPanel.this.modeLabel.setText(this.s.getMode().toString());
            EPOSControllerPanel.this.modeLabel.setFont(Tools.BIG_FONT);
            if (this.s.isInitialized()) {
                EPOSControllerPanel.this.faultSwitch.setColor(this.s.isInError() ? Color.RED : Tools.greenColor);
                EPOSControllerPanel.this.errorRegisterLabel.setText(this.s.getErrorRegister());
                String[] historyList = this.s.getErrorHistory();
                if (historyList == null || historyList.length == 0) {
                    EPOSControllerPanel.this.errorHistoryLabel.setText("no error");
                } else {
                    StringBuilder sb = new StringBuilder("<html>");
                    for (int i = 0; i < this.s.getErrorHistory().length; ++i) {
                        if (i > 0) {
                            sb.append("<br>");
                        }
                        sb.append(historyList[i]);
                    }
                    sb.append("</html>");
                    EPOSControllerPanel.this.errorHistoryLabel.setText(sb.toString());
                }
            } else {
                EPOSControllerPanel.this.faultSwitch.setColor(Color.ORANGE);
                EPOSControllerPanel.this.errorRegisterLabel.setText("Not initialized");
            }
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            EPOSControllerPanel.this.generalInfoPanel.initializeGui(this.configInfo);
            EPOSControllerPanel.this.faultSwitch.setColor(Color.GRAY);
            EPOSControllerPanel.this.errorRegisterLabel.setText("Unknown ERROR");
            Map configForName = this.configInfo.getCurrentValuesFor(EPOSControllerPanel.this.controllerName);
            Map currentParamsMap = (Map)InputConversionEngine.convertArgToType((String)((String)configForName.get("paramsForCurrent")), Map.class);
            EPOSControllerPanel.this.currentParamsPanel.initializeGUI(EPOSEnumerations.EposMode.CURRENT.toString(), currentParamsMap);
            Map profileParamsMap = (Map)InputConversionEngine.convertArgToType((String)((String)configForName.get("paramsForProfilePosition")), Map.class);
            EPOSControllerPanel.this.profile_positionParamsPanel.initializeGUI(EPOSEnumerations.EposMode.PROFILE_POSITION.toString(), profileParamsMap);
            Map homingParamsMap = (Map)InputConversionEngine.convertArgToType((String)((String)configForName.get("paramsForHoming")), Map.class);
            EPOSControllerPanel.this.homingParamsPanel.initializeGUI(EPOSEnumerations.EposMode.HOMING.toString(), homingParamsMap);
        }
    }
}

