/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench.ui;

import java.util.List;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.testbench.ui.LPCAxisXPanel;
import org.lsst.ccs.subsystems.fcs.testbench.ui.LPCAxisZPanel;
import org.lsst.ccs.subsystems.fcs.testbench.ui.TestbenchLPCGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;

public class TestbenchLPCGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = 1240493208100142856L;
    protected TestbenchLPCGUI subs;
    protected EPOSControllerPanel axisXControllerPanel;
    protected EPOSControllerPanel axisZControllerPanel;
    protected LPCAxisXPanel lpcAxisXPanel;
    protected LPCAxisZPanel lpcAxisZPanel;

    public TestbenchLPCGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
    }

    public TestbenchLPCGatherPanel(TestbenchLPCGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.subs = subs;
        this.initPanels();
    }

    public EPOSControllerPanel getAxisXControllerPanel() {
        return this.axisXControllerPanel;
    }

    public EPOSControllerPanel getAxisZControllerPanel() {
        return this.axisZControllerPanel;
    }

    public LPCAxisXPanel getLpcAxisXPanel() {
        return this.lpcAxisXPanel;
    }

    public LPCAxisZPanel getLpcAxisZPanel() {
        return this.lpcAxisZPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initPanels() {
        this.axisXControllerPanel = new EPOSControllerPanel("Axis X Controller");
        this.axisZControllerPanel = new EPOSControllerPanel("Axis Y Controller");
        this.lpcAxisXPanel = new LPCAxisXPanel();
        this.lpcAxisZPanel = new LPCAxisZPanel();
    }

    void updateAxisXControllerPanel(StatusDataPublishedByEPOSController s) {
        this.axisXControllerPanel.updateController(s);
    }

    void updateAxisZControllerPanel(StatusDataPublishedByEPOSController s) {
        this.axisZControllerPanel.updateController(s);
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        KeyValueData data = (KeyValueData)d.getObject();
        FCSLOG.debug((Object)(this.getName() + " read data dataType:" + data.getKey()));
        switch (data.getKey()) {
            case "tcpProxy": {
                this.updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
                break;
            }
            case "axisXController": {
                this.updateAxisXControllerPanel((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "axisZController": {
                this.updateAxisZControllerPanel((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            default: {
                FCSLOG.warning((Object)(this.getName() + " An unexpected dataType was read on the status bus:" + data.getKey()));
            }
        }
    }
}

