/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerLatchPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerOnlineClampPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTwoTrucksPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwareListPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;

public class TestbenchCPPMGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = -4965366600304567533L;
    protected InterfaceGeneralGUI subs;
    private final SubsystemPanel subsystemPanel = new SubsystemPanel("TestbenchCPPM Subsystem State");
    protected EPOSControllerPanel linearRailMasterControllerPanel;
    protected EPOSControllerPanel linearRailSlaveControllerPanel;
    protected EPOSControllerPanel latchXminusControllerPanel;
    protected EPOSControllerPanel onlineClampXminusControllerPanel;
    protected PlutoGatewayPanel plutoGatewayPanel;
    AutochangerOnlineClampPanel onlineClampPanel;
    AutochangerTwoTrucksPanel acTrucksPanel;
    AutochangerLatchPanel latchPanel;

    public TestbenchCPPMGatherPanel() {
        super("tcpProxy");
        this.initPanels();
    }

    public TestbenchCPPMGatherPanel(InterfaceGeneralGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.subs = subs;
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.onlineClampXminusControllerPanel.setSubsystem(subs);
    }

    public AutochangerTwoTrucksPanel getAcTrucksPanel() {
        return this.acTrucksPanel;
    }

    public AutochangerOnlineClampPanel getOnlineClampPanel() {
        return this.onlineClampPanel;
    }

    public AutochangerLatchPanel getLatchPanel() {
        return this.latchPanel;
    }

    public EPOSControllerPanel getLinearRailMasterControllerPanel() {
        return this.linearRailMasterControllerPanel;
    }

    public EPOSControllerPanel getLinearRailSlaveControllerPanel() {
        return this.linearRailSlaveControllerPanel;
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return this.latchXminusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return this.onlineClampXminusControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.plutoGatewayPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) throws InterruptedException, InvocationTargetException {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        KeyValueData data = (KeyValueData)d.getObject();
        switch (data.getKey()) {
            case "tcpProxy": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:tcpProxy"));
                this.updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
                break;
            }
            case "linearRailMasterController": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:linearRailMasterController"));
                this.updateLinearRailMasterController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "linearRailSlaveController": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:linearRailSlaveController"));
                this.updateLinearRailSlaveController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "latchController": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:latchXminusController"));
                this.updateLatchXminusController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "onlineClampController": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:onlineClampController"));
                this.updateOnlineClampXminusController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "autochangerTrucks": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:trucks"));
                FCSLOG.finest((Object)(this.getName() + " Data published by Trucks= " + ((StatusDataPublishedByAutoChangerTrucks)data.getValue()).toString()));
                this.updateTrucks((StatusDataPublishedByAutoChangerTrucks)data.getValue());
                break;
            }
            case "latchXminus": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:latchXminus"));
                FCSLOG.finest((Object)(this.getName() + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch)data.getValue()).toString()));
                this.updateLatch((StatusDataPublishedByAutochangerLatch)data.getValue());
                break;
            }
            case "onlineClampXminus": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:onlineClampXminus"));
                FCSLOG.debug((Object)(this.getName() + " Data published by ClampXminus= " + ((StatusDataPublishedByAutochangerOnlineClamp)data.getValue()).toString()));
                this.updateClampXminus((StatusDataPublishedByAutochangerOnlineClamp)data.getValue());
                break;
            }
            default: {
                FCSLOG.warning((Object)(this.getName() + " An unexpected dataType was read on the status bus:" + data.getKey()));
            }
        }
    }

    void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        this.linearRailMasterControllerPanel.updateController(s);
    }

    void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        this.linearRailSlaveControllerPanel.updateController(s);
    }

    void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        this.latchXminusControllerPanel.updateController(s);
    }

    void updateOnlineClampXminusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampXminusControllerPanel.updateController(s);
    }

    void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.onlineClampPanel.updateClamp(s);
    }

    void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        this.latchPanel.updateLatch(s);
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        FCSLOG.finest((Object)(" Data published by Trucks= " + s.toString()));
        this.acTrucksPanel.updateTrucks(s);
    }

    private void initPanels() {
        this.hardwarePanel = new CanOpenHardwareListPanel("tcpProxy");
        this.linearRailMasterControllerPanel = new EPOSControllerPanel("linearRailMasterController");
        this.linearRailSlaveControllerPanel = new EPOSControllerPanel("linearRailSlaveController");
        this.latchXminusControllerPanel = new EPOSControllerPanel("latchXminusController");
        this.onlineClampXminusControllerPanel = new EPOSControllerPanel("onlineClampXminusController");
        this.plutoGatewayPanel = new PlutoGatewayPanel("plutoGateway");
        this.onlineClampPanel = new AutochangerOnlineClampPanel("onlineClampXminus");
        this.latchPanel = new AutochangerLatchPanel("latchXminus");
        this.acTrucksPanel = new AutochangerTwoTrucksPanel("trucks");
    }

    private class GuiInitialization
    implements Runnable {
        ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            TestbenchCPPMGatherPanel.this.latchPanel.initializeGui(this.configInfo);
            TestbenchCPPMGatherPanel.this.linearRailMasterControllerPanel.initializeGui(this.configInfo);
            TestbenchCPPMGatherPanel.this.linearRailSlaveControllerPanel.initializeGui(this.configInfo);
            TestbenchCPPMGatherPanel.this.latchXminusControllerPanel.initializeGui(this.configInfo);
            TestbenchCPPMGatherPanel.this.onlineClampXminusControllerPanel.initializeGui(this.configInfo);
            TestbenchCPPMGatherPanel.this.plutoGatewayPanel.initializeGui(this.configInfo);
        }
    }
}

