/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 8834267363875256916L;
    private InterfaceLoaderGUI subs;
    private final JLabel onCameraLabel = new JLabel("ON CAMERA SENSOR");
    private final JLabel autochangerHoldingFilterLabel = new JLabel("AUTOCHANGER HOLDING FILTER SENSOR");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final DigitalSwitch onCameraDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch autochangerHoldingFilterDigitalSwitch = new DigitalSwitch();
    private final JPanel homingPanel = new JPanel();
    private final JLabel clhomLabel = new JLabel("Homing of the clamp controller:");
    private final JLabel cahomLabel = new JLabel("Homing of the carrier controller:");
    private final JLabel clampHomingLabel = new JLabel();
    private final JLabel carrierHomingLabel = new JLabel();
    private final JButton loadFilterButton = new JButton("loadFilterInCamera");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromCamera");

    public LoaderGeneralViewPanel() {
        this.initComponents();
    }

    public LoaderGeneralViewPanel(InterfaceLoaderGUI subs) {
        this.subs = subs;
        this.initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
    }

    public void updateLoaderGeneral(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoaderGeneral(status));
    }

    public void updateFakeAutochanger(int sensorValue) {
        SwingUtilities.invokeLater(new UpdateFakeAutochanger(sensorValue));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        this.homingPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
        this.homingPanel.setLayout(new GridBagLayout());
        this.clampHomingLabel.setFont(Tools.BIG_FONT);
        this.carrierHomingLabel.setFont(Tools.BIG_FONT);
        GridBagConstraints gbc6 = new GridBagConstraints();
        gbc6.insets = Tools.insets_big;
        gbc6.gridx = 0;
        gbc6.gridy = 0;
        this.homingPanel.add((Component)this.clhomLabel, gbc6);
        ++gbc6.gridx;
        this.homingPanel.add((Component)this.clampHomingLabel, gbc6);
        gbc6.gridx = 0;
        ++gbc6.gridy;
        this.homingPanel.add((Component)this.cahomLabel, gbc6);
        ++gbc6.gridx;
        this.homingPanel.add((Component)this.carrierHomingLabel, gbc6);
        this.loadFilterButton.addActionListener(evt -> this.loadFilterActionPerformed(evt));
        this.unloadFilterButton.addActionListener(evt -> this.unloadFilterActionPerformed(evt));
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        this.controlPanel.add((Component)this.loadFilterButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.unloadFilterButton, gbc0);
        this.fakeSensorsPanel.setBorder(BorderFactory.createTitledBorder("FAKE SENSORS"));
        this.fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        this.fakeSensorsPanel.add((Component)this.onCameraLabel, gbc1);
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.onCameraDigitalSwitch, gbc1);
        gbc1.insets = new Insets(0, 60, 0, 4);
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.autochangerHoldingFilterLabel, gbc1);
        gbc1.insets = Tools.insets_std;
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.autochangerHoldingFilterDigitalSwitch, gbc1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add(this.homingPanel);
        ++gbc.gridy;
        this.add((Component)this.controlPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.fakeSensorsPanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.onCameraDigitalSwitch.setColor(Color.gray);
        this.autochangerHoldingFilterDigitalSwitch.setColor(Color.gray);
        this.clampHomingLabel.setText("TO BE DONE");
        this.clampHomingLabel.setForeground(Color.red);
        this.carrierHomingLabel.setText("TO BE DONE");
        this.carrierHomingLabel.setForeground(Color.red);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    private void loadFilterActionPerformed(ActionEvent evt) {
        this.subs.loadFilter();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        this.subs.unloadFilter();
    }

    @Override
    public String toString() {
        return "Loader General View Panel";
    }

    public static void main(String[] args) {
        LoaderGeneralViewPanel d = new LoaderGeneralViewPanel();
        JFrame frame = new JFrame("Loader Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("DONE");
                LoaderGeneralViewPanel.this.clampHomingLabel.setForeground(Tools.greenColor);
            } else {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("NOT DONE");
                LoaderGeneralViewPanel.this.clampHomingLabel.setForeground(Color.red);
            }
        }
    }

    class UpdateLoaderGeneral
    implements Runnable {
        private final StatusDataPublishedByLoader s;

        UpdateLoaderGeneral(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isLoaderOnCameraSensorsInError()) {
                LoaderGeneralViewPanel.this.onCameraDigitalSwitch.setColor(Color.RED);
            } else {
                LoaderGeneralViewPanel.this.onCameraDigitalSwitch.setColor(this.s.getLoaderOnCameraSensorValue0() == 1 ? Tools.greenColor : Color.gray);
            }
        }
    }

    class UpdateFakeAutochanger
    implements Runnable {
        private final int holdingFilterSensorValue;

        public UpdateFakeAutochanger(int holdingFilterSensorValue) {
            this.holdingFilterSensorValue = holdingFilterSensorValue;
        }

        @Override
        public void run() {
            LoaderGeneralViewPanel.this.autochangerHoldingFilterDigitalSwitch.setColor(this.holdingFilterSensorValue == 1 ? Tools.greenColor : Color.gray);
        }
    }
}

