/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerThreeOnlineClampsPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTwoLatchesPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTwoTrucksPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;

public class AutochangerGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = -975949078768889254L;
    private static final String AC_PLUTO_GATEWAY_NAME = "acPlutoGateway";
    private static final String AC_TRUCKS_NAME = "autochangerTrucks";
    protected InterfaceAutochangerGUI subs;
    protected EPOSControllerPanel linearRailMasterControllerPanel;
    protected EPOSControllerPanel linearRailSlaveControllerPanel;
    protected EPOSControllerPanel latchXminusControllerPanel;
    protected EPOSControllerPanel latchXplusControllerPanel;
    protected EPOSControllerPanel onlineClampXminusControllerPanel;
    protected EPOSControllerPanel onlineClampXplusControllerPanel;
    protected EPOSControllerPanel onlineClampYminusControllerPanel;
    protected PlutoGatewayPanel plutoGatewayPanel;
    protected AutochangerThreeOnlineClampsPanel onlineClampsPanel;
    private AutochangerTwoTrucksPanel acTrucksPanel;
    private AutochangerTwoLatchesPanel acLatchesPanel = new AutochangerTwoLatchesPanel();
    private AutochangerThreeOnlineClampsPanel acClampsPanel = new AutochangerThreeOnlineClampsPanel();
    private final AutochangerGeneralViewPanel acGeneralViewPanel = new AutochangerGeneralViewPanel();

    public AutochangerGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.setName("AutochangerGatherPanel");
    }

    public AutochangerGatherPanel(InterfaceAutochangerGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.subs = subs;
        this.acClampsPanel.setSubsystem(subs);
        this.acLatchesPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.latchXplusControllerPanel.setSubsystem(subs);
        this.onlineClampXminusControllerPanel.setSubsystem(subs);
        this.onlineClampXplusControllerPanel.setSubsystem(subs);
        this.onlineClampYminusControllerPanel.setSubsystem(subs);
        this.setName("AutochangerGatherPanel");
    }

    public AutochangerTwoTrucksPanel getAcTrucksPanel() {
        return this.acTrucksPanel;
    }

    public AutochangerTwoLatchesPanel getAcLatchesPanel() {
        return this.acLatchesPanel;
    }

    public AutochangerThreeOnlineClampsPanel getAcClampsPanel() {
        return this.acClampsPanel;
    }

    public AutochangerGeneralViewPanel getAcGeneralViewPanel() {
        return this.acGeneralViewPanel;
    }

    public EPOSControllerPanel getLinearRailMasterControllerPanel() {
        return this.linearRailMasterControllerPanel;
    }

    public EPOSControllerPanel getLinearRailSlaveControllerPanel() {
        return this.linearRailSlaveControllerPanel;
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return this.latchXminusControllerPanel;
    }

    public EPOSControllerPanel getLatchXplusControllerPanel() {
        return this.latchXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return this.onlineClampXminusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXplusControllerPanel() {
        return this.onlineClampXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampYminusControllerPanel() {
        return this.onlineClampYminusControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.plutoGatewayPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) throws InterruptedException, InvocationTargetException {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        KeyValueData data = (KeyValueData)d.getObject();
        FCSLOG.debug((Object)(this.subs.getName() + " read data dataType:" + data.getKey()));
        if (data.getValue() instanceof StatusDataPublishedByHardware) {
            this.updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutoChanger) {
            this.updateAutochanger((StatusDataPublishedByAutoChanger)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByEPOSController) {
            this.updateController(data.getKey(), (StatusDataPublishedByEPOSController)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerTruck) {
            this.updateTruck(data.getKey(), (StatusDataPublishedByAutochangerTruck)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutoChangerTrucks) {
            this.updateTrucks((StatusDataPublishedByAutoChangerTrucks)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerLatch) {
            this.updateLatch((StatusDataPublishedByAutochangerLatch)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerTwoLatches) {
            this.updateLatches((StatusDataPublishedByAutochangerTwoLatches)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerOnlineClamp) {
            this.updateOnlineClamp(data.getKey(), (StatusDataPublishedByAutochangerOnlineClamp)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerThreeClamps) {
            this.updateClamps((StatusDataPublishedByAutochangerThreeClamps)data.getValue());
        }
    }

    private void updateController(String controllerName, StatusDataPublishedByEPOSController controllerStatus) {
        switch (controllerName) {
            case "linearRailMasterController": {
                this.updateLinearRailMasterController(controllerStatus);
                break;
            }
            case "linearRailSlaveController": {
                this.updateLinearRailSlaveController(controllerStatus);
                break;
            }
            case "latchXminusController": {
                this.updateLatchXminusController(controllerStatus);
                break;
            }
            case "latchXplusController": {
                this.updateLatchXplusController(controllerStatus);
                break;
            }
            case "onlineClampXminusController": {
                this.updateOnlineClampXminusController(controllerStatus);
                break;
            }
            case "onlineClampXplusController": {
                this.updateOnlineClampXplusController(controllerStatus);
                break;
            }
            case "onlineClampYminusController": {
                this.updateOnlineClampYminusController(controllerStatus);
                break;
            }
            default: {
                FCSLOG.warning((Object)(this.getName() + " An unexpected onlineClamp name was read on the status bus:" + controllerName));
            }
        }
    }

    private void updateOnlineClamp(String clampName, StatusDataPublishedByAutochangerOnlineClamp status) {
        switch (clampName) {
            case "onlineClampXminus": {
                this.updateClampXminus(status);
                break;
            }
            case "onlineClampXplus": {
                this.updateClampXplus(status);
                break;
            }
            case "onlineClampYminus": {
                this.updateClampYminus(status);
                break;
            }
            default: {
                FCSLOG.warning((Object)(this.getName() + " An unexpected onlineClamp name was read on the status bus:" + clampName));
            }
        }
    }

    public void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        this.linearRailMasterControllerPanel.updateController(s);
    }

    public void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        this.linearRailSlaveControllerPanel.updateController(s);
    }

    public void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        this.latchXminusControllerPanel.updateController(s);
    }

    public void updateLatchXplusController(StatusDataPublishedByEPOSController s) {
        this.latchXplusControllerPanel.updateController(s);
    }

    public void updateOnlineClampXminusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampXminusControllerPanel.updateController(s);
    }

    public void updateOnlineClampXplusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampXplusControllerPanel.updateController(s);
    }

    public void updateOnlineClampYminusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampYminusControllerPanel.updateController(s);
    }

    protected void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXminus(s);
    }

    protected void updateClampXplus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXplus(s);
    }

    protected void updateClampYminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampYminus(s);
    }

    protected void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        this.acClampsPanel.updateClamps(s);
        this.acGeneralViewPanel.updateClamps(s);
    }

    protected void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        this.acGeneralViewPanel.updateAutochanger(s);
    }

    protected void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        this.acLatchesPanel.updateLatch(s);
    }

    protected void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        this.acLatchesPanel.updateLatches(s);
        this.acGeneralViewPanel.updateLatches(s);
    }

    protected void updateTruck(String truckName, StatusDataPublishedByAutochangerTruck s) {
        this.acTrucksPanel.updateTruck(truckName, s);
    }

    protected void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        this.acTrucksPanel.updateTrucks(s);
        this.acGeneralViewPanel.updateTrucks(s);
    }

    private void initPanels() {
        this.linearRailMasterControllerPanel = new EPOSControllerPanel("linearRailMasterController");
        this.linearRailSlaveControllerPanel = new EPOSControllerPanel("linearRailSlaveController");
        this.latchXminusControllerPanel = new EPOSControllerPanel("latchXminusController");
        this.latchXplusControllerPanel = new EPOSControllerPanel("latchXplusController");
        this.onlineClampXminusControllerPanel = new EPOSControllerPanel("onlineClampXminusController");
        this.onlineClampXplusControllerPanel = new EPOSControllerPanel("onlineClampXplusController");
        this.onlineClampYminusControllerPanel = new EPOSControllerPanel("onlineClampYminusController");
        this.plutoGatewayPanel = new PlutoGatewayPanel(AC_PLUTO_GATEWAY_NAME);
        this.acClampsPanel = new AutochangerThreeOnlineClampsPanel();
        this.acLatchesPanel = new AutochangerTwoLatchesPanel();
        this.acTrucksPanel = new AutochangerTwoTrucksPanel(AC_TRUCKS_NAME);
    }

    @Override
    public void resetPanel() {
        super.resetPanel();
        this.linearRailMasterControllerPanel.resetPanel();
        this.linearRailSlaveControllerPanel.resetPanel();
        this.latchXminusControllerPanel.resetPanel();
        this.latchXplusControllerPanel.resetPanel();
        this.onlineClampXminusControllerPanel.resetPanel();
        this.onlineClampXplusControllerPanel.resetPanel();
        this.onlineClampYminusControllerPanel.resetPanel();
        this.acGeneralViewPanel.resetPanel();
        this.acLatchesPanel.resetPanel();
        this.acTrucksPanel.resetPanel();
        this.acClampsPanel.resetPanel();
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            AutochangerGatherPanel.this.acGeneralViewPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acClampsPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acLatchesPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acTrucksPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.linearRailMasterControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.linearRailSlaveControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.latchXminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.latchXplusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineClampXminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineClampXplusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineClampYminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.plutoGatewayPanel.initializeGui(this.configInfo);
        }
    }
}

