/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.GridBagConstraints;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A Panel to display data from a PLutoGateway.
 * Empty now. To be completed.
 * @author virieux
 */
public class PlutoGatewayPanel extends JPanel {
    private static final long serialVersionUID = -7222037685600465352L;

    /**
     * Variables declaration *
     */
    private final String gatewayName;
    
    //general informations panel
    private final CanOpenDevicePanel  generalInfoPanel;
    

    /**
     * A Runnable to update this panel from data published on the STATUS bus
     * by the plutoGateway.
     */
    class UpdatePlutoGateway implements Runnable {

        private StatusDataPublishedByPlutoGateway s;

        public UpdatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
            this.s = status;
        }

        @Override
        public void run() {
            //General Informations Panel
            generalInfoPanel.updateCanOpenDevice(s);
        }
    }

    /**
     * Creates new form PlutoGatewayPanel with a name and a general informations panel.
     * @param gatewayName
     */
    public PlutoGatewayPanel(String gatewayName) {
        this.gatewayName = gatewayName;
        this.generalInfoPanel = new CanOpenDevicePanel(gatewayName);
        initComponents();
    }

    
    /**
     * Initialize the PLutoGatewayPanel from configuration info.
     * @param configInfo 
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        generalInfoPanel.initializeGui(configInfo);
    }

    public void updatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
        SwingUtilities.invokeLater(new UpdatePlutoGateway(status));
    }
    
    public void updateDevice(StatusDataPublishedByHardware status) {
        generalInfoPanel.updateCanOpenDevice(status);
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {


        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createLineBorder(Color.GREEN));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.NORTHWEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(generalInfoPanel, gbc);

        /**
         ******************************************************************************
         ** end of Whole Panel
         * *****************************************************************************
         */
    }

    @Override
    public String toString() {
        if (gatewayName == null) {
            return "plutoGateway";
        } else {
            return gatewayName;
        }
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Pluto Gateway Panel");
        PlutoGatewayPanel p = new PlutoGatewayPanel("my_plutoGateway");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
