/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench.ui;

import org.lsst.ccs.subsystems.fcs.autochanger.ui.*;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;


/**
 *
 * @author virieux
 */
public class TestbenchCPPMGUI extends AutochangerGUI {
    private static final long serialVersionUID = 5863389553168303099L;

    String stateCorrelId;

    private static final String trucksModuleName = "autochangerTrucks";
    private static final String clampsName = "onlineClamps";
    private static final String latchesName = "latches";

    long updateTrucksPositionTimeout;
    long timeoutForTrucksMotion;

    long timeoutForClosingClamps;
    long timeoutForOpeningClamps;

    long timeoutForClosingLatches;
    long timeoutForOpeningLatches;

    public TestbenchCPPMGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        TestbenchCPPMGatherPanel autochangerGatherPanel;
//        autochangerGatherPanel = new TestbenchCPPMGatherPanel(this, CHANGER_TCPPROXY_NAME);
//        TestbenchCPPMBottomPanel autochangerBottomPanel = new TestbenchCPPMBottomPanel(autochangerGatherPanel, "AUTOCHANGER");
//        this.generalPanel = new GeneralPanel(this, autochangerBottomPanel);
        pane = new JScrollPane(generalPanel);

        //TODO to be initialized from the configuration system
        this.updateTrucksPositionTimeout = 1000;
        this.timeoutForTrucksMotion = 60000;
        this.timeoutForClosingClamps = 10000;
        this.timeoutForOpeningClamps = 10000;
        this.timeoutForClosingLatches = 10000;
        this.timeoutForOpeningLatches = 10000;
    }
    
    /**
     ******************************************************************************
     ** Trucks Actions
     * *****************************************************************************
     */
    @Override
    public void updateTrucksPosition() {
        System.out.println("Autochanger updating Trucks position");
        FCSLOG.info("Autochanger updating Trucks position");
        FCSLOG.info("/timeout=" + updateTrucksPositionTimeout);
        new CommandSwingWorker("updatePosition", this.updateTrucksPositionTimeout, trucksModuleName).execute();
    }

    @Override
    public void goToHandOff() {
        System.out.println("Autochanger Trucks going to Handoff position");
        FCSLOG.info("Autochanger Trucks going to Handoff Position");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToHandOff", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void goToStandby() {
        System.out.println("Autochanger Trucks going to Standby position");
        FCSLOG.info("Autochanger Trucks going to Standby Position");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToStandby", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void goToOnline() {
        System.out.println("Autochanger Trucks going to Online position");
        FCSLOG.info("Autochanger Trucks going to Online Position");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToOnline", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    /**
     ******************************************************************************
     ** end of Trucks Actions
     * *****************************************************************************
     */
    /**
     ******************************************************************************
     ** Clamps Actions
     * *****************************************************************************
     */
    @Override
    public void unlockOnlineClamps() {
        System.out.println("Autochanger unlocking online clamps");
        FCSLOG.info("Autochanger unlocking online clamps");
        FCSLOG.info("/timeout=" + timeoutForOpeningClamps);
        new CommandSwingWorker("unlockClamps", this.timeoutForOpeningClamps, clampsName).execute();
    }

    @Override
    public void lockOnlineClamps() {
        System.out.println("Autochanger locking online clamps");
        FCSLOG.info("Autochanger locking online clamps");
        FCSLOG.info("/timeout=" + timeoutForClosingClamps);
        new CommandSwingWorker("lockClamps", this.timeoutForClosingClamps, clampsName).execute();
    }

    /**
     ******************************************************************************
     ** end of Clamps Actions
     * *****************************************************************************
     */
    /**
     ******************************************************************************
     ** Latches Actions
     * *****************************************************************************
     * @param latchName
     */
    public void closeLatch(String latchName) {
        System.out.println("Autochanger locking latch: " + latchName);
        FCSLOG.info("Autochanger locking latch: " + latchName);
        FCSLOG.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("close", this.timeoutForClosingLatches, latchName).execute();
    }

    public void openLatch(String latchName) {
        System.out.println("Autochanger unlocking latch: " + latchName);
        FCSLOG.info("Autochanger unlocking latch: " + latchName);
        FCSLOG.info("/timeout=" + timeoutForOpeningLatches);
        new CommandSwingWorker("open", this.timeoutForOpeningLatches, latchName).execute();
    }

    public void closeLatches() {
        System.out.println("Autochanger locking latches.");
        FCSLOG.info("Autochanger locking latches.");
        FCSLOG.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("open", this.timeoutForClosingLatches, latchesName).execute();
    }

    public void openLatches() {
        System.out.println("Autochanger unlocking latches.");
        FCSLOG.info("Autochanger unlocking latches.");
        FCSLOG.info("/timeout=" + timeoutForOpeningLatches);
        new CommandSwingWorker("open", this.timeoutForOpeningLatches, latchesName).execute();
    }

    /**
     ******************************************************************************
     ** end of Latches Actions
     * *****************************************************************************
     */
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("TestbenchCPPMGUI", AgentInfo.AgentType.CONSOLE);
        TestbenchCPPMGUI t = new TestbenchCPPMGUI(agent.getName(), "testbenchCPPM", agent.getMessagingAccess());
        agent.start();

        JFrame frame = new JFrame("Testbench CPPM GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
