
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A view to display a global view of the loader.
 * To be continued....
 * @author virieux
 */
public class LoaderGeneralViewPanel extends JPanel {
    private static final long serialVersionUID = 8834267363875256916L;
    private InterfaceLoaderGUI subs;

    private final JLabel onCameraLabel = new JLabel("ON CAMERA SENSOR");
    private final JLabel autochangerHoldingFilterLabel = new JLabel("AUTOCHANGER HOLDING FILTER SENSOR");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final DigitalSwitch onCameraDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch autochangerHoldingFilterDigitalSwitch = new DigitalSwitch();
    /* Homing panel */
    private final JPanel homingPanel = new JPanel();
    private final JLabel clhomLabel = new JLabel("Homing of the clamp controller:");
    private final JLabel cahomLabel = new JLabel("Homing of the carrier controller:");
    private final JLabel clampHomingLabel = new JLabel();
    private final JLabel carrierHomingLabel = new JLabel();
    
    //control panel    
    private final JButton loadFilterButton = new JButton("loadFilterInCamera");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromCamera");
    // End of variables declaration 
    
    /**
     * A Runnable to update this Panel when the fake Autochanger publishes on the STATUS bus.
     */
    class UpdateFakeAutochanger implements Runnable {
        
        private final int holdingFilterSensorValue;

        public UpdateFakeAutochanger(int holdingFilterSensorValue) {
            this.holdingFilterSensorValue = holdingFilterSensorValue;
        }
        
        

        @Override
        public void run() {
           autochangerHoldingFilterDigitalSwitch.setColor(holdingFilterSensorValue == 1 ? greenColor : Color.gray); 
        }
        
    }
    
    /**
     * A Runnable To updateState the general items for loader.
     */
    class UpdateLoaderGeneral implements Runnable {

        private final StatusDataPublishedByLoader s;

        UpdateLoaderGeneral(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {

            if (s.isLoaderOnCameraSensorsInError()) {
                onCameraDigitalSwitch.setColor(Color.RED);
            } else {
                onCameraDigitalSwitch.setColor(s.getLoaderOnCameraSensorValue0() == 1 ? greenColor : Color.gray);
            }
            
        }
    }
    
        /**
     * A Runnable to update this panel from data published on the status bus from the Loader Clamp.
     */
    private class UpdateClamp implements Runnable {

        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {

            if (s.isHomingDone()) {
                clampHomingLabel.setText("DONE");
                clampHomingLabel.setForeground(greenColor);
            } else {
                clampHomingLabel.setText("NOT DONE");
                clampHomingLabel.setForeground(Color.red);
            }
        }
    }

    /**
     * A constructor without any argument for tests.
     */
    public LoaderGeneralViewPanel() {
        initComponents();
    }
    
    

    /**
     * A constructor with a LoaderGUI.
     * @param subs 
     */
    public LoaderGeneralViewPanel(InterfaceLoaderGUI subs) {
        this.subs = subs;
        initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }
    
    /**
     * Initialize this Panel from Configuration Info data.
     * TODO : initialize timeouts for commands unloadFilter and loadFilter ?
     * @param configInfo 
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        //TODO if needed : SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    
    
    /**
     * To update the Panel when the loader publishes on the bus its global status.
     * @param status 
     */
    public void updateLoaderGeneral(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoaderGeneral(status));
    }
    
    /**
     * To update the Panel when the fakeAutochanger publishes on the bus its sensor value. 
     * @param sensorValue
     */
    public void updateFakeAutochanger(int sensorValue) {
        SwingUtilities.invokeLater(new UpdateFakeAutochanger(sensorValue));
    }
    
    /**
     * To update the Homing Panel when the loader clamp publishes on the bus. 
     * @param status
     */
    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }
    
    /**
     * To initialize all the components of this Panel.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER"));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        
        /**********************/
        /* Homing Panel       */
        /**********************/
        homingPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
        homingPanel.setLayout(new GridBagLayout());
        clampHomingLabel.setFont(BIG_FONT);
        carrierHomingLabel.setFont(BIG_FONT);
        GridBagConstraints gbc6 = new GridBagConstraints();
        gbc6.insets = insets_big;
        gbc6.gridx = 0;
        gbc6.gridy = 0; 
        homingPanel.add(clhomLabel, gbc6);
        gbc6.gridx++;
        homingPanel.add(clampHomingLabel, gbc6);
        gbc6.gridx = 0;
        gbc6.gridy++;
        homingPanel.add(cahomLabel, gbc6);
        gbc6.gridx++;
        homingPanel.add(carrierHomingLabel, gbc6);
        /**********************/
        /* end of Homing Panel*/
        /**********************/

        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        loadFilterButton.addActionListener((ActionEvent evt) -> {
            loadFilterActionPerformed(evt);
        });

        unloadFilterButton.addActionListener((ActionEvent evt) -> {
            unloadFilterActionPerformed(evt);
        });
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = GridBagConstraints.HORIZONTAL;
        controlPanel.add(loadFilterButton, gbc0);
        gbc0.gridy++;
        controlPanel.add(unloadFilterButton, gbc0);
         //end of Control Panel

        //Fake Sensors Panel 

        fakeSensorsPanel.setBorder(BorderFactory.createTitledBorder("FAKE SENSORS"));
        fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = GridBagConstraints.HORIZONTAL;
        fakeSensorsPanel.add(onCameraLabel, gbc1);

        gbc1.gridx++;
        fakeSensorsPanel.add(onCameraDigitalSwitch, gbc1);

        gbc1.insets = new Insets(0, 60, 0, 4);
        gbc1.gridx++;
        fakeSensorsPanel.add(autochangerHoldingFilterLabel, gbc1);
        gbc1.insets = insets_std;
        gbc1.gridx++;
        fakeSensorsPanel.add(autochangerHoldingFilterDigitalSwitch, gbc1);
        //end Fake Sensors Panel 

        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(homingPanel);
        gbc.gridy++;
        add(controlPanel, gbc);
        gbc.gridy++;
        add(fakeSensorsPanel, gbc);
        
        setDefaultValues();
    }
    
    private void setDefaultValues() {
        onCameraDigitalSwitch.setColor(Color.gray);
        autochangerHoldingFilterDigitalSwitch.setColor(Color.gray);  
        clampHomingLabel.setText("TO BE DONE");
        clampHomingLabel.setForeground(Color.red);
        carrierHomingLabel.setText("TO BE DONE");
        carrierHomingLabel.setForeground(Color.red);
    }
    
    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }
    
    private void loadFilterActionPerformed(ActionEvent evt) {
        subs.loadFilter();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        subs.unloadFilter();
    }
    
    /**
     * To be displayed on the GUI. 
     * @return 
     */
    @Override
    public String toString() {
        return "Loader General View Panel";
    }
    
    /**
     * Just for tests.
     * @param args 
     */
    public static void main(String[] args) {
        LoaderGeneralViewPanel d = new LoaderGeneralViewPanel();
        JFrame frame = new JFrame("Loader Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
