package org.lsst.ccs.subsystems.fcs.loader.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;

import javax.swing.*;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

/**
 *
 * @author F
 */
public class LoaderGUI extends GeneralGUI implements InterfaceLoaderGUI {
    private static final long serialVersionUID = 5516615814565445162L;
    private static final String clampModuleName = "clamp";
    private static final String carrierModuleName = "carrier";

    //actions timeout
    protected long updateCarrierPositionTimeout;
    protected long openHooksTimeout;
    protected long closeHooksTimeout;
    protected long clampHooksTimeout;
    protected long homingHooksTimeout;
    protected long goToHandoffTimeout;
    protected long goToStorageTimeout;
    protected long quickStopTimeout;

    public LoaderGUI(String name, String destination, AgentMessagingLayer agentMessagingLayer) {
        super(name, destination, agentMessagingLayer);
        LoaderGatherPanel loaderGatherPanel = new LoaderGatherPanel(this, LOADER_TCPPROXY_NAME);
        LoaderBottomPanel loaderBottomPanel = new LoaderBottomPanel(loaderGatherPanel, "LOADER");
        this.generalPanel = new GeneralPanel(this,loaderBottomPanel);
        pane = new JScrollPane(generalPanel);
        openHooksTimeout = 0;
        closeHooksTimeout = 0;
        clampHooksTimeout = 0;
        homingHooksTimeout = 0;
        goToHandoffTimeout = 0;
        goToStorageTimeout = 0;
        abortTimeout = 1000;
        quickStopTimeout = 1000;
        updateStateWithSensorsTimeout = 1000;
        updateCarrierPositionTimeout = 1000;
    }
    
    
    @Override
    public void setGoToHandoffTimeout(int aInt) {
        this.goToHandoffTimeout = aInt;
    }

    @Override
    public void setGoToStorageTimeout(int aInt) {
        this.goToStorageTimeout = aInt;
    }

    @Override
    public void setOpenHooksTimeout(long openHooksTimeout) {
        this.openHooksTimeout = openHooksTimeout;
    }

    @Override
    public void setCloseHooksTimeout(long closeHooksTimeout) {
        this.closeHooksTimeout = closeHooksTimeout;
    }

    @Override
    public void setClampHooksTimeout(long clampHooksTimeout) {
        this.clampHooksTimeout = clampHooksTimeout;
    }

    @Override
    public void setHomingHooksTimeout(long homingHooksTimeout) {
        this.homingHooksTimeout = homingHooksTimeout;
    }
    
    

    @Override
    public JComponent getGuiLayout() {
        return pane;
    }

    @Override
    public String getName() {
        return "LoaderGUIModule";
    }

    @Override
    public void loadFilter() {
        System.out.println(destination + "loadFilterInCamera with timeout=" + goToHandoffTimeout);
        FCSLOG.info("Loading filter in camera");
        FCSLOG.info("/timeout=" + goToHandoffTimeout);
        new CommandSwingWorker("loadFilterInCamera", this.goToHandoffTimeout).execute();
    }

    @Override
    public void unloadFilter() {
        System.out.println(destination + "unloadFilterFromCamera with timeout=" + goToStorageTimeout);
        FCSLOG.info("Loading filter in camera");
        FCSLOG.info("/timeout=" + goToStorageTimeout);
        new CommandSwingWorker("unloadFilterFromCamera", this.goToStorageTimeout).execute();
    }

    @Override
    public void updateCarrierPosition() {
        System.out.println(destination + "updateCarrierPosition with updateCarrierPositionTimeout=" + updateCarrierPositionTimeout);
        FCSLOG.info("Updating carrier position");
        FCSLOG.info("/timeout=" + updateCarrierPositionTimeout);
        new CommandSwingWorker("updatePosition", updateCarrierPositionTimeout, carrierModuleName).execute();
    }

    @Override
    public void openHooks() {
        FCSLOG.info("Opening Hooks");
        FCSLOG.info("/timeout=" + openHooksTimeout);
        new CommandSwingWorker("openHooks", openHooksTimeout).execute();
    }

    @Override
    public void closeHooks() {
        FCSLOG.info("Closing Hooks");
        System.out.println("/timeout=" + closeHooksTimeout);
        new CommandSwingWorker("closeHooks", this.closeHooksTimeout).execute();
    }

    @Override
    public void clampHooks() {
        FCSLOG.info("Clamping Hooks");
        FCSLOG.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("clampHooks", this.clampHooksTimeout).execute();
    }

    @Override
    public void goToHomePosition() {
        FCSLOG.info("Clamp going to Home Position");
        FCSLOG.info("/timeout=" + homingHooksTimeout);
        new CommandSwingWorker("goToHomePosition", this.homingHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void goToClosePosition() {
        FCSLOG.info("Going to Close Position");
        FCSLOG.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("goToClampedPosition", this.clampHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void goToHandOff() {
        FCSLOG.info("Carrier going to Handoff Position");
        FCSLOG.info("/timeout=" + goToHandoffTimeout);
        new CommandSwingWorker("goToHandOff", this.goToHandoffTimeout, carrierModuleName).execute();
    }

    @Override
    public void goToStorage() {
        System.out.println(destination + "goToStorage with goToStorageTimeout=" + goToStorageTimeout);
        FCSLOG.info("Carrier going to Storage Position");
        FCSLOG.info("/timeout=" + goToStorageTimeout);
        new CommandSwingWorker("goToStorage", this.goToStorageTimeout, carrierModuleName).execute();
    }
    
    @Override
    public void clampHoming() {
        FCSLOG.info("Clamp homing");
        FCSLOG.info("/timeout=" + homingHooksTimeout);
        new CommandSwingWorker("initializeHardware", this.homingHooksTimeout, clampModuleName).execute();
    }

    /**
     * Standalone case /
     *
     **
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Agent agent = new Agent("LoaderGUIModule", AgentInfo.AgentType.CONSOLE);
        LoaderGUI t = new LoaderGUI(agent.getName(), "loader-standalone", agent.getMessagingAccess());
        agent.start();
        t.initGui();

        JFrame frame = new JFrame("Loader View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }


   
}
