
package org.lsst.ccs.subsystems.fcs.loader.ui;

import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalProgressBarPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class LoaderClampPanel extends JPanel {

    private static final long serialVersionUID = -6313746913674371727L;
    private final String clampName;
    private InterfaceLoaderGUI subs;

    private final JLabel clampState = new JLabel();
    private final JLabel clampStateLabel = new JLabel("Clamp State :");
    private final JLabel forceSensorLabel = new JLabel();
    private final JLabel forLabel = new JLabel("Force Sensor Value :");
    private final JLabel forMinLabel = new JLabel("Force Min Value :");
    private final JLabel forceMinLabel = new JLabel();
    private final JLabel forMaxLabel = new JLabel("Force Max Value :");
    private final JLabel forceMaxLabel = new JLabel();
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    
    /* Homing panel */
    private final JPanel homingPanel = new JPanel();
    private final JLabel homLabel = new JLabel("Homing of the clamp controller:");
    private final JLabel homingLabel = new JLabel();

    private LoaderHookPanel hookPanel1;
    private LoaderHookPanel hookPanel2;
    private LoaderHookPanel hookPanel3;
    private LoaderHookPanel hookPanel4;
    private final JPanel forceSensorPanel = new JPanel();
    private final FilterPanel filterPanel = new FilterPanel();
    private VerticalProgressBarPanel positionProgressBarPanel;
    private VerticalProgressBarPanel currentProgressBarPanel;
    private JButton closeHooksButton;
    private JButton openHooksButton;
    private JButton homingButton;
    private JButton goToClampedPositionButton;
    private JButton goToHomePositionButton;
    private JButton clampHooksButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;
    // End of variables declaration                



    /**
     * A Runnable to initialize this panel from configuration data.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            /** Retrieve the configuration data for my name.*/
            Map<String, String> configForClamp = configInfo.getCurrentValuesFor(clampName);
            
            positionProgressBarPanel.setMinValue(Tools.toInt(configForClamp,"minPosition"));
            positionProgressBarPanel.setMaxValue(Tools.toInt(configForClamp,"maxPosition")); 
            positionProgressBarPanel.setValue(0);
            currentProgressBarPanel.setMinValue(Tools.toInt(configForClamp,"minCurrent")); 
            currentProgressBarPanel.setMaxValue(Tools.toInt(configForClamp,"maxCurrent"));
            currentProgressBarPanel.setValue(0);
            
            /** Initialization of the timeouts for the buttons commands.*/
            subs.setOpenHooksTimeout(Tools.toInt(configForClamp,"timeoutForOpeningHooks"));
            subs.setCloseHooksTimeout(Tools.toInt(configForClamp,"timeoutForClosingHooks"));
            subs.setClampHooksTimeout(Tools.toInt(configForClamp,"timeoutForClampingHooks"));
            subs.setHomingHooksTimeout(Tools.toInt(configForClamp,"timeoutForGoingToHomePosition"));
        }
    }

    /**
     * A Runnable to update this panel from data published on the status bus from the Loader Clamp.
     */
    private class UpdateClamp implements Runnable {

        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {

            Color clampStateColor = s.getClampState().getColor();
            int clampPosition = s.getPosition();
            clampState.setText(s.getClampState().getText());
            clampState.setForeground(clampStateColor);
            positionProgressBarPanel.setValue(clampPosition);
            positionProgressBarPanel.setColor(clampStateColor);
            currentProgressBarPanel.setValue(s.getCurrent());
            hookPanel1.updateHook(s.getStatusPublishedByHook1());
            hookPanel2.updateHook(s.getStatusPublishedByHook2());
            hookPanel3.updateHook(s.getStatusPublishedByHook3());
            hookPanel4.updateHook(s.getStatusPublishedByHook4());
            forceSensorLabel.setText(Integer.toString(s.getForce()));
            if (s.isHomingDone()) {
                homingLabel.setText("DONE");
                homingLabel.setForeground(greenColor);
            } else {
                homingLabel.setText("NOT DONE");
                homingLabel.setForeground(Color.red);
            }
        }
    }
    
    /**
     * A Runnable to update this panel from data published on the status bus from the Loader.
     */
    private class UpdateFilterPanel implements Runnable {

        private final StatusDataPublishedByLoader s;

        public UpdateFilterPanel(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (s.isFilterPresenceSensorsInError()) {
                filterPanel.setColor(Color.red);
            } else {
                filterPanel.setIsFilterInHouse(s.getFilterPresenceSensorValue0() == 1, "dummyFilter");
            }
        }

    }
    
    /**
     * Creates new form LoaderClampPanel
     * @param clampName
     */
    public LoaderClampPanel(String clampName) {
        this.clampName = clampName;
        initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateClamp(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateFilterPanel(status));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        //X- and X+ label
        Font xFont = new Font("Tahoma", 1, 18);
        xMinusLabel.setFont(xFont); // NOI18N      
        xMinuxLabel2.setFont(xFont); // NOI18N
        xPlusLabel2.setFont(xFont); // NOI18N       
        xPlusLabel.setFont(xFont); // NOI18N
        JPanel hooksPanel = new JPanel();
        JPanel clampStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();
        hookPanel1 = new LoaderHookPanel("hook1");
        hookPanel2 = new LoaderHookPanel("hook2");
        hookPanel3 = new LoaderHookPanel("hook3");
        hookPanel4 = new LoaderHookPanel("hook4");
        
        currentProgressBarPanel = new VerticalProgressBarPanel("Current", -300, 500, 0, 1);
        currentProgressBarPanel.setStringPainted(false);
        positionProgressBarPanel = new VerticalProgressBarPanel("Position", 5000, 480000, 0, 1);


        updateStateWithSensorsButton = new JButton("Read sensors and update state");
        openHooksButton = new JButton("Open");
        goToClampedPositionButton = new JButton("Go To Clamped Position");
        clampHooksButton = new JButton("Clamp");
        closeHooksButton = new JButton("Close");
        goToHomePositionButton = new JButton("Go To Home Position");
        abortButton = new JButton("Abort");
        homingButton = new JButton("Homing");

        updateStateWithSensorsButton.addActionListener((ActionEvent evt) -> 
            updateStateWithSensorsButtonActionPerformed(evt)
        );

        openHooksButton.addActionListener((ActionEvent evt) -> 
            openHooksButtonActionPerformed(evt)
        );

        goToClampedPositionButton.addActionListener((ActionEvent evt) -> 
            goToClampedPositionButtonActionPerformed(evt)
        );

        clampHooksButton.addActionListener((ActionEvent evt) -> 
            clampHooksButtonActionPerformed(evt)
        );

        closeHooksButton.addActionListener((ActionEvent evt) -> 
            closeHooksButtonActionPerformed(evt)
        );

        goToHomePositionButton.addActionListener((ActionEvent evt) -> 
            goToHomePositionButtonActionPerformed(evt)
        );
        
        abortButton.addActionListener((ActionEvent evt) -> 
            abortActionPerformed(evt)
        );
        
        homingButton.addActionListener((ActionEvent evt) -> 
            homingActionPerformed(evt)
        );
        
        /**
         ******************************************************************************
         ** Clamp State Panel
         * *****************************************************************************
         */
        clampState.setFont(BIG_FONT); // NOI18N
        clampState.setBorder(javax.swing.BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        clampStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        clampStatePanel.add(clampStateLabel, gbc2);
        gbc2.gridx++;
        clampStatePanel.add(clampState, gbc2);
        /**
         ******************************************************************************
         ** end of Clamp State Panel
         * *****************************************************************************
         */
        
        /**
         ******************************************************************************
         ** Force Sensor Panel
        ******************************************************************************
        */
        JPanel limitsForcePanel = new JPanel();
        GridBagConstraints gbc5 = new GridBagConstraints();
        limitsForcePanel.setBorder(BorderFactory.createEtchedBorder());
        gbc5.gridx = 0;
        gbc5.gridy = 0; 
        limitsForcePanel.add(forMinLabel,gbc5);
        gbc5.gridx++;
        limitsForcePanel.add(forceMinLabel,gbc5);
        gbc5.gridx++;
        limitsForcePanel.add(forMaxLabel,gbc5);
        gbc5.gridx++;
        limitsForcePanel.add(forceMaxLabel,gbc5);
        
        forceSensorPanel.setLayout(new GridBagLayout());
        forceSensorPanel.setBorder(BorderFactory.createTitledBorder(
        BorderFactory.createLineBorder(Color.BLUE,1), "Force Sensor"));
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0; 
        gbc4.anchor = GridBagConstraints.LINE_START;
        forceSensorPanel.add(forLabel,gbc4);
        gbc4.gridx++;
        gbc4.anchor = GridBagConstraints.LINE_END;
        forceSensorLabel.setFont(BIG_FONT);
        forceSensorPanel.add(forceSensorLabel,gbc4);
        gbc4.gridx++;
        forceSensorPanel.add(limitsForcePanel,gbc4);
 
        
        
        /**
         ******************************************************************************
         ** end of Force Sensor Panel
        ******************************************************************************
        */ 
        
        /**********************/
        /* Homing Panel       */
        /**********************/
        homingPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
        homingPanel.setLayout(new GridBagLayout());
        homingLabel.setFont(BIG_FONT);
        GridBagConstraints gbc6 = new GridBagConstraints();
        gbc6.insets = insets_big;
        gbc6.gridx = 0;
        gbc6.gridy = 0; 
        homingLabel.setFont(BIG_FONT);
        homingPanel.add(homLabel, gbc6);
        gbc6.gridx++;
        homingPanel.add(homingLabel, gbc6);        
        /**********************/
        /* end of Homing Panel*/
        /**********************/
        
       
        /**
         ******************************************************************************
         ** Hooks Panel
         * *****************************************************************************
         */
        hooksPanel.setLayout(new GridBagLayout());
        hooksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Hooks State"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;

        hookPanel1.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        hooksPanel.add(hookPanel1, gbc1);

        hookPanel2.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx++;
        hooksPanel.add(hookPanel2, gbc1);

        hookPanel3.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx = 0;
        gbc1.gridy = 1;
        hooksPanel.add(hookPanel3, gbc1);

        hookPanel4.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx++;
        hooksPanel.add(hookPanel4, gbc1);
        /**
         ******************************************************************************
         ** End of Hooks Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(homingButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(goToHomePositionButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(goToClampedPositionButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(openHooksButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(closeHooksButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(clampHooksButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(abortButton, gbc3);
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("LOADER CLAMP"));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;

        gbc.insets = insets_std;

        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        add(homingPanel,gbc);
        gbc.gridy++;
        gbc.anchor = GridBagConstraints.WEST;

        add(xMinusLabel, gbc);
        gbc.anchor = GridBagConstraints.EAST;
        gbc.fill = GridBagConstraints.NONE;
        gbc.gridx = 3;
        add(xPlusLabel, gbc);

        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        add(clampStatePanel, gbc);
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridy++;

        add(hooksPanel, gbc);
        gbc.gridy++;
        gbc.gridwidth = 2;
        add(forceSensorPanel, gbc);
        gbc.insets = new Insets(14, 30, 6, 30);
        gbc.gridwidth = 1;       
        gbc.gridx = 0;
        gbc.gridy++;
        add(positionProgressBarPanel, gbc);
        gbc.gridx++;
        add(currentProgressBarPanel, gbc);
        gbc.gridx++;
        gbc.anchor = GridBagConstraints.CENTER;

        add(filterPanel, gbc);
        gbc.gridx++;

        gbc.anchor = GridBagConstraints.EAST;
        add(controlPanel, gbc);
        
        setDefaultValues();


    }// </editor-fold>   
    
    /**
     * Initialization to be done when Loader subsystem is not yet booted or is shutdown.
     */
    private void setDefaultValues() {
        filterPanel.setColor(Color.gray);
        clampState.setText(UNKNOWN_STATE);
        forceSensorLabel.setText("UNKNOWN");
        forceMinLabel.setText("0");
        forceMaxLabel.setText("999999999");
        homingLabel.setText("TO BE DONE");
        homingLabel.setForeground(Color.red);
    }
    
    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
        hookPanel1.resetPanel();
        hookPanel2.resetPanel();
        hookPanel3.resetPanel();
        hookPanel4.resetPanel();
    }

    private void updateStateWithSensorsButtonActionPerformed(java.awt.event.ActionEvent evt) {
        subs.updateStateWithSensors();
    }

    private void openHooksButtonActionPerformed(ActionEvent evt) {
        subs.openHooks();
    }

    private void closeHooksButtonActionPerformed(ActionEvent evt) {
        subs.closeHooks();
    }

    private void clampHooksButtonActionPerformed(ActionEvent evt) {
        subs.clampHooks();
    }

    private void goToHomePositionButtonActionPerformed(ActionEvent evt) {
        subs.goToHomePosition();
    }

    private void goToClampedPositionButtonActionPerformed(ActionEvent evt) {
        subs.goToClosePosition();
    }

    private void abortActionPerformed(ActionEvent evt) {
        subs.abortAction();
    }
    
    private void homingActionPerformed(ActionEvent evt) {
        subs.clampHoming();
    }
    
    @Override
    public String toString() {
        return "Clamp Panel";
    }

    public static void main(String[] argv) {

        LoaderClampPanel d = new LoaderClampPanel("myClamp");
        JFrame frame = new JFrame("New Loader Clamp Panel");
        d.currentProgressBarPanel.setValueName("Current");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
