/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByFilter;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * This Panel's goal is to display the list of filters the subsystem manages.
 * For each filter it's name, ID, weight and location is displayed.
 * 
 * 
 * @author virieux
 */
public class FilterListPanel extends JPanel {
    private static final long serialVersionUID = 2654131875576434801L;
   
    private InterfaceCarouselGUI subs;
    private JTable filterTable;
    private JScrollPane jScrollPane;
    
    //control panel
    private final JButton checkFiltersLocationButton = new JButton("checkFiltersLocation");

    /**
     * Creates a new FilterListPanel and initialize all its components.
     */
    public FilterListPanel() {
        initComponents();
    }

    public void setSubsystem(InterfaceCarouselGUI subs) {
        this.subs = subs;
    }
    
    
    


    
     /**
     * Initialization of the GUI from data stored in Configuration. *
     * Definition of a Runnable.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;
        private final List<String> filterNamesList;


        public GuiInitialization(ConfigurationInfo configInfo,List<String> filterNamesList ) {
            this.configInfo = configInfo;
            /*initialize this.filterNamesList from a copy of the List<String> argument.*/
            this.filterNamesList = new ArrayList<>();
            this.filterNamesList.addAll(filterNamesList);
        }

        @Override
        public void run() {
            /**
             * Filter list panel *
             */
            //configure Filter Table           
            DefaultTableModel filterTableModel = (DefaultTableModel) filterTable.getModel();
            for (String filterName: filterNamesList) {
                Map<String, String> config = configInfo.getCurrentValuesFor(filterName);
                Object[] tab = {filterName, 
                    Integer.parseInt(config.get("filterID")),
                    Double.parseDouble(config.get("weight")),
                    "UNKNOWN",
                    "UNKNOWN"
                };
                filterTableModel.addRow(tab);
            }
            
            filterTableModel.fireTableDataChanged();

        }
    }
    
    /**
     * A Runnable class to update the Filter List when a Filter publishes on the 
     * Status bus its new location.
     */
    private class UpdateFilterListPanel implements Runnable {

        private final String filterName;
        private final StatusDataPublishedByFilter s;
        

        public UpdateFilterListPanel(String filterName, StatusDataPublishedByFilter status) {
            this.filterName = filterName;
            this.s = status;
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel) filterTable.getModel();
            int rowNB = filterTableModel.getRowCount();
            for (int i = 0; i < rowNB; i++) {
                if ((filterTableModel.getValueAt(i, 0)).equals(filterName)) {
                    filterTableModel.setValueAt(s.getLocation(), i, 3);
                    filterTableModel.setValueAt(s.getSocketName(), i, 4);
                }
            }
            filterTableModel.fireTableDataChanged();
        }
    }
    
    /**
     * Initialize Panel with filter list name.
     * @param configInfo
     * @param filterNameList 
     */
    public void initializeGui(ConfigurationInfo configInfo,List<String> filterNameList) {       
        SwingUtilities.invokeLater(new GuiInitialization(configInfo,filterNameList));
    }

    /**
     * Update a row for a filter in filterTable from information found on the STATUS bus
     * in an object : StatusDataPublishedByFilter.
     * @param filterName
     * @param status 
     */
    public void updateFilterListPanel(String filterName, StatusDataPublishedByFilter status) {
        SwingUtilities.invokeLater(new UpdateFilterListPanel(filterName, status));
    }
    
    /**
     * Delete filter table rows.
     * Used when GUI is disconnecting to reset filter panel to empty values.
     */
    public void resetPanel() {
        DefaultTableModel filterTableModel = (DefaultTableModel) filterTable.getModel();
        int rowNB = filterTableModel.getRowCount();
        while (filterTableModel.getRowCount() > 0) {
            filterTableModel.removeRow(filterTableModel.getRowCount()-1);
        }
        filterTableModel.fireTableRowsDeleted(0, rowNB-1);
    }
    
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        /*checkFilterLocation button*/
        checkFiltersLocationButton.addActionListener((ActionEvent evt) -> {
            checkFiltersLocationActionPerformed(evt);
        });
        
        /**
         ******************************************************************************
         ** Initialization of the table of filters
         * *****************************************************************************
         */
        jScrollPane = new JScrollPane();
        filterTable = new JTable();
        filterTable.setModel(new DefaultTableModel(
                new Object[][]{},
                new String[]{
                    "Name", "Filter ID", "Weight", "Location", "Socket number"
                }
        ) {
            private static final long serialVersionUID = 1L;
            private Class[] types = new Class[]{
                String.class, Integer.class, Double.class, String.class, String.class
            };
            private boolean[] canEdit = new boolean[]{
                false, false, false, false, false
            };

            @Override
            public Class getColumnClass(int columnIndex) {
                return types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit[columnIndex];
            }
        });
        TableColumn column;
        for (int i = 0; i < 5; i++) {
            column = filterTable.getColumnModel().getColumn(i);
            if (i == 0 || i == 3) {
                column.setPreferredWidth(100); //first and third column are bigger
            }
        }
        jScrollPane.setViewportView(filterTable);
        /**
         ******************************************************************************
         ** end of Filter Table Panel
         * *****************************************************************************
         */
        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc4.fill = GridBagConstraints.HORIZONTAL;
        gbc4.insets = insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add(checkFiltersLocationButton, gbc4);
        
        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(BorderFactory.createLineBorder(Color.YELLOW));
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(jScrollPane, gbc);
        gbc.gridy++;
        add(controlPanel, gbc);
        
    }
    
    private void checkFiltersLocationActionPerformed(java.awt.event.ActionEvent evt) {
        subs.checkFiltersLocation();
    }    
    
    @Override
    public String toString() {
        return "Filter list";
    }
    
    /**
     * to test 
     * @param argv 
     */
    public static void main(String[] argv) {
        
        FilterListPanel p = new FilterListPanel();
                //p.initializeGui(tcpConfig);

        JFrame frame = new JFrame("FILTERS");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
    }
    
}
