
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerTwoTrucksPanel extends JPanel {
    private static final long serialVersionUID = 1545510390830387685L;
    private final String trucksName;
    private InterfaceAutochangerGUI subs;
    
    /* Homing panel */
    private final JPanel homingPanel = new JPanel();
    private final JLabel homLabel = new JLabel("Homing of the controllers:");
    private final JLabel homingLabel = new JLabel();  
    
    /* State panel*/
    private final JPanel deltaPositionPanel = new JPanel();
    private final JLabel delLabel = new JLabel("acTruckXminus position - acTruckXplus position = ");
    private final JLabel deltaPositionLabel = new JLabel();
    
    /* Trucks panels*/
    private final AutochangerTruckPanel truckXminusPanel;
    private final AutochangerTruckPanel truckXplusPanel;
    

    //general informations panel
    private final JLabel stjLabel = new JLabel("Standby Position (in mm): ");
    private final JLabel onjLabel = new JLabel("Online Position (in mm): ");
    private final JLabel hojLabel = new JLabel("Hand-Off Position (in mm): ");
    private final JLabel smjLabel = new JLabel("Speed max (in rpm/mn): ");
    private final JLabel cmjLabel = new JLabel("Current max (in mA): ");
    private final JLabel standbyPositionjLabel = new JLabel();
    private final JLabel handoffPositionjLabel = new JLabel();
    private final JLabel onlinePositionjLabel = new JLabel();
    private final JLabel speedMaxjLabel = new JLabel();
    private final JLabel currentMaxjLabel = new JLabel();

    //control panel
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton updatePositionButton = new JButton("updatePosition");
    private final JButton goToStandbyButton = new JButton("goToStandby");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToOnlineButton = new JButton("goToOnline");
    private final JButton quickStopButton = new JButton("QuickStop");
    private final JButton abortButton = new JButton("Abort");
    //private final JButton shutdownButton = new JButton("Shutdown FCS");

    // End of variables declaration 
    


    /**
     * A Runnable to  initialize this Panel from configuration data.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
                        
            //Retrieve the configuration data for my name.
            Map<String, String> configForName = configInfo.getCurrentValuesFor(trucksName);

            //trucks
            subs.setTimeoutForTrucksMotion(Long.parseLong(configForName.get("timeoutForTrucksMotion")));
            //General Informations Panel
            int standbyPosition = Integer.parseInt(configForName.get("standbyPosition"));
            int handoffPosition = Integer.parseInt(configForName.get("handoffPosition"));
            int onlinePosition = Integer.parseInt(configForName.get("onlinePosition"));            
            double standbyPositionInMm = standbyPosition / 1000;
            double handoffPositionInMm = handoffPosition / 1000;
            double onlinePositionInMm = onlinePosition / 1000;
            standbyPositionjLabel.setText(Double.toString(standbyPositionInMm));
            handoffPositionjLabel.setText(Double.toString(handoffPositionInMm));
            onlinePositionjLabel.setText(Double.toString(onlinePositionInMm));
            speedMaxjLabel.setText(configForName.get("maxSpeed"));
            currentMaxjLabel.setText(configForName.get("maxCurrent"));
            
            //position progress bar for truckXminusPanel and truckXplusPanel
            truckXminusPanel.initializeGui(standbyPosition, onlinePosition);
            truckXplusPanel.initializeGui(standbyPosition, onlinePosition);
        }
    }

    /**
     * A Runnable to update this Panel from data published on the STATUS bus.
     */
    class UpdateTrucks implements Runnable {

        private final StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            //TODO put the values of the limit switch sensors.
            if (s.isHomingDone()) {
                homingLabel.setText("DONE");
                homingLabel.setForeground(Color.green);
            } else {
                homingLabel.setText("NOT DONE");
                homingLabel.setForeground(Color.red);
            }
            deltaPositionLabel.setText(Integer.toString(s.getDeltaPosition()));           
        }
    }
    
    /**
     * Creates new form AutochangerTrucksPanel
     * @param trucksName
     */
    public AutochangerTwoTrucksPanel(String trucksName) {
        this.trucksName = trucksName;
        truckXminusPanel = new AutochangerTruckPanel("acTruckXminus");
        truckXplusPanel = new AutochangerTruckPanel("acTruckXplus");
        initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
        SwingUtilities.invokeLater(new UpdateTrucks(status));
    }
    
    public void updateTruck(String truckName, StatusDataPublishedByAutochangerTruck s) {
        FCSCst.FCSLOG.finest(truckName + " Data published by acTruck= " + s.toString());
        switch (truckName) {
            case "acTruckXminus":
                truckXminusPanel.updateTruck(s);
                break;
            case "acTruckXplus":
                truckXplusPanel.updateTruck(s);
                break;
            default:
                FCSCst.FCSLOG.error(getName() + " acTruck name should be acTruckXminus or acTruckXplus."
                        + "Can't update the GUI.");
        }
    }    

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */

    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        setDefaultValues();
        /*
         **  Add graphical components to the main panel
         */

        updateStateWithSensorsButton.addActionListener(this::updateStateWithSensorsActionPerformed);

        updatePositionButton.addActionListener(this::updatePositionActionPerformed);

        goToHandoffButton.addActionListener(this::goToHandoffActionPerformed);

        goToOnlineButton.addActionListener(this::goToOnlineActionPerformed);

        goToStandbyButton.addActionListener(this::goToStandbyActionPerformed);

        quickStopButton.addActionListener(this::quickStopActionPerformed);

        abortButton.addActionListener(this::abortActionPerformed);
        
        /**********************/
        /* Homing Panel       */
        /**********************/
        homingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE),"Homing"));
        homingPanel.setLayout(new GridBagLayout());
        homingLabel.setFont(BIG_FONT);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_big;
        gbc1.gridx = 0;
        gbc1.gridy = 0; 
        homingLabel.setFont(BIG_FONT);
        homingPanel.add(homLabel, gbc1);
        gbc1.gridx++;
        homingPanel.add(homingLabel, gbc1);  
        
        /**********************/
        /* Delta Position Panel */
        /**********************/
        deltaPositionPanel.setBorder(BorderFactory.createTitledBorder(
                BorderFactory.createLineBorder(Color.ORANGE),"Delta Position"));
        deltaPositionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_big;
        gbc2.gridx = 0;
        gbc2.gridy = 0;        
        deltaPositionPanel.add(delLabel, gbc2);
        gbc2.gridx++;
        deltaPositionPanel.add(deltaPositionLabel, gbc2);

        /* Whole Panel*/
        setBorder(javax.swing.BorderFactory.createTitledBorder(
                BorderFactory.createLineBorder(Color.PINK),"AUTOCHANGER TRUCKS"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        add(homingPanel,gbc);
        gbc.gridx++;
        add(deltaPositionPanel,gbc);

        /**
         ******************************************************************************
         ** Trucks Panel
         * *****************************************************************************
         */
        gbc.anchor = GridBagConstraints.NORTH;
        gbc.gridx = 0;
        gbc.gridy++;
        add(truckXminusPanel,gbc);
        gbc.gridx++;
        add(truckXplusPanel,gbc);
        
        /**
         ******************************************************************************
         ** End of Trucks Panel
         * *****************************************************************************
         */


        /**
         ******************************************************************************
         ** General Informations Panel
         * *****************************************************************************
         */
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder(
                BorderFactory.createLineBorder(Color.BLUE,3),"General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = insets_std;
        //first colomn
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_START;
        generalInfoPanel.add(onjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(hojLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(stjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(smjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(cmjLabel, gbc3);
        //second colomn
        gbc3.gridx++;
        gbc3.gridy = 0;
        gbc3.anchor = GridBagConstraints.LINE_END;
        generalInfoPanel.add(onlinePositionjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(handoffPositionjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(standbyPositionjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(speedMaxjLabel, gbc3);
        gbc3.gridy++;
        generalInfoPanel.add(currentMaxjLabel, gbc3);

        //General Informations panel on the grid
        gbc.gridx = 0;
        gbc.gridy++;
        add(generalInfoPanel, gbc);
        /**
         ******************************************************************************
         ** End of General Informations Panel
         * *****************************************************************************
         */


        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc4 = new java.awt.GridBagConstraints();
        gbc4.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc4.fill = GridBagConstraints.HORIZONTAL;
        gbc4.insets = insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(updatePositionButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(goToOnlineButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(goToHandoffButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(goToStandbyButton, gbc4);
        gbc4.gridy++;
        controlPanel.add(abortButton, gbc4);
        //
        //Control panel on the grid
        gbc.gridx++;
        add(controlPanel, gbc);
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

    }

    private void updateStateWithSensorsActionPerformed(java.awt.event.ActionEvent evt) {
        subs.updateStateWithSensors();
    }

    private void updatePositionActionPerformed(java.awt.event.ActionEvent evt) {
        subs.updateTrucksPosition();
    }

    private void goToHandoffActionPerformed(java.awt.event.ActionEvent evt) {
        subs.goToHandOff();
    }

    private void goToOnlineActionPerformed(java.awt.event.ActionEvent evt) {
        subs.goToOnline();
    }

    private void goToStandbyActionPerformed(java.awt.event.ActionEvent evt) {
        subs.goToStandby();
    }

    private void quickStopActionPerformed(java.awt.event.ActionEvent evt) {
        subs.stopMyDestinationSubsystem();
    }

    private void abortActionPerformed(java.awt.event.ActionEvent evt) {
        subs.abortAction();
    }
    
    private void setDefaultValues() {
        standbyPositionjLabel.setText(Integer.toString(0));
        handoffPositionjLabel.setText(Double.toString(0));
        onlinePositionjLabel.setText(Double.toString(0));
        speedMaxjLabel.setText(Integer.toString(0));
        currentMaxjLabel.setText(Integer.toString(0));
        homingLabel.setText("NOT DONE");
        homingLabel.setForeground(Color.red);
        deltaPositionLabel.setText(Integer.toString(0));
    }    
    
    /**
     * Reset components default values.
     */
    public void resetPanel() {
        setDefaultValues();
        truckXminusPanel.resetPanel();
        truckXplusPanel.resetPanel();
    }
    
    /**
     * This method is used by the AutochangerTreePanel to display the name of
     * the node in the JTreePanel.
     * @return 
     */
    @Override
    public String toString() {
        return "Trucks";
    }

    /**
     * For tests.
     * @param argv 
     */
    public static void main(String[] argv) {

        AutochangerTwoTrucksPanel d = new AutochangerTwoTrucksPanel("autochangerTrucks");
        JFrame frame = new JFrame("Autochanger Trucks Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
