
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerTwoLatchesPanel extends JPanel {
    
    private static final long serialVersionUID = -6970922329469696468L;

    private InterfaceAutochangerGUI subs;

    private final JLabel latchesState = new JLabel();
    private final JLabel latchesStateLabel = new JLabel("LATCHES STATE :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private final AutochangerLatchPanel latchXminusPanel = new AutochangerLatchPanel("latchXminus");
    private final AutochangerLatchPanel latchXplusPanel = new AutochangerLatchPanel("latchXplus");

    private final FilterPanel filterPanel = new FilterPanel();
    //private VerticalProgressBarPanel currentProgressBarPanel;
    private JButton closeLatchesButton;
    private JButton openLatchesButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;
    // End of variables declaration 

    public AutochangerTwoLatchesPanel() {
        initComponents();
    }

    public AutochangerTwoLatchesPanel(InterfaceAutochangerGUI subs) {
        this.subs = subs;
        this.latchXminusPanel.setSubsystem(subs);
        this.latchXplusPanel.setSubsystem(subs);
        initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
        this.latchXminusPanel.setSubsystem(subs);
        this.latchXplusPanel.setSubsystem(subs);
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        latchXminusPanel.initializeGui(configInfo);
        latchXplusPanel.initializeGui(configInfo);
    }


    public void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        FCSCst.FCSLOG.finest(getName() + " Data published by Latch= " + s.toString());
        String latchName = s.getName();
        switch (latchName) {
            case "latchXminus":
                latchXminusPanel.updateLatch(s);
                break;
            case "latchXplus":
                latchXplusPanel.updateLatch(s);
                break;
            default:
                FCSCst.FCSLOG.error(getName() + " Latch name should be latchXminus or latchXplus."
                        + "Can't update the GUI.");
        }
    }

    public void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    /**
     * A Runnable inner class to update this panel when an object StatusDataPublishedByAutochangerTwoLatches
     * is received on STATUS bus.
    */
    class UpdateLatches implements Runnable {

        private StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            latchesState.setText(s.getLockStatus().toString());
            latchesState.setForeground(s.getLockStatus().getColor());
            filterPanel.setIsFilterInHouse(s.getFilterPresenceStatus().equals(FilterPresenceStatus.ENGAGED),
                    s.getFilterName());
            if (s.getFilterPresenceStatus().equals(FilterPresenceStatus.UNKNOWN)) {
                filterPanel.setColor(Color.YELLOW);
            }
        }
    }

    private void updateStateWithSensorsButtonActionPerformed(ActionEvent evt) {
        subs.updateStateWithSensors();
    }

    private void lockButtonActionPerformed(ActionEvent evt) {
        subs.closeLatches();
    }

    private void unlockButtonActionPerformed(ActionEvent evt) {
        subs.openLatches();
    }

    private void abortButtonActionPerformed(ActionEvent evt) {
        subs.abortAction();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        
        setDefaultValues();

        //X- and X+ label
        Font xFont = new Font("Tahoma", 1, 18);
        xMinusLabel.setFont(xFont); // NOI18N      
        xMinuxLabel2.setFont(xFont); // NOI18N
        xPlusLabel2.setFont(xFont); // NOI18N       
        xPlusLabel.setFont(xFont); // NOI18N
        JPanel latchesPanel = new JPanel();
        JPanel latchesStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();

//        currentProgressBarPanel = new VerticalProgressBarPanel("Current",-1200,1200,0);
//        currentProgressBarPanel.setStringPainted(false);
        filterPanel.setSize(150);

        updateStateWithSensorsButton = new JButton("Read sensors and update state");
        openLatchesButton = new JButton("Open Latches");
        closeLatchesButton = new JButton("Close Latches");
        abortButton = new JButton("Abort");

        updateStateWithSensorsButton.addActionListener((ActionEvent evt) -> {
            updateStateWithSensorsButtonActionPerformed(evt);
        });

        closeLatchesButton.addActionListener((ActionEvent evt) -> {
            lockButtonActionPerformed(evt);
        });

        openLatchesButton.addActionListener((ActionEvent evt) -> {
            unlockButtonActionPerformed(evt);
        });

        abortButton.addActionListener((ActionEvent evt) -> {
            abortButtonActionPerformed(evt);
        });

        /**
         ******************************************************************************
         ** Latches State Panel
         * *****************************************************************************
         */
        latchesState.setFont(BIG_FONT); // NOI18N
        latchesState.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        latchesStatePanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        latchesStatePanel.add(latchesStateLabel, gbc2);
        gbc2.gridx++;
        latchesStatePanel.add(latchesState, gbc2);
        /**
         ******************************************************************************
         ** end of Latches State Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Latches Panel
         * *****************************************************************************
         */
        latchesPanel.setLayout(new java.awt.GridBagLayout());
        latchesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW), "Latches State"));
        GridBagConstraints gbc1 = new java.awt.GridBagConstraints();
        gbc1.insets = insets_std;

        latchXminusPanel.setLatchName("Latch 1");
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        latchesPanel.add(latchXminusPanel, gbc1);

        latchXplusPanel.setLatchName("Latch 2");
        gbc1.gridx++;
        latchesPanel.add(latchXplusPanel, gbc1);

        /**
         ******************************************************************************
         ** End of Latches Panel
         * *****************************************************************************
         */
        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(openLatchesButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(closeLatchesButton, gbc3);
        gbc3.gridy++;
        controlPanel.add(abortButton, gbc3);
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK), "AUTOCHANGER LATCHES"));
        //setBorder(javax.swing.BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK),"LOADER CLAMP"));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.WEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(xMinusLabel, gbc);
        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx = 3;
        add(xPlusLabel, gbc);

        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        add(latchesStatePanel, gbc);
        gbc.gridy++;
        add(latchesPanel, gbc);

        gbc.insets = insets_big;
        gbc.insets = new Insets(14, 30, 6, 30);
        gbc.gridx = 0;
        gbc.gridy++;
//        gbc.gridwidth = 1;
//        add(currentProgressBarPanel, gbc);
//        gbc.gridx++;
        add(filterPanel, gbc);
        gbc.gridx++;
        gbc.anchor = GridBagConstraints.EAST;
        add(controlPanel, gbc);

    }
    
    private void setDefaultValues() {
        filterPanel.setColor(Color.gray);
        latchesState.setText(UNKNOWN_STATE);
    }
    
    /**
     * Reset components default values.
     */
    public void resetPanel() {
        setDefaultValues();
        latchXminusPanel.resetPanel();
        latchXplusPanel.resetPanel();
    }

    @Override
    public String toString() {
        return "Latches";
    }

    public static void main(String[] argv) {

        AutochangerTwoLatchesPanel d = new AutochangerTwoLatchesPanel();
        JFrame frame = new JFrame("Autochanger Latches Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
