
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import static java.awt.image.ImageObserver.WIDTH;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.ZERO_VALUE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;

/**
 *
 * @author virieux
 */
public class AutochangerGeneralViewPanel extends JPanel {
    private static final long serialVersionUID = -713173978095339372L;

    //LoaderConnectedPanel
    private final JPanel loaderConnectedPanel = new JPanel();
    private final JLabel loaderConnectedLabel = new JLabel("<html><P align=\"center\">Loader<br>sensor</p></html>");
    private final DigitalSwitch loaderConnectedDigitalSwitch = new DigitalSwitch();

    private final static String CONNECTED = "<html><P align=\"center\">Loader<br>connected</p></html>";
    private final static String NOT_CONNECTED = "<html><P align=\"center\">Loader<br>not<br>connected</p></html>";
    private JPanel latchesStatePanel;
    private JPanel clampsStatePanel;
    private final FilterPanel filterPanel = new FilterPanel();

    private JPanel trucksStatePanel;
    private final DigitalSwitch standbyDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch onlineDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel standbyjLabel = new JLabel("STANDBY");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("HAND-OFF");
    private final JLabel onlinejLabel = new JLabel("ONLINE");
    private final JLabel inErrorjLabel = new JLabel("IN ERROR");

    private final JLabel clSLabel = new JLabel("Online Clamps State:");
    private final JLabel clampsStateLabel = new JLabel();
    private final JLabel laSLabel = new JLabel("Latches State:");
    private final JLabel latchesStateLabel = new JLabel();
    private final JLabel trLabel = new JLabel("Trucks position in mm:");
    private final JLabel trucksPositionLabel = new JLabel();

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by the autochanger
     */
    private class UpdateAutochanger implements Runnable {

        private StatusDataPublishedByAutoChanger s;

        public UpdateAutochanger(StatusDataPublishedByAutoChanger status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (s.isLoaderConnectedSensorsInError()) {
                loaderConnectedDigitalSwitch.setColor(Color.RED);
                //if loader is connected
            } else if ((s.getLoaderConnectedSensorValue0() == 1)
                    && (s.getLoaderConnectedSensorValue1() == 1)) {
                loaderConnectedDigitalSwitch.setColor(greenColor);
                loaderConnectedLabel.setText(CONNECTED);
                //if loader is not connected    
            } else {
                loaderConnectedDigitalSwitch.setColor(Color.gray);
                loaderConnectedLabel.setText(NOT_CONNECTED);
            }
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger trucks.
     */
    private class UpdateTrucks implements Runnable {

        private StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            double actualPositionInMm = s.getPosition() / 1000;
            trucksPositionLabel.setText(Double.toString(actualPositionInMm));
            handoffDigitalSwitch.setColor(s.isAtHandoff() ? greenColor : Color.gray);

            onlineDigitalSwitch.setColor(s.isAtOnline() ? greenColor : Color.gray);

            standbyDigitalSwitch.setColor(s.isAtStandby() ? greenColor : Color.gray);
            
            //ERROR Digital Switch is red as soon as there is an error 
            //on the carrier position sensors.            
            inErrorDigitalSwitch.setColor(s.isInError() ? Color.RED : greenColor);
            inErrorjLabel.setText(s.isInError() ? "IN ERROR" : "NO ERROR");
            
            inTravelDigitalSwitch.setColor((!s.isAtHandoff()
                    && !s.isAtOnline() && !s.isAtStandby()) ? Color.YELLOW : Color.gray);
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger latches.
     */
    class UpdateLatches implements Runnable {

        private StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            latchesStateLabel.setText(s.getLockStatus().toString());
            latchesStateLabel.setForeground(s.getLockStatus().getColor());
            filterPanel.setIsFilterInHouse(s.getFilterPresenceStatus().equals(FcsEnumerations.FilterPresenceStatus.ENGAGED),
                    s.getFilterName());
            if (s.getFilterPresenceStatus().equals(FcsEnumerations.FilterPresenceStatus.UNKNOWN)) {
                filterPanel.setColor(Color.YELLOW);
            }
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger ONLINE clamps.
     */
    class UpdateClamps implements Runnable {

        private StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            clampsStateLabel.setText(s.getLockStatus().toString());
            clampsStateLabel.setForeground(s.getLockStatus().getColor());
        }
    }

    public AutochangerGeneralViewPanel() {
        initComponents();
    }

    //TODO
    void initializeGui(ConfigurationInfo configInfo) {
    }

    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        SwingUtilities.invokeLater(new UpdateAutochanger(s));
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        SwingUtilities.invokeLater(new UpdateTrucks(s));
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateClamps(s));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        //LoaderConnectedPanel
        GridBagConstraints gbc0 = new GridBagConstraints();
        loaderConnectedPanel.setBorder(BorderFactory.createLineBorder(Color.pink, WIDTH + 5));
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        loaderConnectedPanel.add(loaderConnectedLabel, gbc0);
        gbc0.gridy++;
        loaderConnectedPanel.add(loaderConnectedDigitalSwitch, gbc0);

        //latches state Panel
        latchesStatePanel = new JPanel();
        GridBagConstraints gbc1 = new GridBagConstraints();
        latchesStatePanel.setBorder(BorderFactory.createTitledBorder("Latches State"));
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        latchesStatePanel.add(laSLabel, gbc1);
        gbc1.gridy++;
        latchesStatePanel.add(latchesStateLabel, gbc1);

        //filter panel
        filterPanel.setSize(120);

        //trucks Panel
        trucksStatePanel = new JPanel();
        trucksStatePanel.setBorder(BorderFactory.createTitledBorder("Trucks State"));
        trucksStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_big;

        gbc2.gridx = 0;
        gbc2.gridy = 0;
        trucksStatePanel.add(trLabel, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(trucksPositionLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(inErrorDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(inErrorjLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(inTravelDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(inTraveljLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(standbyDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(standbyjLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(handoffDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(handoffjLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(onlineDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(onlinejLabel, gbc2);

        //clamps state Panel
        clampsStatePanel = new JPanel();

        GridBagConstraints gbc3 = new GridBagConstraints();
        clampsStatePanel.setBorder(BorderFactory.createTitledBorder("ONLINE clamps State"));
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        clampsStatePanel.add(clSLabel, gbc3);
        gbc3.gridx++;
        clampsStatePanel.add(clampsStateLabel, gbc3);

        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "AUTOCHANGER General View"));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(loaderConnectedPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy++;
        add(clampsStatePanel, gbc);
        gbc.gridy++;
        add(latchesStatePanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.gridheight = 2;
        add(filterPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        add(trucksStatePanel, gbc);
        setDefaultValues();

    }
    
    /**
     * set default values for components color and labels.
     */
    private void setDefaultValues() {
        //LoaderConnectedPanel
        loaderConnectedDigitalSwitch.setColor(Color.GRAY);        
        //filter panel
        filterPanel.setIsFilterInHouse(false,"NONE");
        filterPanel.setColor(Color.gray);
         //trucks Panel
        standbyDigitalSwitch.setColor(Color.gray);
        inTravelDigitalSwitch.setColor(Color.gray);
        handoffDigitalSwitch.setColor(Color.gray);
        onlineDigitalSwitch.setColor(Color.gray);
        inErrorDigitalSwitch.setColor(Color.gray);
        trucksPositionLabel.setText(ZERO_VALUE);
        
        clampsStateLabel.setText(UNKNOWN_STATE);
        latchesStateLabel.setText(UNKNOWN_STATE);
    }
    
    /**
     * Reset Panels to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        return "General View";
    }

    public static void main(String[] argv) {

        AutochangerGeneralViewPanel d = new AutochangerGeneralViewPanel();
        JFrame frame = new JFrame("Autochanger GeneralView Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
