
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;


import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI.CommandSwingWorker;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

/**
 *
 * @author virieux
 */
public class AutochangerGUI extends GeneralGUI implements InterfaceAutochangerGUI {
    private static final long serialVersionUID = 1528028505886594591L;

    private static final String trucksModuleName = "autochangerTrucks";
    private static final String clampsName = "onlineClamps";
    private static final String latchesName = "latches";

    private final long updateTrucksPositionTimeout;
    private long timeoutForTrucksMotion;

    private final long timeoutForClosingClamps;
    private final long timeoutForOpeningClamps;

    private final long timeoutForClosingLatches;
    private final long timeoutForOpeningLatches;

    public AutochangerGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        AutochangerGatherPanel autochangerGatherPanel;
        autochangerGatherPanel = new AutochangerGatherPanel(this, CHANGER_TCPPROXY_NAME);
        AutochangerBottomPanel autochangerBottomPanel = new AutochangerBottomPanel(autochangerGatherPanel, "AUTOCHANGER");
        this.generalPanel = new GeneralPanel(this, autochangerBottomPanel);
        pane = new JScrollPane(generalPanel);

        //TODO to be initialized from the configuration system
        this.updateTrucksPositionTimeout = 1000;
        this.timeoutForTrucksMotion = 60000;
        this.timeoutForClosingClamps = 10000;
        this.timeoutForOpeningClamps = 10000;
        this.timeoutForClosingLatches = 10000;
        this.timeoutForOpeningLatches = 10000;
    }

    @Override
    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    /**
     ******************************************************************************
     ** Trucks Actions
     * *****************************************************************************
     */
    @Override
    public void updateTrucksPosition() {
        FCSLOG.info("Autochanger updating Trucks position");
        FCSLOG.info("/timeout=" + updateTrucksPositionTimeout);
        new CommandSwingWorker("updatePosition", this.updateTrucksPositionTimeout, trucksModuleName).execute();
    }

    @Override
    public void goToHandOff() {
        FCSLOG.info("Autochanger Trucks going to Handoff Position");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToHandOff", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void goToStandby() {
        FCSLOG.info("Autochanger Trucks going to Standby Position");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToStandby", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void goToOnline() {
        FCSLOG.info("Autochanger Trucks going to Online Position");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToOnline", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    /**
     ******************************************************************************
     ** end of Trucks Actions
     * *****************************************************************************
     */
    
    /**
     ******************************************************************************
     ** Clamps Actions
     * *****************************************************************************
     */
    @Override
    public void unlockOnlineClamps() {
        FCSLOG.info("Autochanger unlocking online clamps");
        FCSLOG.info("/timeout=" + timeoutForOpeningClamps);
        new CommandSwingWorker("unlockClamps", this.timeoutForOpeningClamps, clampsName).execute();
    }

    @Override
    public void lockOnlineClamps() {
        FCSLOG.info("Autochanger locking online clamps");
        FCSLOG.info("/timeout=" + timeoutForClosingClamps);
        new CommandSwingWorker("lockClamps", this.timeoutForClosingClamps, clampsName).execute();
    }

    /**
     ******************************************************************************
     ** end of Clamps Actions
     * *****************************************************************************
     */
    /**
     ******************************************************************************
     ** Latches Actions
     * *****************************************************************************
     * @param latchName
     */
    @Override
    public void closeLatch(String latchName) {
        FCSLOG.info("Autochanger locking latch: " + latchName);
        FCSLOG.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("close", this.timeoutForClosingLatches, latchName).execute();
    }

    @Override
    public void openLatch(String latchName) {
        FCSLOG.info("Autochanger unlocking latch: " + latchName);
        FCSLOG.info("/timeout=" + timeoutForOpeningLatches);
        new CommandSwingWorker("open", this.timeoutForOpeningLatches, latchName).execute();
    }

    @Override
    public void closeLatches() {
        FCSLOG.info("Autochanger locking latches.");
        FCSLOG.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("open", this.timeoutForClosingLatches, latchesName).execute();
    }

    @Override
    public void openLatches() {
        FCSLOG.info("Autochanger unlocking latches.");
        FCSLOG.info("/timeout=" + timeoutForOpeningLatches);
        new CommandSwingWorker("open", this.timeoutForOpeningLatches, latchesName).execute();
    }

    /**
     ******************************************************************************
     ** end of Latches Actions
     * *****************************************************************************
     */
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("AutochangerGUI", AgentInfo.AgentType.CONSOLE);
        AutochangerGUI t = new AutochangerGUI(agent.getName(), "testbenchCPPM", agent.getMessagingAccess());
        agent.start();

        JFrame frame = new JFrame("Autochanger View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

   
}
