/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderCarrierPanel
extends JPanel {
    private static final long serialVersionUID = 2323057246140272874L;
    private final String carrierName;
    private InterfaceLoaderGUI subs;
    private final DigitalSwitch limitSwitchUpDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch storageDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch limitSwitchDownDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel cajLabel = new JLabel("Carrier position");
    private final JLabel limitSUjLabel = new JLabel("Limit Switch Up");
    private final JLabel storagejLabel = new JLabel("Storage");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("Hand-Off");
    private final JLabel limitSDjLabel = new JLabel("Limit Switch Down");
    private final JLabel inErrorjLabel = new JLabel("In Error");
    private final JLabel handoffSensorsErrorjLabel = new JLabel();
    private final JLabel storageSensorsErrorjLabel = new JLabel();
    private final JLabel acjLabel = new JLabel("Actual Position (in mm): ");
    private final JLabel spjLabel = new JLabel("Speed (in rpm/s): ");
    private final JLabel cujLabel = new JLabel("Current (in mA): ");
    private final JLabel actualPositionjLabel = new JLabel("0");
    private final JLabel speedjLabel = new JLabel("0");
    private final JLabel currentjLabel = new JLabel("0");
    private final JProgressBar positionProgressBar = new JProgressBar(1, 0, 500);
    private final JLabel stjLabel = new JLabel("Storage Position (in mm): ");
    private final JLabel hojLabel = new JLabel("Hand-Off Position (in mm): ");
    private final JLabel smjLabel = new JLabel("Speed max (in rpm/mn): ");
    private final JLabel cmjLabel = new JLabel("Current max (in mA): ");
    private final JLabel storagePositionjLabel = new JLabel(Integer.toString(0));
    private final JLabel handoffPositionjLabel = new JLabel(Double.toString(0.0));
    private final JLabel speedMaxjLabel = new JLabel(Integer.toString(0));
    private final JLabel currentMaxjLabel = new JLabel(Integer.toString(0));
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton updatePositionButton = new JButton("updatePosition");
    private final JButton goToStorageButton = new JButton("goToStorage");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton quickStopButton = new JButton("QuickStop");
    private final JButton abortButton = new JButton("Abort");
    private JPanel faultPanel;
    private final DigitalSwitch faultSwitch = new DigitalSwitch();

    public LoaderCarrierPanel(String carrierName) {
        this.carrierName = carrierName;
        this.initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }

    private void initComponents() {
        this.updateStateWithSensorsButton.addActionListener(evt -> this.updateStateWithSensorsActionPerformed(evt));
        this.updatePositionButton.addActionListener(evt -> this.updatePositionActionPerformed(evt));
        this.goToHandoffButton.addActionListener(evt -> this.goToHandoffActionPerformed(evt));
        this.goToStorageButton.addActionListener(evt -> this.goToStorageActionPerformed(evt));
        this.quickStopButton.addActionListener(evt -> this.quickStopActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortActionPerformed(evt));
        this.setBorder(BorderFactory.createTitledBorder("LOADER CARRIER"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = Tools.insets_std;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.cajLabel.setFont(Tools.BIG_FONT);
        this.add((Component)this.cajLabel, gbc);
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.limitSUjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.limitSwitchUpDigitalSwitch, gbc);
        gbc.anchor = 12;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.storagejLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.storageDigitalSwitch, gbc);
        gbc.anchor = 13;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.inTraveljLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.inTravelDigitalSwitch, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.handoffjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.handoffDigitalSwitch, gbc);
        gbc.anchor = 12;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.limitSDjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.limitSwitchDownDigitalSwitch, gbc);
        gbc.anchor = 10;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.fill = 3;
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.positionProgressBar.setBorderPainted(true);
        this.positionProgressBar.setValue(400);
        this.positionProgressBar.setStringPainted(true);
        this.add((Component)this.positionProgressBar, gbc);
        gbc.gridheight = 1;
        JPanel errorjPanel = new JPanel();
        errorjPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        this.inErrorDigitalSwitch.setSize(60);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        errorjPanel.add((Component)this.inErrorDigitalSwitch, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.inErrorjLabel, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.storageSensorsErrorjLabel, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.handoffSensorsErrorjLabel, gbc1);
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.anchor = 10;
        this.add((Component)errorjPanel, gbc);
        JPanel paramPanel = new JPanel();
        paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        paramPanel.add((Component)this.acjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.spjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.cujLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        gbc2.anchor = 22;
        paramPanel.add((Component)this.actualPositionjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.speedjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.currentjLabel, gbc2);
        gbc.gridx = 3;
        gbc.gridy = 2;
        this.add((Component)paramPanel, gbc);
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        generalInfoPanel.add((Component)this.stjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.hojLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.smjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.cmjLabel, gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        generalInfoPanel.add((Component)this.storagePositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.handoffPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.speedMaxjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.currentMaxjLabel, gbc3);
        gbc.gridx = 3;
        gbc.gridy = 5;
        this.add((Component)generalInfoPanel, gbc);
        this.faultPanel = new JPanel();
        this.faultPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
        this.faultPanel.setLayout(new GridBagLayout());
        this.faultPanel.setPreferredSize(new Dimension(100, 100));
        this.faultSwitch.setSize(50);
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = Tools.insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = 10;
        this.faultPanel.add((Component)this.faultSwitch, gbcf);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.faultPanel, gbc);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add((Component)this.updateStateWithSensorsButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.updatePositionButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToHandoffButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToStorageButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.abortButton, gbc4);
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.weighty = 3.0;
        this.add((Component)controlPanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.limitSwitchUpDigitalSwitch.setColor(Color.gray);
        this.storageDigitalSwitch.setColor(Color.gray);
        this.inTravelDigitalSwitch.setColor(Color.gray);
        this.handoffDigitalSwitch.setColor(Color.gray);
        this.limitSwitchDownDigitalSwitch.setColor(Color.gray);
        this.inErrorDigitalSwitch.setColor(Color.gray);
        this.actualPositionjLabel.setText("0.0");
        this.speedjLabel.setText("0.0");
        this.currentjLabel.setText("0.0");
        this.faultSwitch.setColor(Color.GRAY);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void updatePositionActionPerformed(ActionEvent evt) {
        this.subs.updateCarrierPosition();
    }

    private void goToHandoffActionPerformed(ActionEvent evt) {
        this.subs.goToHandOff();
    }

    private void goToStorageActionPerformed(ActionEvent evt) {
        this.subs.goToStorage();
    }

    private void quickStopActionPerformed(ActionEvent evt) {
        this.subs.stopMyDestinationSubsystem();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    @Override
    public String toString() {
        return "Carrier Panel";
    }

    public static void main(String[] argv) {
        LoaderCarrierPanel d = new LoaderCarrierPanel("my_carrier");
        JFrame frame = new JFrame("Loader Carrier Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier status) {
            this.s = status;
        }

        @Override
        public void run() {
            LoaderCarrierPanel.this.limitSwitchUpDigitalSwitch.setColor(this.s.isLimitSwitchUpInError() ? Color.RED : Color.gray);
            LoaderCarrierPanel.this.limitSwitchDownDigitalSwitch.setColor(this.s.isLimitSwitchDownInError() ? Color.RED : Color.gray);
            LoaderCarrierPanel.this.storageDigitalSwitch.setColor(this.s.getStorageSensorValue0() == 1 && this.s.getStorageSensorValue1() == 1 ? Tools.greenColor : Color.gray);
            LoaderCarrierPanel.this.handoffDigitalSwitch.setColor(this.s.getHandoffSensorValue0() == 1 && this.s.getHandoffSensorValue1() == 1 ? Tools.greenColor : Color.gray);
            LoaderCarrierPanel.this.inTravelDigitalSwitch.setColor(this.s.getHandoffSensorValue0() == 0 && this.s.getStorageSensorValue0() == 0 && this.s.getHandoffSensorValue1() == 0 && this.s.getStorageSensorValue1() == 0 ? Color.YELLOW : Color.gray);
            LoaderCarrierPanel.this.inErrorDigitalSwitch.setColor(this.s.isHandoffInError() || this.s.isStorageInError() ? Color.RED : Tools.greenColor);
            LoaderCarrierPanel.this.inErrorjLabel.setText(this.s.isHandoffInError() || this.s.isStorageInError() ? "IN ERROR" : "NO ERROR");
            LoaderCarrierPanel.this.handoffSensorsErrorjLabel.setText(this.s.isHandoffInError() ? "<HTML>Handoff sensors<BR>in error</HTML>" : null);
            LoaderCarrierPanel.this.storageSensorsErrorjLabel.setText(this.s.isStorageInError() ? "<HTML>Storage sensors<BR>in error</HTML>" : null);
            LoaderCarrierPanel.this.positionProgressBar.setValue(this.s.getPosition());
            LoaderCarrierPanel.this.positionProgressBar.setForeground(Color.PINK);
            double actualPositionInMm = this.s.getPosition() / 1000;
            LoaderCarrierPanel.this.actualPositionjLabel.setText(Double.toString(actualPositionInMm));
            LoaderCarrierPanel.this.speedjLabel.setText(Integer.toString(this.s.getSpeed()));
            LoaderCarrierPanel.this.currentjLabel.setText(Integer.toString(this.s.getCurrent()));
            LoaderCarrierPanel.this.faultSwitch.setColor(this.s.isControllerInError() ? Color.RED : Tools.greenColor);
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForCarrier = this.configInfo.getCurrentValuesFor(LoaderCarrierPanel.this.carrierName);
            int handoffPosition = Tools.toInt(configForCarrier, "handoffPosition");
            int storagePosition = Tools.toInt(configForCarrier, "storagePosition");
            int handoffPositionInMm = handoffPosition / 1000;
            int storagePositionInMm = storagePosition / 1000;
            LoaderCarrierPanel.this.storagePositionjLabel.setText(Integer.toString(storagePositionInMm));
            LoaderCarrierPanel.this.handoffPositionjLabel.setText(Integer.toString(handoffPositionInMm));
            LoaderCarrierPanel.this.speedMaxjLabel.setText((String)configForCarrier.get("maxSpeed"));
            LoaderCarrierPanel.this.currentMaxjLabel.setText((String)configForCarrier.get("maxCurrent"));
            LoaderCarrierPanel.this.positionProgressBar.setMinimum(storagePosition);
            LoaderCarrierPanel.this.positionProgressBar.setMaximum(handoffPosition);
            LoaderCarrierPanel.this.positionProgressBar.setValue(0);
            LoaderCarrierPanel.this.faultSwitch.setColor(Color.GRAY);
            LoaderCarrierPanel.this.subs.setGoToHandoffTimeout(Tools.toInt(configForCarrier, "timeoutForGoingToHandOff"));
            LoaderCarrierPanel.this.subs.setGoToStorageTimeout(Tools.toInt(configForCarrier, "timeoutForGoingToStorage"));
        }
    }
}

