/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * DigitalSwitch.java
 *
 * Created on Oct 4, 2012, 2:11:07 AM
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 *
 * @author turri
 */
public class DigitalSwitch extends JPanel {
    private static final long serialVersionUID = -5877393948127174541L;

    private int size = 20;
    private Color color = new Color(0, 153, 0);

    /**
     * Creates new form DigitalSwitch
     */
    public DigitalSwitch() {
        initComponents();
        super.setPreferredSize(new Dimension(size, size));
    }

    /**
     * Change the size of the DigitalSwitch
     * @param size 
     */
    public void setSize(int size) {
        this.size = size;
        super.setPreferredSize(new Dimension(size, size));
    }

    @Override
    public void setBackground(Color bg) {
        setColor(bg);
    }

    public void setColor(Color c) {
        this.color = c;
        repaint();
    }


    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, 
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);

        float width = size;
        float height = size;
        float actualWidth = Math.min(width, height);

        double border = 1;

        // Draw the outline
        Shape circle = new Arc2D.Double(border, border, actualWidth - 2 * border, 
                actualWidth - 2 * border, (double)0, (double)360, Arc2D.CHORD);
        g2.setStroke(new BasicStroke(1));
        g2.setColor(color);
        g2.fill(circle);
        g2.setColor(Color.black);
        g2.draw(circle);
    }
   

    public static void main(String[] argv) {

        DigitalSwitch d = new DigitalSwitch();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
