package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.*;
import java.awt.geom.*;
import javax.swing.JFrame;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;

public class HorizontalProgressBar extends javax.swing.JPanel {
    private static final long serialVersionUID = -4788145064725502187L;

    int minValue = 0, maxValue = 100, valueA = 10, valueB = 20, valueC = 90;
    int height = 50, width = 100;
    int vinsets = 15, hinsets = 10;
    int fullHeightInBins = height - 2 * vinsets;
    int fullWidthInBins = width - 2 * hinsets;
    int value = 35;
    String position = "left";

    Color backgroundColor = new Color(212, 208, 200);
    Color fillColor = new Color(204, 205, 255);

    public HorizontalProgressBar() {
        setPreferredSize(new Dimension(width, height));
    }

    public void setPosition(String position) {
        this.position = position;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        backgroundColor = bg;
        repaint();
    }

    public void setValues(int minValue, int maxValue, int valueA, int valueB, int valueC) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueA = valueA;
        this.valueB = valueB;
        this.valueC = valueC;
        repaint();
    }

    private int convertValue(int value) {
        int fullScale = maxValue - minValue;
        double binsIncrement = ((double) fullWidthInBins) / ((double) fullScale);
        if (position.equals("left")) {
            return (int) (Math.ceil((maxValue - value) * binsIncrement));
        } else {
            return (int) ((value - minValue) * binsIncrement);
        }
    }

    public void setValueAndColor(int value, Color c) {
        this.value = value;
        this.fillColor = c;
        repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);

        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);

        Rectangle fullRectangle = new Rectangle(hinsets, vinsets, width - 2 * hinsets, fullHeightInBins);

        g2.setColor(backgroundColor);
        g2.fill(fullRectangle);

        g2.setColor(SingleFilterTestExchangePanel.getFilterPresenceColor(FilterPresenceStatus.ERROR.toString()));
        int linePosition = hinsets + convertValue(valueA);
        g2.drawLine(linePosition, vinsets + 1, linePosition, vinsets + fullHeightInBins - 1);

        g2.setColor(SingleFilterTestExchangePanel.getFilterPresenceColor(FilterPresenceStatus.LOCKABLE.toString()));
        linePosition = hinsets + convertValue(valueB);
        g2.drawLine(linePosition, vinsets + 1, linePosition, vinsets + fullHeightInBins - 1);

        g2.setColor(SingleFilterTestExchangePanel.getFilterPresenceColor(FilterPresenceStatus.NOT_LOCKABLE.toString()));
        linePosition = hinsets + convertValue(valueC);
        g2.drawLine(linePosition, vinsets + 1, linePosition, vinsets + fullHeightInBins - 1);

        g2.setColor(Color.black);
        g2.draw(fullRectangle);

        g2.setFont(new Font("system", Font.BOLD, 15));
        String valueStr = String.valueOf(value);

        g2.setColor(Color.black);
        Rectangle2D bounds = g2.getFontMetrics().getStringBounds(valueStr, g2);
        g2.drawString(valueStr, (int) (width / 2 - bounds.getWidth() / 2), (int) (vinsets - 3));

        g2.setColor(fillColor);
        linePosition = hinsets + convertValue(value);
        Rectangle fillRectangle = null;
        if (position.equals("left")) {
            fillRectangle = new Rectangle(hinsets + 1, vinsets + 1, linePosition - hinsets, fullHeightInBins - 1);
        } else {
            fillRectangle = new Rectangle(linePosition, vinsets + 1, fullWidthInBins - linePosition + hinsets, fullHeightInBins - 1);
        }

        g2.fill(fillRectangle);

        int edge = linePosition;
        int height = vinsets + fullHeightInBins + 1;
        int[] x = new int[]{edge, edge - 5, edge + 5};
        int[] y = new int[]{height, height + 4, height + 4};

        g2.fillPolygon(x, y, 3);

        g2.setColor(Color.black);
        g2.drawPolygon(x, y, 3);

    }

    public static void main(String[] argv) {

        HorizontalProgressBar d = new HorizontalProgressBar();
        d.setPosition("right");
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
