/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class PlutoGatewayPanel
extends JPanel {
    private static final long serialVersionUID = -7222037685600465352L;
    private final String gatewayName;
    private final CanOpenDevicePanel generalInfoPanel;

    public PlutoGatewayPanel(String gatewayName) {
        this.gatewayName = gatewayName;
        this.generalInfoPanel = new CanOpenDevicePanel(gatewayName);
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        this.generalInfoPanel.initializeGui(configInfo);
    }

    public void updatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
        SwingUtilities.invokeLater(new UpdatePlutoGateway(status));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
    }

    @Override
    public String toString() {
        if (this.gatewayName == null) {
            return "plutoGateway";
        }
        return this.gatewayName;
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Pluto Gateway Panel");
        PlutoGatewayPanel p = new PlutoGatewayPanel("my_plutoGateway");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdatePlutoGateway
    implements Runnable {
        StatusDataPublishedByPlutoGateway s;

        public UpdatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
            this.s = status;
        }

        @Override
        public void run() {
            PlutoGatewayPanel.this.generalInfoPanel.updateCanOpenDevice((StatusDataPublishedByHardware)this.s);
        }
    }
}

