/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.HeadlessException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.freehep.graphicsbase.swing.ErrorDialog;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;
import org.lsst.ccs.utilities.structs.TreeBranch;

public abstract class GeneralGUI
implements StatusMessageListener,
AgentPresenceListener,
Serializable {
    private static final long serialVersionUID = -3641559220265844557L;
    protected final String destination;
    protected GeneralPanel generalPanel;
    protected boolean panelStateInitialized = false;
    public JScrollPane pane;
    public long abortTimeout;
    public long updateStateWithSensorsTimeout;
    private String name;
    protected transient AgentMessagingLayer aml;
    private final transient ConcurrentMessagingUtils cmu;
    private final transient BusMessageFilter originFilter;
    private final transient BusMessageFilter dataStatusFilter;
    public long initializationTimeout;

    public GeneralGUI(String name, String destination, AgentMessagingLayer aml) {
        this.aml = aml;
        this.cmu = new ConcurrentMessagingUtils(aml);
        this.name = name;
        this.destination = destination;
        this.abortTimeout = 1000L;
        this.updateStateWithSensorsTimeout = 1000L;
        this.initializationTimeout = 2000L;
        this.originFilter = BusMessageFilter.messageOrigin((String)destination);
        this.dataStatusFilter = BusMessageFilter.messageClass(StatusSubsystemData.class);
    }

    public String getName() {
        return this.name;
    }

    public void initGui() {
        FCSCst.FCSLOG.info((Object)(this.name + ":initGUI"));
        this.aml.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.aml.addStatusMessageListener((StatusMessageListener)this, this.originFilter);
    }

    public JComponent getGuiLayout() {
        return this.pane;
    }

    public void resetGui() {
        this.generalPanel.resetPanel();
    }

    public void shutdownMyDestinationSubsystem() {
        System.out.println("Shutting down " + this.destination);
        new CommandSwingWorker("shutdown", this.abortTimeout).execute();
    }

    public void abortAction() {
        System.out.println("Aborting " + this.destination);
        new CommandSwingWorker("abort", this.abortTimeout).execute();
    }

    public void stopMyDestinationSubsystem() {
        System.out.println("Stopping " + this.destination);
        this.cmu.sendAsynchronousCommand(new CommandRequest(this.destination, "stop", new Object[]{1000L}));
    }

    public void updateStateWithSensors() {
        FCSCst.FCSLOG.info((Object)"Reading sensors");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.updateStateWithSensorsTimeout));
        new CommandSwingWorker("updateStateWithSensors", this.updateStateWithSensorsTimeout).execute();
    }

    public void completeInitialization() {
        FCSCst.FCSLOG.info((Object)"Reading sensors");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.initializationTimeout));
        new CommandSwingWorker("completeInitialization", this.initializationTimeout).execute();
    }

    public void sendCommandSwingWorker(String commandName, long timeout, String moduleName) {
        FCSCst.FCSLOG.info((Object)(this.getName() + ": sending command= " + commandName + " to Module=" + moduleName));
        new CommandSwingWorker(commandName, timeout, moduleName).execute();
    }

    public void sendCommandSwingWorker(String commandName, long timeout) {
        FCSCst.FCSLOG.info((Object)(this.getName() + ": sending command= " + commandName));
        new CommandSwingWorker(commandName, timeout).execute();
    }

    public void sendAsynchronousCommand(CommandRequest cmd) {
        this.aml.sendCommandRequest(cmd, new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processResult(CommandResult result) {
            }

            public void processNack(CommandNack nack) {
            }

            public void processError(CommandError nack) {
            }
        });
    }

    public Object sendCommand(CommandRequest cmd, long timeout) {
        try {
            FCSCst.FCSLOG.debug((Object)("fac=" + String.valueOf(this.aml)));
            SynchronousCommandAgent agent = new SynchronousCommandAgent(this.aml);
            FCSCst.FCSLOG.debug((Object)("agent=" + String.valueOf(agent)));
            FCSCst.FCSLOG.debug((Object)("command=" + String.valueOf(cmd)));
            Object response = agent.invoke(cmd, timeout);
            String strRes = String.valueOf(response);
            FCSCst.FCSLOG.debug((Object)("strRes=" + strRes));
            if (response == null) {
                return "ok : DONE";
            }
            return strRes;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    public void onStatusMessage(StatusMessage s) {
        if (!this.panelStateInitialized) {
            this.generalPanel.getSubsystemPanel().updateState(s.getState());
            this.panelStateInitialized = true;
        } else {
            if (!(s instanceof StatusStateChangeNotification)) {
                return;
            }
            this.generalPanel.getSubsystemPanel().updateState(s.getState());
        }
    }

    public void connecting(AgentInfo agent) {
        if (!agent.getName().equals(this.destination)) {
            return;
        }
        FCSCst.FCSLOG.warning((Object)(this.destination + " is connecting NOW :"));
        final List<String> hardwareList = this.getHardwareNamesForBridge("bridge", "tcpProxy");
        FCSCst.FCSLOG.debug((Object)"retrieved the list of connected hardwares");
        final List<String> filterNamesList = this.getFilterNames();
        FCSCst.FCSLOG.debug((Object)"retrieved the list of filter names");
        CommandRequest cmd = new CommandRequest(this.destination, "getConfigurationInfo");
        this.aml.sendCommandRequest(cmd, new CommandOriginator(){

            public void processAck(CommandAck ack) {
                FCSCst.FCSLOG.debug((Object)(GeneralGUI.this.destination + " has received a getConfigurationInfo command:" + ack.toString()));
            }

            public void processResult(CommandResult result) {
                try {
                    FCSCst.FCSLOG.debug((Object)("--- Got a reply to getConfigurationInfo from subs " + GeneralGUI.this.destination));
                    ConfigurationInfo configInfo = (ConfigurationInfo)result.getReply();
                    GeneralGUI.this.generalPanel.initializeGUIWithConfigInfo(configInfo, hardwareList);
                    GeneralGUI.this.generalPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
                    GeneralGUI.this.aml.addStatusMessageListener((StatusMessageListener)GeneralGUI.this.generalPanel, GeneralGUI.this.originFilter.and(GeneralGUI.this.dataStatusFilter));
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    FCSCst.FCSLOG.error((Object)(GeneralGUI.this.name + ":Error occured when initializing GUI with config info: " + ex));
                }
            }

            public void processNack(CommandNack nack) {
            }

            public void processError(CommandError nack) {
                FCSCst.FCSLOG.error((Object)("--- Error in execution of getConfigurationInfo command:" + nack.toString()));
            }
        });
    }

    private List<String> getHardwareNamesForBridge(String bridge, String tcpProxy) {
        TreeBranch treeRes;
        Future future = this.cmu.sendAsynchronousCommand(new CommandRequest(this.destination + "/" + bridge, "getComponentTree"));
        try {
            treeRes = (TreeBranch)future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            FCSCst.FCSLOG.error((Object)(" Unable to retrieve the list of hardware names." + ex));
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> listRes = new ArrayList<String>();
        for (TreeBranch child : treeRes.getChildren()) {
            if (((String)((Object)child.getContent())).equals(tcpProxy)) continue;
            listRes.add((String)((Object)child.getContent()));
        }
        return listRes;
    }

    private List<String> getFilterNames() {
        Future future = this.cmu.sendAsynchronousCommand(new CommandRequest(this.destination, "getFilterNames"));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            FCSCst.FCSLOG.error((Object)("Unable to retrieve the list of filter names." + ex));
            return Collections.emptyList();
        }
    }

    public void disconnecting(AgentInfo agent) {
        if (agent.getName().equals(this.destination)) {
            FCSCst.FCSLOG.warning((Object)(this.destination + " is disconnecting NOW"));
            this.resetGui();
        }
    }

    public class CommandSwingWorker
    extends SwingWorker<Object, Object> {
        String cmdDestination;
        String cmdName;
        long cmdTimeout;

        public CommandSwingWorker(String cmdN, long timeout) {
            if (cmdN == null) {
                throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
            }
            if (timeout == 0L) {
                throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");
            }
            this.cmdDestination = GeneralGUI.this.destination;
            this.cmdName = cmdN;
            this.cmdTimeout = timeout;
        }

        public CommandSwingWorker(String cmdN, long timeout, String moduleName) {
            if (cmdN == null) {
                throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
            }
            if (timeout == 0L) {
                throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");
            }
            if (moduleName == null) {
                throw new IllegalArgumentException("moduleName should not be null in this constructor of CommandSwingWorker");
            }
            this.cmdDestination = GeneralGUI.this.destination + "/" + moduleName;
            this.cmdName = cmdN;
            this.cmdTimeout = timeout;
        }

        @Override
        public Object doInBackground() {
            FCSCst.FCSLOG.info((Object)("Executing " + this.cmdName + " on " + this.cmdDestination));
            FCSCst.FCSLOG.info((Object)("/timeout=" + this.cmdTimeout));
            return GeneralGUI.this.sendCommand(new CommandRequest(this.cmdDestination, this.cmdName), this.cmdTimeout);
        }

        @Override
        protected void done() {
            try {
                Object response = this.get();
                if (response instanceof Throwable) {
                    FCSCst.FCSLOG.error((Object)String.valueOf(response));
                    FCSCst.FCSLOG.error((Object)" command returned error", (Throwable)response);
                    ErrorDialog.showErrorDialog(null, (Object)response.toString(), (Throwable)((Throwable)response));
                } else if (response == null) {
                    String strRes = "ok : DONE";
                    JOptionPane.showMessageDialog(null, strRes, this.cmdName, 1);
                } else {
                    String strRes = String.valueOf(response);
                    JOptionPane.showMessageDialog(null, strRes, this.cmdName, 1);
                }
            }
            catch (HeadlessException | InterruptedException | ExecutionException ex) {
                FCSCst.FCSLOG.error((Object)ex.toString());
                ErrorDialog.showErrorDialog(null, (Object)ex.toString(), (Throwable)ex);
            }
        }
    }
}

