/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class BottomPanel
extends JPanel
implements TreeSelectionListener,
StatusMessageListener {
    private static final long serialVersionUID = -447188631236670592L;
    public GatherPanel gatherPanel;
    protected final String title;
    protected JTree tree;
    protected JPanel rightPanel;
    protected final JSplitPane splitPane = new JSplitPane(1);
    protected JPanel helpPanel;

    public BottomPanel(String title) {
        this.title = title;
        this.initComponents();
    }

    public BottomPanel(GatherPanel gatherPanel, String title) {
        this.gatherPanel = gatherPanel;
        this.title = title;
        this.initComponents();
    }

    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareList);
    }

    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) throws InterruptedException, InvocationTargetException {
        this.gatherPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
    }

    public void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getHardwarePanel()));
        top.add(devicesNode);
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), this.title));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.title);
        this.createNodes(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setMinimumSize(new Dimension(110, 100));
        this.splitPane.setLeftComponent(this.tree);
        this.rightPanel = new JPanel();
        this.splitPane.setRightComponent(this.rightPanel);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setPreferredSize(Tools.preferedPanelSize);
        this.add(this.splitPane);
        this.helpPanel = new JPanel();
        JLabel helpLabel = new JLabel("Nothing to display");
        this.helpPanel.add(helpLabel);
    }

    public void onStatusMessage(StatusMessage msg) {
        this.gatherPanel.onStatusMessage(msg);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo == null) {
            return;
        }
        if (node.isLeaf()) {
            JPanel panel = (JPanel)nodeInfo;
            this.displayPanel(panel);
        }
    }

    protected void displayPanel(JPanel panel) {
        if (panel != null) {
            JScrollPane scrollPane = new JScrollPane(panel);
            this.splitPane.setRightComponent(scrollPane);
        } else {
            JScrollPane scrollPane = new JScrollPane(this.helpPanel);
            this.splitPane.setRightComponent(scrollPane);
        }
    }
}

