/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.subsystems.fcs.ui.CarouselModel;

public final class Carousel
extends JPanel {
    private static final long serialVersionUID = -8531076243930890565L;
    private transient CarouselModel model;
    private final transient ChangeListener cl = new CarouselChangeListener();

    Carousel() {
        super(new BorderLayout());
        this.setModel(new CarouselModel());
        this.add((Component)new CarouselDisk(), "Center");
    }

    public void setModel(CarouselModel model) {
        if (this.model != null) {
            model.removeChangeListener(this.cl);
        }
        this.model = model;
        model.addChangeListener(this.cl);
    }

    public CarouselModel getModel() {
        return this.model;
    }

    private class CarouselDisk
    extends JComponent {
        private static final long serialVersionUID = 8623623490718103957L;

        CarouselDisk() {
            this.setPreferredSize(new Dimension(400, 400));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.addRenderingHints(hints);
            float width = this.getWidth();
            float height = this.getHeight();
            float actualWidth = Math.min(width, height);
            float border = 10.0f;
            Arc2D.Double circle = new Arc2D.Double(border, border, actualWidth - 2.0f * border, actualWidth - 2.0f * border, 0.0, 360.0, 1);
            g2.draw(circle);
            double filterDegrees = 360.0 / (double)Carousel.this.model.getFilterNames().length;
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(5.0f));
            Arc2D.Double loader = new Arc2D.Double(border, border, actualWidth - 2.0f * border, actualWidth - 2.0f * border, 0.0, -filterDegrees, 0);
            g2.draw(loader);
            g2.setStroke(oldStroke);
            g2.rotate((double)Carousel.this.model.getRotationInDegrees() * Math.PI / 180.0, actualWidth / 2.0f, actualWidth / 2.0f);
            border *= 2.0f;
            for (String filter : Carousel.this.model.getFilterNames()) {
                boolean filterPresent;
                Arc2D.Double arc = new Arc2D.Double(border, border, actualWidth - 2.0f * border, actualWidth - 2.0f * border, 0.0, -filterDegrees, 2);
                boolean bl = filterPresent = !filter.equals(Carousel.this.model.getFilterInCamera());
                if (filterPresent) {
                    g2.draw(arc);
                }
                g2.rotate(filterDegrees * Math.PI / 360.0, actualWidth / 2.0f, actualWidth / 2.0f);
                if (filterPresent) {
                    g2.drawString(filter, actualWidth * 3.0f / 4.0f, actualWidth / 2.0f);
                }
                g2.rotate(filterDegrees * Math.PI / 360.0, actualWidth / 2.0f, actualWidth / 2.0f);
            }
        }
    }

    private class CarouselChangeListener
    implements ChangeListener {
        private CarouselChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Carousel.this.repaint();
        }
    }
}

