/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGUI;
import org.lsst.ccs.subsystems.fcs.testbench.ui.TestbenchCPPMBottomPanel;
import org.lsst.ccs.subsystems.fcs.testbench.ui.TestbenchCPPMGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

public class TestbenchCPPMGUI
extends AutochangerGUI {
    private static final long serialVersionUID = 5863389553168303099L;
    String stateCorrelId;
    private static final String trucksModuleName = "autochangerTrucks";
    private static final String clampsName = "onlineClamps";
    private static final String latchesName = "latches";
    long updateTrucksPositionTimeout;
    long timeoutForTrucksMotion;
    long timeoutForClosingClamps;
    long timeoutForOpeningClamps;
    long timeoutForClosingLatches;
    long timeoutForOpeningLatches;

    public TestbenchCPPMGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        TestbenchCPPMGatherPanel autochangerGatherPanel = new TestbenchCPPMGatherPanel(this, "tcpProxy");
        TestbenchCPPMBottomPanel autochangerBottomPanel = new TestbenchCPPMBottomPanel(autochangerGatherPanel, "AUTOCHANGER");
        this.generalPanel = new GeneralPanel(this, autochangerBottomPanel);
        this.pane = new JScrollPane(this.generalPanel);
        this.updateTrucksPositionTimeout = 1000L;
        this.timeoutForTrucksMotion = 60000L;
        this.timeoutForClosingClamps = 10000L;
        this.timeoutForOpeningClamps = 10000L;
        this.timeoutForClosingLatches = 10000L;
        this.timeoutForOpeningLatches = 10000L;
    }

    @Override
    public void updateTrucksPosition() {
        System.out.println("Autochanger updating Trucks position");
        FCSCst.FCSLOG.info((Object)"Autochanger updating Trucks position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.updateTrucksPositionTimeout));
        new GeneralGUI.CommandSwingWorker("updatePosition", this.updateTrucksPositionTimeout, trucksModuleName).execute();
    }

    @Override
    public void goToHandOff() {
        System.out.println("Autochanger Trucks going to Handoff position");
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToHandOff", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void goToStandby() {
        System.out.println("Autochanger Trucks going to Standby position");
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Standby Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToStandby", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void goToOnline() {
        System.out.println("Autochanger Trucks going to Online position");
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Online Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToOnline", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    @Override
    public void unlockOnlineClamps() {
        System.out.println("Autochanger unlocking online clamps");
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningClamps));
        new GeneralGUI.CommandSwingWorker("unlockClamps", this.timeoutForOpeningClamps, clampsName).execute();
    }

    @Override
    public void lockOnlineClamps() {
        System.out.println("Autochanger locking online clamps");
        FCSCst.FCSLOG.info((Object)"Autochanger locking online clamps");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingClamps));
        new GeneralGUI.CommandSwingWorker("lockClamps", this.timeoutForClosingClamps, clampsName).execute();
    }

    @Override
    public void closeLatch(String latchName) {
        System.out.println("Autochanger locking latch: " + latchName);
        FCSCst.FCSLOG.info((Object)("Autochanger locking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("close", this.timeoutForClosingLatches, latchName).execute();
    }

    @Override
    public void openLatch(String latchName) {
        System.out.println("Autochanger unlocking latch: " + latchName);
        FCSCst.FCSLOG.info((Object)("Autochanger unlocking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForOpeningLatches, latchName).execute();
    }

    @Override
    public void closeLatches() {
        System.out.println("Autochanger locking latches.");
        FCSCst.FCSLOG.info((Object)"Autochanger locking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForClosingLatches, latchesName).execute();
    }

    @Override
    public void openLatches() {
        System.out.println("Autochanger unlocking latches.");
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForOpeningLatches, latchesName).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("TestbenchCPPMGUI", AgentInfo.AgentType.CONSOLE);
        TestbenchCPPMGUI t = new TestbenchCPPMGUI(agent.getName(), "testbenchCPPM", agent.getMessagingAccess());
        agent.start();
        JFrame frame = new JFrame("Testbench CPPM GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

