/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.SingleFilterTestExchangePanel;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.SingleFilterTestGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;

public class SingleFilterTestGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = 7457785896732960334L;
    private static final String CLAMPXMINUS_NAME = "clampXminus";
    private static final String CLAMPXPLUS_NAME = "clampXplus";
    private CanOpenDevicePanel ai814Panel;
    private CanOpenDevicePanel ao412Panel;
    private CanOpenDevicePanel dio8n1Panel;
    private CanOpenDevicePanel dio8n2Panel;
    private EPOSControllerPanel clampXminusControllerPanel;
    private EPOSControllerPanel clampXplusControllerPanel;
    SingleFilterTestExchangePanel sftExchangePanel;

    public SingleFilterTestGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
    }

    public SingleFilterTestGatherPanel(SingleFilterTestGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
    }

    public CanOpenDevicePanel getAi814Panel() {
        return this.ai814Panel;
    }

    public CanOpenDevicePanel getAo412Panel() {
        return this.ao412Panel;
    }

    public CanOpenDevicePanel getDio8n1Panel() {
        return this.dio8n1Panel;
    }

    public CanOpenDevicePanel getDio8n2Panel() {
        return this.dio8n2Panel;
    }

    public EPOSControllerPanel getClampXminusControllerPanel() {
        return this.clampXminusControllerPanel;
    }

    public EPOSControllerPanel getClampXplusControllerPanel() {
        return this.clampXplusControllerPanel;
    }

    public SingleFilterTestExchangePanel getSftExchangePanel() {
        return this.sftExchangePanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) throws InterruptedException, InvocationTargetException {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.sftExchangePanel.initializeGui(configInfo);
        SwingUtilities.invokeAndWait(new GuiInitialization(configInfo));
    }

    public void updateClamp(StatusDataPublishedByCarouselClamp status) {
        this.sftExchangePanel.updateClamp(status);
    }

    public void updateLatch(StatusDataPublishedByAutochangerLatch status) {
        this.sftExchangePanel.updateLatch(status);
    }

    public void updateAutoChanger(StatusDataPublishedByBasicAutoChanger status) {
        this.sftExchangePanel.updateAutoChanger(status);
    }

    public void updateCarousel(StatusDataPublishedByCarousel status) {
        this.sftExchangePanel.updateCarousel(status);
    }

    public void updateActuator(StatusDataPublishedByClampActuator status) {
        this.sftExchangePanel.updateActuator(status);
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        KeyValueData data = (KeyValueData)d.getObject();
        FCSLOG.debug((Object)(this.getName() + " read data dataType:" + data.getType()));
        switch (data.getKey()) {
            case "tcpProxy": {
                this.updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
                break;
            }
            case "clampXminus": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType: " + data.getKey()));
                this.updateClamp((StatusDataPublishedByCarouselClamp)data.getValue());
                break;
            }
            case "clampXplus": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType: " + data.getKey()));
                this.updateClamp((StatusDataPublishedByCarouselClamp)data.getValue());
                break;
            }
            case "actuator": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:actuator"));
                this.updateActuator((StatusDataPublishedByClampActuator)data.getValue());
                break;
            }
            case "carousel": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:carousel"));
                this.updateCarousel((StatusDataPublishedByCarousel)data.getValue());
                break;
            }
            case "autochangerLatch": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:autochangerLatch"));
                this.updateLatch((StatusDataPublishedByAutochangerLatch)data.getValue());
                break;
            }
            case "autochanger": {
                FCSLOG.debug((Object)(this.getName() + " read data dataType:autochanger"));
                this.updateAutoChanger((StatusDataPublishedByBasicAutoChanger)data.getValue());
                break;
            }
            default: {
                FCSLOG.warning((Object)(this.getName() + " An unexpected dataType was read on the status bus:" + data.getKey()));
            }
        }
    }

    private void initPanels() {
        this.ai814Panel = new CanOpenDevicePanel("ai814");
        this.ao412Panel = new CanOpenDevicePanel("ao412");
        this.dio8n1Panel = new CanOpenDevicePanel("dio8n1");
        this.dio8n2Panel = new CanOpenDevicePanel("dio8n2");
        this.clampXminusControllerPanel = new EPOSControllerPanel("clampXminusController");
        this.clampXplusControllerPanel = new EPOSControllerPanel("clampXplusController");
        this.sftExchangePanel = new SingleFilterTestExchangePanel();
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            SingleFilterTestGatherPanel.this.clampXminusControllerPanel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.clampXplusControllerPanel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.ai814Panel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.ao412Panel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.dio8n1Panel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.dio8n2Panel.initializeGui(this.configInfo);
        }
    }
}

