/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MovementPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color standingColor = new Color(204, 205, 255);
    private int step = 15;
    private Color upArrowColor = this.standingColor;
    private Color downArrowColor = this.standingColor;

    public MovementPanel() {
        this.initComponents();
        this.setPreferredSize(new Dimension(8 * this.step, 6 * this.step));
    }

    @Override
    public void setBackground(Color bg) {
        this.setColor(bg);
    }

    public void setStatus(boolean isMovingUp, boolean isMovingDown) {
        this.upArrowColor = isMovingUp ? Color.blue : this.standingColor;
        this.downArrowColor = isMovingDown ? Color.blue : this.standingColor;
        this.repaint();
    }

    public void setColor(Color c) {
        this.standingColor = c;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);
        int step = 15;
        int[] x = new int[]{2 * step, 4 * step, 3 * step, 3 * step, 1 * step, 1 * step, 0};
        int[] y = new int[]{0, 2 * step, 2 * step, 6 * step, 6 * step, 2 * step, 2 * step};
        Polygon upArrow = new Polygon(x, y, 7);
        g2.setColor(this.upArrowColor);
        g2.fillPolygon(upArrow);
        int[] x1 = new int[]{6 * step, 4 * step, 5 * step, 5 * step, 7 * step, 7 * step, 8 * step};
        int[] y1 = new int[]{6 * step, 4 * step, 4 * step, 0, 0, 4 * step, 4 * step};
        Polygon downArrow = new Polygon(x1, y1, 7);
        g2.setColor(this.downArrowColor);
        g2.fillPolygon(downArrow);
    }

    public static void main(String[] argv) {
        MovementPanel d = new MovementPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private void initComponents() {
        this.setForeground(new Color(204, 204, 255));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

