/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 8834267363875256916L;
    private LoaderGUI subs;
    private final JLabel onCameraLabel = new JLabel("ON CAMERA SENSOR");
    private final JLabel autochangerHoldingFilterLabel = new JLabel("AUTOCHANGER HOLDING FILTER SENSOR");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final DigitalSwitch onCameraDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch autochangerHoldingFilterDigitalSwitch = new DigitalSwitch();
    private final JButton loadFilterButton = new JButton("loadFilterInCamera");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromCamera");

    public LoaderGeneralViewPanel() {
        this.initComponents();
    }

    public LoaderGeneralViewPanel(LoaderGUI subs) {
        this.subs = subs;
        this.initComponents();
    }

    public void setSubsystem(LoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
    }

    public void updateLoaderGeneral(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoaderGeneral(status));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        this.loadFilterButton.addActionListener(evt -> this.loadFilterActionPerformed(evt));
        this.unloadFilterButton.addActionListener(evt -> this.unloadFilterActionPerformed(evt));
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        this.controlPanel.add((Component)this.loadFilterButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.unloadFilterButton, gbc0);
        this.onCameraDigitalSwitch.setColor(Color.gray);
        this.autochangerHoldingFilterDigitalSwitch.setColor(Color.gray);
        this.fakeSensorsPanel.setBorder(BorderFactory.createTitledBorder("FAKE SENSORS"));
        this.fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        this.fakeSensorsPanel.add((Component)this.onCameraLabel, gbc1);
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.onCameraDigitalSwitch, gbc1);
        gbc1.insets = new Insets(0, 60, 0, 4);
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.autochangerHoldingFilterLabel, gbc1);
        gbc1.insets = Tools.insets_std;
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.autochangerHoldingFilterDigitalSwitch, gbc1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.controlPanel, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.fakeSensorsPanel, gbc);
    }

    private void loadFilterActionPerformed(ActionEvent evt) {
        this.subs.loadFilter();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        this.subs.unloadFilter();
    }

    @Override
    public String toString() {
        return "Loader General View Panel";
    }

    public static void main(String[] args) {
        LoaderGeneralViewPanel d = new LoaderGeneralViewPanel();
        JFrame frame = new JFrame("Loader Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateLoaderGeneral
    implements Runnable {
        private final StatusDataPublishedByLoader s;

        UpdateLoaderGeneral(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isLoaderOnCameraSensorsInError()) {
                LoaderGeneralViewPanel.this.onCameraDigitalSwitch.setColor(Color.RED);
            } else {
                LoaderGeneralViewPanel.this.onCameraDigitalSwitch.setColor(this.s.getLoaderOnCameraSensorValue0() == 1 ? Tools.greenColor : Color.gray);
            }
            LoaderGeneralViewPanel.this.autochangerHoldingFilterDigitalSwitch.setColor(this.s.getAutochangerHoldingFilterSensorValue() == 1 ? Tools.greenColor : Color.gray);
        }
    }
}

