/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderCarrierPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;

public class LoaderGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = 4741041603580940956L;
    private LoaderGUI subs;
    private EPOSControllerPanel hooksControllerPanel;
    private EPOSControllerPanel carrierControllerPanel;
    private PlutoGatewayPanel plutoGatewayPanel;
    private LoaderGeneralViewPanel loaderGeneralViewPanel;
    private LoaderClampPanel loaderClampPanel;
    private LoaderCarrierPanel loaderCarrierPanel;

    public LoaderGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
    }

    public LoaderGatherPanel(LoaderGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.subs = subs;
        this.initPanels();
        this.loaderGeneralViewPanel.setSubsystem(subs);
        this.loaderCarrierPanel.setSubsystem(subs);
        this.loaderClampPanel.setSubsystem(subs);
        this.hooksControllerPanel.setSubsystem(subs);
        this.carrierControllerPanel.setSubsystem(subs);
    }

    public EPOSControllerPanel getHooksControllerPanel() {
        return this.hooksControllerPanel;
    }

    public EPOSControllerPanel getCarrierControllerPanel() {
        return this.carrierControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.plutoGatewayPanel;
    }

    public LoaderGeneralViewPanel getLoaderGeneralViewPanel() {
        return this.loaderGeneralViewPanel;
    }

    public LoaderClampPanel getLoaderClampPanel() {
        return this.loaderClampPanel;
    }

    public LoaderCarrierPanel getLoaderCarrierPanel() {
        return this.loaderCarrierPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) throws InterruptedException, InvocationTargetException {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.hooksControllerPanel.initializeGui(configInfo);
        this.carrierControllerPanel.initializeGui(configInfo);
        this.plutoGatewayPanel.initializeGui(configInfo);
        this.loaderGeneralViewPanel.initializeGui(configInfo);
        this.loaderClampPanel.initializeGui(configInfo);
        this.loaderCarrierPanel.initializeGui(configInfo);
    }

    void updateLoaderGeneral(StatusDataPublishedByLoader statusDataPublishedByLoader) {
        this.loaderGeneralViewPanel.updateLoaderGeneral(statusDataPublishedByLoader);
    }

    void updateClamp(StatusDataPublishedByLoaderClamp statusDataPublishedByLoaderClamp) {
        this.loaderClampPanel.updateClamp(statusDataPublishedByLoaderClamp);
    }

    void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        this.loaderCarrierPanel.updateCarrier(statusDataPublishedByLoaderCarrier);
    }

    public void updateCarrierController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateCarrierController(status));
    }

    public void updateClampController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateClampController(status));
    }

    public void onStatusMessage(StatusMessage sm) {
        StatusSubsystemData d = (StatusSubsystemData)sm;
        KeyValueData data = (KeyValueData)d.getObject();
        FCSLOG.debug((Object)(this.subs.getName() + " read data dataType:" + d.getDataKey()));
        switch (d.getDataKey()) {
            case "loaderGeneral": {
                this.updateLoaderGeneral((StatusDataPublishedByLoader)data.getValue());
                break;
            }
            case "loaderClamp": {
                this.updateClamp((StatusDataPublishedByLoaderClamp)data.getValue());
                break;
            }
            case "loaderCarrier": {
                this.updateCarrier((StatusDataPublishedByLoaderCarrier)data.getValue());
                break;
            }
            case "tcpProxy": {
                this.updateCanOpenHardwarePanel((StatusDataPublishedByHardware)data.getValue());
                break;
            }
            case "carrierController": {
                this.updateCarrierController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            case "hooksController": {
                this.updateClampController((StatusDataPublishedByEPOSController)data.getValue());
                break;
            }
            default: {
                FCSLOG.warning((Object)("LoaderGUIModule An unexpected dataType was read on the status bus : " + d.getDataKey()));
            }
        }
    }

    private void initPanels() {
        this.hooksControllerPanel = new EPOSControllerPanel("hooksController");
        this.carrierControllerPanel = new EPOSControllerPanel("carrierController");
        this.plutoGatewayPanel = new PlutoGatewayPanel("plutoGateway");
        this.loaderGeneralViewPanel = new LoaderGeneralViewPanel();
        this.loaderClampPanel = new LoaderClampPanel("clamp");
        this.loaderCarrierPanel = new LoaderCarrierPanel("carrier");
    }

    public static void main(String[] argv) {
        LoaderGatherPanel d = new LoaderGatherPanel("loaderTcpProxy");
        JFrame frame = new JFrame("Loader High Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateClampController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateClampController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderGatherPanel.this.hooksControllerPanel.updateController(this.s);
        }
    }

    class UpdateCarrierController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateCarrierController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderGatherPanel.this.carrierControllerPanel.updateController(this.s);
        }
    }
}

