/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselClampPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselSocketPanel
extends JPanel {
    private static final long serialVersionUID = 6352712511682293959L;
    private CarouselGUI subs;
    private String socketName;
    private String clampXminusName;
    private String clampXplusName;
    private JPanel sensorsPanel;
    private CarouselClampPanel clampXminusPanel;
    private CarouselClampPanel clampXplusPanel;
    private FilterPanel filterPanel;
    private JPanel clampsStatePanel;
    private final JLabel clampsState = new JLabel("UNKNOWN STATE");
    private final JLabel clampsStateLabel = new JLabel("Clamps State :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinusLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private JPanel generalInfoPanel;
    private final JLabel nLabel = new JLabel("Name: ");
    private final JLabel nameLabel = new JLabel("socketXXX");
    private final JLabel pLabel = new JLabel("Position on Carousel: ");
    private final JLabel positionOnCarouselLabel = new JLabel("0.0");
    private final JLabel sLabel = new JLabel("Carousel position at STANDBY: ");
    private final JLabel standbyPositionLabel = new JLabel("99.999");
    private JPanel actualPositionPanel;
    private final JLabel apLabel = new JLabel("Actual position: ");
    private final JLabel actualPositionLabel = new JLabel("777.888");
    private final JLabel standbyLabel = new JLabel("NOT AT STANDBY position");
    private final DigitalSwitch standbySwitch = new DigitalSwitch();

    public CarouselSocketPanel() {
        this.socketName = "socket99";
        this.clampXminusName = "clampXminus99";
        this.clampXplusName = "clampXplus99";
        this.initComponents();
    }

    public CarouselSocketPanel(String socketName) {
        this.socketName = socketName;
        this.nameLabel.setText(socketName);
        char num = socketName.charAt(socketName.length() - 1);
        this.clampXminusName = "clampXminus" + num;
        this.clampXplusName = "clampXplus" + num;
        this.initComponents();
    }

    public CarouselSocketPanel(CarouselGUI subs) {
        this.subs = subs;
    }

    public void setSubsystem(CarouselGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        Map config = configInfo.getCurrentValuesForComponent(this.socketName);
        this.positionOnCarouselLabel.setText(Tools.getText(config, this.socketName, "positionOnCarousel"));
        this.standbyPositionLabel.setText(Tools.getText(config, this.socketName, "standbyPosition"));
        this.clampXminusPanel.initializeGui(configInfo);
        this.clampXplusPanel.initializeGui(configInfo);
    }

    public void updateSocket(StatusDataPublishedByCarouselSocket s) {
        SwingUtilities.invokeLater(new UpdateSocket(s));
    }

    public void update(StatusDataPublishedByCarouselClamp s) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " updating from carousel clamp data:" + s.toString()));
        if (s.getName().contains("Xminus")) {
            this.clampXminusPanel.updateClamp(s);
        } else if (s.getName().contains("Xplus")) {
            this.clampXplusPanel.updateClamp(s);
        } else {
            FCSCst.FCSLOG.error((Object)("Error in clamps name on STATUS bus:" + s.getName()));
        }
    }

    private void initComponents() {
        this.xMinusLabel.setFont(Tools.VERY_BIG_FONT);
        this.xMinusLabel2.setFont(Tools.VERY_BIG_FONT);
        this.xPlusLabel2.setFont(Tools.VERY_BIG_FONT);
        this.xPlusLabel.setFont(Tools.VERY_BIG_FONT);
        this.generalInfoPanel = new JPanel();
        this.generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        this.generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        this.generalInfoPanel.add((Component)this.nLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.pLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.sLabel, gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        this.generalInfoPanel.add((Component)this.nameLabel, gbc3);
        this.nameLabel.setFont(Tools.BIG_FONT);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.positionOnCarouselLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.standbyPositionLabel, gbc3);
        this.actualPositionPanel = new JPanel();
        this.actualPositionPanel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        this.actualPositionPanel.setLayout(new GridBagLayout());
        this.actualPositionPanel.setMinimumSize(new Dimension(100, 50));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.actualPositionPanel.add((Component)this.apLabel, gbc1);
        ++gbc1.gridy;
        this.actualPositionPanel.add((Component)this.standbyLabel, gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.actualPositionPanel.add((Component)this.actualPositionLabel, gbc1);
        ++gbc1.gridy;
        this.standbySwitch.setColor(Color.gray);
        this.actualPositionPanel.add((Component)this.standbySwitch, gbc1);
        this.clampsStatePanel = new JPanel();
        this.clampsState.setFont(Tools.BIG_FONT);
        this.clampsState.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        this.clampsStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        this.clampsStatePanel.add((Component)this.clampsStateLabel, gbc2);
        ++gbc2.gridx;
        this.clampsStatePanel.add((Component)this.clampsState, gbc2);
        this.clampXminusPanel = new CarouselClampPanel(this.clampXminusName);
        this.clampXplusPanel = new CarouselClampPanel(this.clampXplusName);
        this.filterPanel = new FilterPanel();
        this.filterPanel.setSize(150);
        this.filterPanel.setIsFilterInHouse(false, "NO FILTER");
        this.setBorder(BorderFactory.createLineBorder(Color.PINK));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridx;
        this.add(this.actualPositionPanel);
        gbc.anchor = 17;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.xMinusLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 10;
        this.add((Component)this.clampsStatePanel, gbc);
        gbc.anchor = 13;
        gbc.gridx = 3;
        this.add((Component)this.xPlusLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.clampXminusPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.filterPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.clampXplusPanel, gbc);
        gbc.anchor = 17;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.xMinusLabel2, gbc);
        gbc.anchor = 13;
        gbc.gridx = 3;
        this.add((Component)this.xPlusLabel2, gbc);
    }

    @Override
    public String toString() {
        if (this.socketName == null) {
            return "Unamed socket";
        }
        return this.socketName;
    }

    public static void main(String[] argv) {
        CarouselSocketPanel d = new CarouselSocketPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateSocket
    implements Runnable {
        private StatusDataPublishedByCarouselSocket s;

        public UpdateSocket(StatusDataPublishedByCarouselSocket s) {
            this.s = s;
        }

        @Override
        public void run() {
            CarouselSocketPanel.this.actualPositionLabel.setText(Double.toString(this.s.getActualPosition()));
            if (this.s.isAtStandby()) {
                CarouselSocketPanel.this.standbyLabel.setText("AT STANDBY position");
                CarouselSocketPanel.this.standbySwitch.setColor(Tools.greenColor);
            } else {
                CarouselSocketPanel.this.standbyLabel.setText("NOT AT STANDBY position");
                CarouselSocketPanel.this.standbySwitch.setColor(Color.darkGray);
            }
            CarouselSocketPanel.this.clampsState.setText(this.s.getClampState().toString());
            CarouselSocketPanel.this.clampsState.setForeground(this.s.getClampState().getColor());
            if (this.s.isEmpty()) {
                CarouselSocketPanel.this.filterPanel.setIsFilterInHouse(false, "NO FILTER");
            } else {
                CarouselSocketPanel.this.filterPanel.setIsFilterInHouse(true, this.s.getFilterName());
            }
        }
    }
}

