/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselDisk;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 3579024322081964467L;
    private static final String NONE = "None";
    private CarouselGUI subs;
    private JPanel generalInfoPanel;
    private final JLabel speedLabel = new JLabel("300.25");
    private JPanel actualParametersPanel;
    private final JLabel actualPositionLabel = new JLabel("0.0");
    private final JLabel actualSpeedLabel = new JLabel("0.0");
    private final JLabel actualCurrentLabel = new JLabel("0.0");
    private final JLabel standbyLabel = new JLabel("NOT AT STANDBY position");
    private final DigitalSwitch standbySwitch = new DigitalSwitch();
    private final JLabel socketAtStandbyLabel = new JLabel("None");
    private final JLabel filterAtStandbyLabel = new JLabel("NO FILTER");
    private final CarouselDisk carouselDisk = new CarouselDisk();

    public CarouselGeneralViewPanel() {
        this.initComponents();
    }

    protected void setSubsystem(CarouselGUI subs) {
        this.subs = subs;
    }

    protected void initializeGui(ConfigurationInfo configInfo) {
    }

    protected void update(StatusDataPublishedByCarousel s) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " updating from carousel data:" + s.toString()));
        SwingUtilities.invokeLater(new Update(s));
    }

    private void initComponents() {
        this.generalInfoPanel = new JPanel();
        this.generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        this.generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        this.generalInfoPanel.add((Component)new JLabel("Maximum speed:"), gbc3);
        ++gbc3.gridy;
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        this.generalInfoPanel.add((Component)this.speedLabel, gbc3);
        this.actualParametersPanel = new JPanel();
        this.actualParametersPanel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        this.actualParametersPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.actualParametersPanel.add((Component)new JLabel("Position: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Speed: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Current: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.standbyLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Socket at STANDBY: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Filter at STANDBY: "), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.actualParametersPanel.add((Component)this.actualPositionLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualSpeedLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualCurrentLabel, gbc1);
        ++gbc1.gridy;
        this.standbySwitch.setColor(Color.gray);
        this.actualParametersPanel.add((Component)this.standbySwitch, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.socketAtStandbyLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.filterAtStandbyLabel, gbc1);
        this.setBorder(BorderFactory.createTitledBorder("CAROUSEL GENERAL VIEW"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridx;
        this.add(this.actualParametersPanel);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)this.carouselDisk, gbc);
    }

    @Override
    public String toString() {
        return "Carousel General View";
    }

    public static void main(String[] argv) {
        CarouselGeneralViewPanel d = new CarouselGeneralViewPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class Update
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public Update(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            CarouselGeneralViewPanel.this.actualPositionLabel.setText(Double.toString(this.s.getRotationInDegrees()));
            CarouselGeneralViewPanel.this.actualSpeedLabel.setText(Double.toString(this.s.getSpeed()));
            CarouselGeneralViewPanel.this.actualCurrentLabel.setText(Double.toString(this.s.getCurrent()));
            if (this.s.isAtStandby()) {
                CarouselGeneralViewPanel.this.standbyLabel.setText("AT STANDBY position");
                CarouselGeneralViewPanel.this.standbySwitch.setColor(Tools.greenColor);
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setFont(Tools.BIG_FONT);
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.getFilterAtStandbyName());
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setFont(Tools.BIG_FONT);
            } else {
                CarouselGeneralViewPanel.this.standbyLabel.setText("NOT AT STANDBY position");
                CarouselGeneralViewPanel.this.standbySwitch.setColor(Color.RED);
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setText(CarouselGeneralViewPanel.NONE);
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setText(CarouselGeneralViewPanel.NONE);
            }
            CarouselGeneralViewPanel.this.carouselDisk.update(this.s);
        }
    }
}

